unit UUpdate;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ShellApi, StdCtrls, ExtCtrls, Buttons;

type
  TFrmUpdate = class(TForm)
    Label2: TLabel;
    btnAtualizar: TBitBtn;
    Timer1: TTimer;
    lbTempo: TLabel;
    memoInfo: TMemo;
    btnCancelar: TBitBtn;
    lbArquivos: TLabel;
    procedure btnAtualizarClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnCancelarClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    Tempo: Integer;
  public
    { Public declarations }
  end;

var
  FrmUpdate: TFrmUpdate;

implementation

{$R *.DFM}

procedure TFrmUpdate.btnAtualizarClick(Sender: TObject);
var
  atualizado: boolean;
  msg: string;
begin
  try
    cursor:= crHourGlass;
    Timer1.Enabled := false;
    lbTempo.caption:= '';

    try
      {A funo ParamStr copia os parmetros que o executvel Update.exe recebeu
      quando foi executado a partir do sistema que vai ser atualizado.
      ParamStr(1)  o primeiro parmetro que o executvel recebeu e
      ParamStr(2)  o segundo.
      O 1 parmetro indica o nome do arquivo de origem (o que foi baixado da internet),
      o 2 parmetro indica o nome do arquivo de destino (o arquivo que vai ser substitudo) }
      lbArquivos.caption:= 'Origem: ' + ParamStr(1) + #13'Destino: ' + ParamStr(2);
      //copia o arquivo da origem pro destino
      atualizado:=  CopyFile(PChar(ParamStr(1)), PChar(ParamStr(2)),false);
    except
      on e: exception do
      begin
        atualizado:= false;
        msg:= e.message;
      end;
    end;

    if atualizado then
    begin
      memoInfo.Alignment := taCenter;
      memoInfo.Text:= 'Sistema Atualizado com xito.'#13'Inicializando...';;
      //executa o software atualizado
      ShellExecute(application.handle,'open',PChar(ParamStr(2)),'','',sw_showNormal);
      close;
    end
    else
        Application.messageBox(
        PChar('No foi possvel fazer a atualizao do sistema.'#13'Mensagem de Erro: ' + msg),
        'Erro',mb_iconError)
  finally
    cursor:= crDefault;
  end;
end;

procedure TFrmUpdate.Timer1Timer(Sender: TObject);
begin
  {decrementa a varivel tempo fazendo a contagem
  regressiva de um em um segundo}
  tempo:= tempo - 1;
  lbTempo.caption:=
    'Tempo para atualizao: ' + IntToStr(tempo);
  {Se o tempo for igual a zero, a atualizao  feita
  sem a interveno do usurio, executando-se o procedimento
  click do boto btnAtualizar. }
  if tempo = 0 then
  begin
     btnAtualizar.click;
     lbTempo.caption:= '';
     timer1.enabled:= false;
  end;
end;

procedure TFrmUpdate.FormCreate(Sender: TObject);
begin
  tempo:= 31;
  lbTempo.caption:= '';
  lbArquivos.caption:= '';
end;

procedure TFrmUpdate.btnCancelarClick(Sender: TObject);
begin
  close;
end;

procedure TFrmUpdate.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  {Se o terceiro parmetro recebido pelo programa Update.exe
  for igual a 'delete_exe_origem', ento  pra deletar da pasta temporria o
  executvel que foi baixado da internet.}
  if ParamStr(3) = 'delete_exe_origem' then
     DeleteFile(ParamStr(1));
end;

end.

