{
Autor: Julio Cesar Goldschmidt
Compilao: Delphi 7
Data: 12/11/2004
}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, DBTables, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    DataSource1: TDataSource;
    Table1: TTable;
    Database1: TDatabase;
    Label1: TLabel;
    Label2: TLabel;
    OpenDialog1: TOpenDialog;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Label3: TLabel;
    Label4: TLabel;
    ComboBox1: TComboBox;
    Label5: TLabel;
    SaveDialog1: TSaveDialog;
    Button5: TButton;
    Table2: TTable;
    DataSource2: TDataSource;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure ComboBox1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

  NomeArquivo: String;
implementation
Uses
About;

////////////////////////////////////////////////////////////
// Transforma uma FieldList prara TDtrings /////////////////
////////////////////////////////////////////////////////////
Function FieldListToTStrings(Lista: TFieldList): TStrings;//
Begin                                                     //
End;                                                      //
////////////////////////////////////////////////////////////


{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
////////////////////////////////////////////////////////////
// Faz o ComboBox1 receber a lista de Fields da Table1 /////
////////////////////////////////////////////////////////////
ComboBox1.Items:= FieldListToTStrings(Table1.FieldList);  //
////////////////////////////////////////////////////////////
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
////////////////////////////////////////////////////////////
// Faz o label2 receber o o Path do arquivo ////////////////
////////////////////////////////////////////////////////////
If OpenDialog1.Execute Then                               //
Begin                                                     //
Label2.Caption:= OpenDialog1.FileName;                    //
End;                                                      //
////////////////////////////////////////////////////////////




// Verifica se h um campo selecionado /////////////////////
If (ComboBox1.Text = '') Or (Label2.Caption = '') Then
Begin
// Se no estiver selecionado
ShowMessage('Voc deve escolher um campo e um arquivo !!!');
End
Else
Begin
// Se estiver selecionado

// Abre as 2 tabelas para edio
Table1.Edit;
Table2.Edit;

// Carrega o arquivo no TBlobField
TBlobField(Table1.FieldByName(ComboBox1.Text)).LoadFromFile(Label2.Caption);

// Carrega o nome do arquivo
Table2.FieldByName(ComboBox1.Text).AsString:= ExtractFileName(OpenDialog1.FileName);

// Grava as modificaes nas 2 tabelas
Table1.Post;
Table2.Post;
End;

end;

procedure TForm1.Button4Click(Sender: TObject);
begin

// Verifica se h um campo selecionado
If ComboBox1.Text = '' Then
Begin
// Se no h um campo selecionad
ShowMessage('Voc deve escolher um campo para ver o tamanho do arquivo !!!');
End
Else
Begin
// Faz o Label4 receber o tamanho em Bytes do campo selecionado
Label4.Caption:= IntToStr(TBlobField(Table1.FieldByName(ComboBox1.Text)).BlobSize) + '  ' + 'Bytes';
End;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin

// Verifica se h um campo selecionado
If ComboBox1.Text = '' Then
Begin
// Se no h um campo selecionado
ShowMessage('Voc deve escolher um campo para esta operao !!!');
End
Else
Begin
// Se h um campo selecionado

// Com Table1 faa
with Table1 do
// Verifica se o campo selecionado no est vazio
If Not TBlobField(FieldByName(ComboBox1.Text)).IsNull Then
Begin
If SaveDialog1.Execute Then
Begin
// Abre a Table2
Table2.Open;

// Salva o arquivo para onde foi apontedo na SaveDialog1
TBlobField(FieldByName(ComboBox1.Text)).SaveToFile(SaveDialog1.FileName);
End;
End
Else
Begin
// Se o campo estiver vazio
ShowMessage('O campo no contm nenhum arquivo !!!');
End;
End;


end;

procedure TForm1.Button5Click(Sender: TObject);
begin

// verifica se h um campo selecionado
If ComboBox1.Text = '' Then
Begin
// Se no h um campo selecionado
ShowMessage('Voc deve escolher um campo para esta operao !!!');
End
Else
Begin

// Com a Table1 faa
with Table1 do
// Verifica se o campo selecionado no est vazio
If Not TBlobField(FieldByName(ComboBox1.Text)).IsNull Then
Begin
//`Pergunta se voc realmente deseja limpar o campo
If MessageDlg('Deseja Realmente Limpar o campo '+ ComboBox1.Text +  ' ?',mtconfirmation,[mbYes,mbNo],0)=mrYes Then
Begin
// Se voc realmente deseja limpar o campo

// Abre as 2 tabelas para edio
Table1.Edit;
Table2.Edit;

// Limpa o campo selecionado nas 2 tabelas
TBlobField(Table1.FieldByName(ComboBox1.Text)).Clear;
Table2.FieldByName(ComboBox1.Text).Clear;

// Grava as alteraes nas 2 tabelas
Table1.Post;
Table2.Post;
End;
End
Else
Begin
// Se o campo estiver vazio
ShowMessage('O campo j est vazio !!!');
End;
End;
end;

procedure TForm1.ComboBox1Click(Sender: TObject);
begin
// Faz os labels receberem Nada

Label2.Caption:= '';
Label4.Caption:= '';
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
// Faz a varivel receber o nome do arquivo
NomeArquivo:= Table2.FieldByName(ComboBox1.Text).AsString;
// Faz o Label2 receber a varivel NomeArquivo
Label2.Caption:= (NomeArquivo);
// faz a SaveDialog1 Receber a varivel NomeArquivo
SaveDialog1.FileName:= (NomeArquivo);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
InfoAbout.Show;
end;

end.
