unit StrUtilsEx;

interface

uses
  SysUtils;

type
  TStrUtilsEx = class
  public
    function SubstAcentos(const S: string): string;
    function RetiraDuplicatas(const S: string): string;
    function FormatNome(ANome: string): string;
    function AbreviarNome(ANome: string; AFormatNome: Boolean): string;
  end;

implementation

function TStrUtilsEx.SubstAcentos(const S: string): string;
var
  I: Word;
  accii: Byte;
begin
  Result := S;
  for I := 1 to Length(Result) do
  begin
    accii := Ord(Result[I]);
    if accii in [192..197] then Result[I] := 'A'
    else if accii in [224..229] then Result[I] := 'a'
    else if accii in [192..197] then Result[I] := 'A'
    else if accii in [224..229] then Result[I] := 'a'
    else if accii in [200..203] then Result[I] := 'E'
    else if accii in [232..235] then Result[I] := 'e'
    else if accii in [204..207] then Result[I] := 'I'
    else if accii in [236..239] then Result[I] := 'i'
    else if accii in [210..214] then Result[I] := 'O'
    else if accii in [242..246] then Result[I] := 'o'
    else if accii in [217..220] then Result[I] := 'U'
    else if accii in [249..252] then Result[I] := 'u'
  end;
end;

function TStrUtilsEx.RetiraDuplicatas(const S: string): string;
var
  I: Word;
  C: Char;
begin
  Result := S;
  if Result = '' then Exit;
  C := Result[1];
  I := 2;
  while I <= Length(Result) do
  begin
    while C = Result[I] do
      Delete(Result, I, 1);
    C := Result[I];
    Inc(I);
  end;
end;

function TStrUtilsEx.FormatNome(ANome: string): string;
var
  i, lenInput: Integer;
  c: string;
  subStr: string;
begin
  ANome := AnsiLowerCase(ANome);
  lenInput := Length(ANome);
  for i := 1 to lenInput do
  begin
    c := Copy(ANome, i, 1);
    if (c = ' ') or (i = lenInput) then
    begin
      if Length(subStr) > 3 then
        subStr := UpperCase(Copy(subStr, 1, 1)) + Copy(subStr, 2, Length(subStr));
      Result := Result + subStr + c;
      subStr := '';
    end
    else
      subStr := subStr + c;
  end;
end;

function TStrUtilsEx.AbreviarNome(ANome: String; AFormatNome: Boolean): String;
var
  LNomes: array[1..20] of string;
  I, LTotalNomes: Integer;
begin
  ANome := Trim(ANome);
  if AFormatNome then
   ANome := FormatNome(ANome);
  Result := ANome;
  ANome := ANome + #32;
  i := Pos(#32, ANome);
  if i > 0 then
  begin
    LTotalNomes := 0;
    while i > 0 do
    begin
      Inc(LTotalNomes);
      LNomes[LTotalNomes] := Copy(ANome, 1, i - 1);
      Delete(ANome, 1, i);
      I := Pos(#32, ANome);
    end;
    if LTotalNomes > 2 then
    begin
      for I := 2 to LTotalNomes - 1 do
      begin
        if Length(LNomes[i]) > 3 then
          LNomes[i] := LNomes[i][1] + '.';
      end;
      Result := '';
      for I := 1 to LTotalNomes do
        Result := Result + Trim(LNomes[i]) + #32;

      Result := Trim(Result);
    end;
  end;
end;

end.
