unit StrUtilsExTest;

interface

uses
  TestFrameWork, StrUtilsEx;

type
  TStrUtilsExTest = class(TTestCase)
  private
    FStrUtilsEx: TStrUtilsEx;
  protected
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestSubstAcentos;
    procedure TestRetiraDuplicatas;
    procedure TestFormatNome;
    procedure TestAbreviarNome;
  end;

implementation

uses
  SysUtils;

{ TStrUtilsExTest }

procedure TStrUtilsExTest.SetUp;
begin
  inherited;
  FStrUtilsEx := TStrUtilsEx.Create;
end;

procedure TStrUtilsExTest.TearDown;
begin
  FStrUtilsEx.Free;
  inherited;
end;

procedure TStrUtilsExTest.TestSubstAcentos;
var
  LStr: string;
begin
  LStr := '';
  CheckEquals('aei', FStrUtilsEx.SubstAcentos(LStr), 'String invlida');
  LStr := 'Add';
  CheckEquals('AEidd', FStrUtilsEx.SubstAcentos(LStr), 'String invlida');
  LStr := 'aaabbbccc';
  CheckEquals('aaabbbccc', FStrUtilsEx.SubstAcentos(LStr), 'String invlida');
end;

procedure TStrUtilsExTest.TestRetiraDuplicatas;
begin
  CheckEquals('ABCD', FStrUtilsEx.RetiraDuplicatas('AABBCCDD'), 'String invlida');
end;

procedure TStrUtilsExTest.TestFormatNome;
begin
  CheckEquals('Maria de Souza', FStrUtilsEx.FormatNome('maria de souza'));
  CheckEquals('Carlos de Souza Almeida', FStrUtilsEx.FormatNome('carlos de souza almeida'));
  CheckEquals('Maria Madalena', FStrUtilsEx.FormatNome('maria madalena'));
  CheckEquals('Scrates Peixoto', FStrUtilsEx.FormatNome('Scrates Peixoto'));
end;

procedure TStrUtilsExTest.TestAbreviarNome;
begin
  CheckEquals('Marcos D. B. dos Santos',
    FStrUtilsEx.AbreviarNome('Marcos Douglas Bulhes dos Santos', True), 'Nome invlido.');

  CheckEquals('Joo da Silva',
    FStrUtilsEx.AbreviarNome('Joo da Silva', True), 'Nome invlido.');

  CheckEquals('Marcos D. B. dos Santos',
    FStrUtilsEx.AbreviarNome('marcos douglas bulhes dos santos', True), 'Nome invlido.');
end;

initialization
  TestFramework.RegisterTest(TStrUtilsExTest.Suite);

end.
