unit DBGridZebrado;

interface

uses
  SysUtils, Classes, Controls, Grids, DBGrids, Graphics, ADODB, types;

type
  TDBGridZebrado = class(TDBGrid)
  private
    FZebrado: Boolean;
    FAdoQuery: TADOQUery;
    FSelectedBrushColor: TColor;
    FZebraColor: TColor;
    FSelectedFont: TFont;

    procedure PrintData(sText : string; Column : TColumn; Rect : TRect);
    procedure SetAdoQuery(const Value: TADOQUery);
    procedure SetSelectedBrushColor(const Value: TColor);
    procedure SetSelectedFont(const Value: TFont);
    procedure SetZebraColor(const Value: TColor);
    procedure SetZebrado(const Value: Boolean);
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }

    Constructor Create(AOWner : TComponent);override;

    Destructor Destroy;override;

    procedure DrawColumnCell(const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);override;

    procedure TitleClick( Column : TColumn );override;

  published
    { Published declarations }
    Property AdoQuery : TADOQUery read FAdoQuery write SetAdoQuery;
    Property SelectedBrushColor : TColor read FSelectedBrushColor write SetSelectedBrushColor;
    Property SelectedFont : TFont read FSelectedFont write SetSelectedFont;
    property ZebraColor : TColor read FZebraColor write SetZebraColor;
    property Zebrado : Boolean read FZebrado write SetZebrado;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('ActiveDelphiTremonti', [TDBGridZebrado]);
end;

{ TDBGridZebrado }

constructor TDBGridZebrado.Create(AOWner: TComponent);
begin
  inherited;
  FSelectedBrushColor := clNavy;
  FSelectedFont := TFont.Create;
  FSelectedFont.Color := clwhite;
  FZebraColor := $F0E0E0;
  FZebrado := True;
end;

destructor TDBGridZebrado.Destroy;
begin
   FSelectedFont.Free;
  inherited;
end;

procedure TDBGridZebrado.DrawColumnCell(const Rect: TRect;
  DataCol: Integer; Column: TColumn; State: TGridDrawState);
  var
  stext : string;
  begin
  inherited;

    if not Zebrado then Exit;

    if DataSource.DataSet = NIL then Exit;

    sText := Column.Field.Text;

    if gdSelected in State then
       begin
       Canvas.Brush.Color:=FSelectedBrushColor;
       Canvas.Font := FSelectedFont;
       Canvas.Rectangle(Rect);
       PrintData(sText,Column,Rect);
       end
    else if Odd( DataSource.DataSet.RecNo ) then
       begin
       Canvas.Brush.Color:=FZebraColor;
       Canvas.Rectangle(Rect);
       PrintData(sText,Column,Rect);
       end; // IF Odd

end;

procedure TDBGridZebrado.PrintData(sText: string; Column : TColumn; Rect : TRect);
var
W : Integer;
begin
W := Canvas.TextWidth(sText);

       if Column.Alignment = taLeftJustify
          then
          Canvas.TextRect(Rect, Rect.Left + 2, Rect.Top + 2, sText);

       if Column.Alignment = taRightJustify
          then
          Canvas.TextRect(Rect, Rect.Right - W - 2,Rect.Top + 2, sText);

       if Column.Alignment = taCenter
          then
          Canvas.TextRect(Rect,
                 Rect.Left + (Rect.Right-Rect.Left) div 2 - W div 2,
                 Rect.Top + 2, sText);
end;

procedure TDBGridZebrado.SetAdoQuery(const Value: TADOQUery);
begin
  FAdoQuery := Value;
end;


procedure TDBGridZebrado.SetSelectedBrushColor(const Value: TColor);
begin
  FSelectedBrushColor := Value;
  Invalidate;
end;

procedure TDBGridZebrado.SetSelectedFont(const Value: TFont);
begin
  FSelectedFont.Assign( Value );
  Invalidate;
end;

procedure TDBGridZebrado.SetZebraColor(const Value: TColor);
begin
  FZebraColor := Value;
  Invalidate;
end;

procedure TDBGridZebrado.SetZebrado(const Value: Boolean);
begin
  FZebrado := Value;
  Invalidate;
end;

procedure TDBGridZebrado.TitleClick(Column: TColumn);
var
sOrdem, s : string;
iPos, i : integer;
begin
inherited;

if FADOQuery = NIL then Exit;

if Columns.Count = 0 then Exit;

if Column.Field.Origin = '' then Exit;

sOrdem := '';
s := Column.Title.Caption;
s := Copy( s, Length( s ) - 2, 3 );

if s = '(A)' then sOrdem := ' DESC';

with FADOQuery do begin
  Close;
  iPos := Pos('ORDER BY',UpperCase(SQL.Text));
  SQL.Text := Copy(SQL.Text,1,iPos+8)+
                 '  '+Column.Field.Origin + sOrdem;
  Open;
end; // WITH

  for i := 0 to Columns.Count-1 do
    with Columns[ i ] do begin
       Color := clWhite;
       Title.Font.Style := [];
       Title.Caption := Field.DisplayLabel;
    end; // WITH

Column.Title.Font.Style := [fsBold];

if sOrdem = ' DESC' then
   Column.Title.Caption :=
            Column.Title.Caption + ' (D)'
else
   Column.Title.Caption :=
            Column.Title.Caption + ' (A)';
end;

end.
	

