unit untPrincipal;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls;

type
  TfrmPrincipal = class(TForm)
    dtpD1: TDateTimePicker;
    dtpD2: TDateTimePicker;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    btGeraRel: TBitBtn;
    btSair: TBitBtn;
    procedure btSairClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btGeraRelClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmPrincipal: TfrmPrincipal;

implementation

uses untDM, untRel;

{$R *.dfm}

procedure TfrmPrincipal.btSairClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmPrincipal.FormCreate(Sender: TObject);
  var data: string;
begin
  data:=DateToStr(Date);
  dtpD1.Date:=StrToDate('01/'+Copy(data, 4, 7));
  dtpD2.Date:=Date;
end;

procedure TfrmPrincipal.btGeraRelClick(Sender: TObject);
begin
  with DM.cdsVendas do
  begin
    Close;
    Params.ParamByName('D1').AsString:=FormatDateTime('MM/dd/yy', dtpD1.Date);
    Params.ParamByName('D2').AsString:=FormatDateTime('MM/dd/yy', dtpD2.Date);
    Open;
  end;

  try
    frmRel := TFrmRel.Create(Self);
    frmRel.QuickRep1.Preview;
  finally
    frmRel.Release;
  end;
end;

end.
