unit urdmEstoqueServer;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, ServidorEstoque_TLB, StdVcl;

type
  TEstoqueServer = class(TRemoteDataModule, IEstoqueServer)
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
    procedure AddConexao(const Usuario, IP, Sistema: WideString); safecall;
  public
    { Public declarations }
  end;

implementation

uses uPrincipal;

{$R *.DFM}

class procedure TEstoqueServer.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

procedure TEstoqueServer.AddConexao(const Usuario, IP, Sistema: WideString);
var
  Linha : String;
begin
  Linha := Usuario+' - '+IP+' - '+Sistema+' - '+DateTimeToStr(Now);
  fPrincipal.Memo2.Lines.Add(Linha);
end;

initialization
  TComponentFactory.Create(ComServer, TEstoqueServer,
    Class_EstoqueServer, ciMultiInstance, tmApartment);
end.
