program DelphiExecJava;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  JNI;

var
  JVM: TJavaVM;
  //Poderia ser um array, quando forem necessrios mais parametros para a maquina virtual
  Param: JavaVMOption;
  //Mtodo de um objeto de uma classe java
  Metodo: JMethodID;
  //Objeto de uma classe java
  JavaObj: JObject;
  JNIEnv: TJNIEnv;
  Args: JavaVMInitArgs;
  ClasseJava: JClass;
  JStr: JString;
  Erro: Integer;
begin
  //Cria o objeto Mquina Virtual
  JVM := TJavaVM.Create;
  try
    //Configuro os parametros
    Param.optionString := '-Djava.class.path=.';
    //Outras configuraes!
    Args.version := JNI_VERSION_1_2;
    Args.options := @Param;
    Args.nOptions := 1;

    //o objeto JVM acessa a Dll (jvm.dll)
    Erro := JVM.LoadVM(Args);
    if (Erro < 0) then
    begin //Erro ao carregar
      WriteLn(Format('No foi possvel carregar a mquina virtual. Erro %d.', [Erro]));
    end
    else
    begin //Mquina virtual carregada com sucesso!
      // Create a Java environment from the JVM's Env (another wrapper class)
      JNIEnv := TJNIEnv.Create(JVM.Env);

      // Procura e instancia a classe!
      ClasseJava := JNIEnv.FindClass('Carro');
      if (ClasseJava = nil) then
      begin //A classe no foi localizada
        WriteLn('A classe no foi localizada');
      end
      else
      begin //A classe foi localizada!
        // Iremos executar o construtor padro da classe localizada (Se existir)
        Metodo := JNIEnv.GetMethodID(ClasseJava, '<init>', '()V');
        if Metodo = nil then
        begin
          WriteLn('O construtor da classe no foi localizado');
        end;

        //JavaObj ser meu objeto Java instanciado no Delphi
        JavaObj := JNIEnv.NewObjectA(ClasseJava, Metodo, nil);
        if JavaObj = nil then
        begin
          WriteLn('O objeto da classe Java no foi instanciado');
        end
        else
        begin
          //Irei chamar o mtodo setVelocidadeMax passando para ele um inteiro!
          Metodo := JNIEnv.GetMethodID(ClasseJava, 'setPortas', '(I)V');
          if Metodo = nil then
          begin
            WriteLn('O mtodo no foi localizado');
          end
          else
          begin
            JNIEnv.CallVoidMethod(JavaObj, Metodo, [4]);
          end;

          //Irei chamar o mtodo setVelocidadeMax passando para ele um inteiro!
          Metodo := JNIEnv.GetMethodID(ClasseJava, 'setVelocidadeMax', '(I)V');
          if Metodo = nil then
          begin
            WriteLn('O mtodo no foi localizado');
          end
          else
          begin
            JNIEnv.CallVoidMethod(JavaObj, Metodo, [320]);
          end;

          //Irei chamar o mtodo setModelo passando para ele uma string!
          Metodo := JNIEnv.GetMethodID(ClasseJava, 'setModelo', '(Ljava/lang/String;)V');
          if Metodo = nil then
          begin
            WriteLn('O mtodo no foi localizado');
          end
          else
          begin
            JNIEnv.CallVoidMethod(JavaObj, Metodo, ['Ferrari']);
          end;

          //Irei chamar o mtodo getModelo recebendo assim uma string!
          Metodo := JNIEnv.GetMethodID(ClasseJava, 'getModelo', '()Ljava/lang/String;');
          if Metodo = nil then
          begin
            WriteLn('O mtodo no foi localizado');
          end
          else
          begin
            JStr := JNIEnv.CallObjectMethod(JavaObj, Metodo, []);
            WriteLn('Modelo: ' + JNIEnv.JStringToString(JStr));
          end;

          //Irei exibir um dialog que est dentro do cdigo java!
          Metodo := JNIEnv.GetMethodID(ClasseJava, 'Info', '()V');
          if Metodo = nil then
          begin
            WriteLn('O mtodo no foi localizado');
          end
          else
          begin
            JNIEnv.CallVoidMethod(JavaObj, Metodo, []);
          end;
        end;
      end;
      JNIEnv.Free;
    end;
  finally
    JVM.Free;
  end;
end.

