
CREATE DOMAIN Numero_Seq DOUBLE PRECISION;

CREATE DOMAIN Cod_String_20 VARCHAR(20);

CREATE DOMAIN Descricao_040 VARCHAR(40);

CREATE DOMAIN Observacao BLOB;

CREATE DOMAIN Cod_Barra VARCHAR(13);

CREATE DOMAIN Quantidade NUMERIC(15,2) DEFAULT 0;

CREATE DOMAIN Flag_String_03 VARCHAR(3);

CREATE DOMAIN Flag_String_01 VARCHAR(1);

CREATE DOMAIN Valor_2_Dec NUMERIC(15,2);

CREATE DOMAIN Codigo_06 VARCHAR(6);

CREATE DOMAIN Cod_Telefone VARCHAR(14);

CREATE DOMAIN Cod_Cnpj VARCHAR(18);

CREATE DOMAIN Cod_CTPS VARCHAR(8);

CREATE DOMAIN Cod_Rg VARCHAR(14);

CREATE DOMAIN Flag_01 VARCHAR(1);

CREATE DOMAIN Cod_ContaCorrente VARCHAR(12);

CREATE DOMAIN Cod_DV VARCHAR(1);

CREATE DOMAIN Cod_Cep VARCHAR(9);

CREATE DOMAIN Descricao_012 VARCHAR(12);

CREATE DOMAIN Codigo_04 VARCHAR(4);

CREATE DOMAIN Data DATE;

CREATE DOMAIN Descricao_010 VARCHAR(10);

CREATE DOMAIN Descricao_050 VARCHAR(50);

CREATE DOMAIN Flag_03 VARCHAR(3);

CREATE DOMAIN Imagem BLOB;

CREATE DOMAIN Descricao_005 VARCHAR(5);

CREATE DOMAIN Descricao_030 VARCHAR(30);

CREATE DOMAIN Descricao_020 VARCHAR(20);

CREATE DOMAIN Cod_String_06 VARCHAR(6);

CREATE DOMAIN Cod_String_10 VARCHAR(10);

CREATE DOMAIN Cod_String_03 VARCHAR(3);

CREATE DOMAIN Cod_String_02 VARCHAR(2);

CREATE DOMAIN Cod_String_01 VARCHAR(1);

CREATE TABLE BS_PRODUTOS (
       Num_Produto          Numero_Seq NOT NULL,
       Cod_Produto          Cod_String_20,
       Dsc_Produto          Descricao_040,
       Img_Produto          Observacao,
       Qtd_DiasValidade     Quantidade,
       Qtd_PesoBruto        Quantidade,
       Dsc_Especificacoes   BLOB,
       Flg_Liberado         Flag_String_03,
       Val_Venda            Valor_2_Dec,
       Val_UltimaCompra     Valor_2_Dec,
       Val_Custo            Valor_2_Dec,
       Per_Lucro            Valor_2_Dec,
       Val_Minimo           Valor_2_Dec
);


ALTER TABLE BS_PRODUTOS
       ADD PRIMARY KEY (Num_Produto);


CREATE TABLE BS_PESSOAS (
       Num_Pessoa           Numero_Seq NOT NULL,
       Cod_Pessoa           Codigo_06,
       Nom_Pessoa           Descricao_040,
       Cod_Telefone         Cod_Telefone,
       Cod_Celular          Cod_Telefone,
       Nom_Logradouro       Descricao_040,
       Num_Logradouro       Descricao_005,
       Cod_Rg               Cod_Rg,
       Flg_Cliente          Flag_String_01,
       Flg_Fornecedor       Flag_String_01,
       Dsc_Complemento      Descricao_010,
       Nom_Bairro           Descricao_030,
       Nom_Cidade           Descricao_030,
       Nom_Estado           Descricao_020,
       Cod_Cep              Cod_Cep,
       Img_Foto             Imagem,
       Flg_TipoPessoa       Flag_01,
       Dat_Nascimento       Data,
       Dsc_Email            Descricao_050,
       Mem_Observacao       Observacao
);


ALTER TABLE BS_PESSOAS
       ADD PRIMARY KEY (Num_Pessoa);


CREATE TABLE BS_MOVIMENTACAO (
       Num_Movimentacao     Numero_Seq NOT NULL,
       Num_Pessoa           Numero_Seq,
       Cod_NotaFiscal       Cod_String_06,
       Cod_Cefop            Cod_String_03,
       Cod_SerieNota        Cod_String_02,
       Cod_SubSerieNota     Cod_String_02,
       Dat_Entrega          Data,
       Dat_Pagamento        Data,
       Flg_TipoMovimentacao Flag_String_01,
       Val_Movimentacao     Valor_2_Dec,
       Flg_Status           Flag_String_01,
       Val_Desconto         Valor_2_Dec,
       Val_Frete            Valor_2_Dec
);


ALTER TABLE BS_MOVIMENTACAO
       ADD PRIMARY KEY (Num_Movimentacao);


CREATE TABLE BS_DETMOVIMENTACAO (
       Num_DetMovimentacao  Numero_Seq NOT NULL,
       Num_Produto          Numero_Seq,
       Num_Movimentacao     Numero_Seq,
       Qtd_Movimentacao     Quantidade,
       Qtd_Pendente         Quantidade,
       Val_Unitario         Valor_2_Dec,
       Val_Total            Valor_2_Dec,
       Val_Desconto         Valor_2_Dec
);


ALTER TABLE BS_DETMOVIMENTACAO
       ADD PRIMARY KEY (Num_DetMovimentacao);


CREATE TABLE BS_ESTOQUE (
       Num_Estoque          Numero_Seq NOT NULL,
       Num_Produto          Numero_Seq,
       Qtd_Estoque          Quantidade,
       Qtd_Reservada        Quantidade,
       Qtd_Pedida           Quantidade,
       Img_CodBarra         BLOB
);


ALTER TABLE BS_ESTOQUE
       ADD PRIMARY KEY (Num_Estoque);


ALTER TABLE BS_MOVIMENTACAO
       ADD FOREIGN KEY (Num_Pessoa)
                             REFERENCES BS_PESSOAS;


ALTER TABLE BS_DETMOVIMENTACAO
       ADD FOREIGN KEY (Num_Produto)
                             REFERENCES BS_PRODUTOS;


ALTER TABLE BS_DETMOVIMENTACAO
       ADD FOREIGN KEY (Num_Movimentacao)
                             REFERENCES BS_MOVIMENTACAO;


ALTER TABLE BS_ESTOQUE
       ADD FOREIGN KEY (Num_Produto)
                             REFERENCES BS_PRODUTOS;



