unit uCadPessoas;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ImgList, StdCtrls, DBCtrls, ComCtrls, Buttons, ExtCtrls, DB,
  RecError, FMTBcd, DBXpress, SqlExpr, DBClient, Provider,
  dbWeb, ComObj, XMLDoc, XMLIntf, Menus, Mask;

type
  TfCadPessoa = class(TForm)
    panlBotoes: TPanel;
    panlTitulo: TPanel;
    imagLista: TImageList;
    dtsoPessoas: TDataSource;
    sbarPadrao: TStatusBar;
    pgctPadrao: TPageControl;
    tabsFicha: TTabSheet;
    DBTextDestaqueS: TDBText;
    DBTextDestaqueF: TDBText;
    tbutNovo: TBitBtn;
    tbutApaga: TBitBtn;
    tbutGrava: TBitBtn;
    tbutCancela: TBitBtn;
    tbutSair: TBitBtn;
    cldsPessoas: TClientDataSet;
    cldsPessoasNUM_PESSOA: TFloatField;
    cldsPessoasCOD_PESSOA: TStringField;
    cldsPessoasNOM_PESSOA: TStringField;
    cldsPessoasCOD_TELEFONE: TStringField;
    cldsPessoasCOD_CELULAR: TStringField;
    cldsPessoasNOM_LOGRADOURO: TStringField;
    cldsPessoasNUM_LOGRADOURO: TStringField;
    cldsPessoasCOD_RG: TStringField;
    cldsPessoasFLG_CLIENTE: TStringField;
    cldsPessoasFLG_FORNECEDOR: TStringField;
    cldsPessoasDSC_COMPLEMENTO: TStringField;
    cldsPessoasNOM_BAIRRO: TStringField;
    cldsPessoasNOM_CIDADE: TStringField;
    cldsPessoasNOM_ESTADO: TStringField;
    cldsPessoasCOD_CEP: TStringField;
    cldsPessoasIMG_FOTO: TBlobField;
    cldsPessoasFLG_TIPOPESSOA: TStringField;
    cldsPessoasDAT_NASCIMENTO: TDateField;
    cldsPessoasDSC_EMAIL: TStringField;
    cldsPessoasMEM_OBSERVACAO: TBlobField;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    dbedEndereco: TDBEdit;
    dbedNumero: TDBEdit;
    dbedComplemento: TDBEdit;
    dbedBairro: TDBEdit;
    dbedCidade: TDBEdit;
    dbedTelefone: TDBEdit;
    dbedCelular: TDBEdit;
    dbedEMail: TDBEdit;
    dbcbEstado: TDBComboBox;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    dbedCodPessoa: TDBEdit;
    dbedDscPessoa: TDBEdit;
    dbrgTipoPessoa: TDBRadioGroup;
    GroupBox3: TGroupBox;
    imagPessoa: TDBImage;
    DBNavigator1: TDBNavigator;
    DBEdit1: TDBEdit;
    procedure tbutNovoClick(Sender: TObject);
    procedure tbutApagaClick(Sender: TObject);
    procedure tbutCancelaClick(Sender: TObject);
    procedure tbutGravaClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormShow(Sender: TObject);
    procedure dtsoPessoasStateChange(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure tbutSairClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure cldsPessoasReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    FocoPadrao   : TComponent;
  end;

const
 Estados : array [TDataSetState] of string =
 ('Fechado','Consultando','Alterando','Inserindo','','','','','','','','','');

var
  fCadPessoa: TfCadPessoa;

implementation

uses udmPrincipal;

{$R *.dfm}

procedure TfCadPessoa.tbutNovoClick(Sender: TObject);
begin
  (FocoPadrao as TWinControl).SetFocus;
  cldsPessoas.Insert;
end;

procedure TfCadPessoa.tbutApagaClick(Sender: TObject);
begin
  try
    if Application.MessageBox('Deseja realmente excluir o registro ?','Ateno', mb_iconquestion+mb_YesNo) = idYes then
     begin
       cldsPessoas.Delete;
       cldsPessoas.ApplyUpdates(0);
     end;
   except
     on E: Exception do
       ShowMessage('Houve algum erro na exluso. Verique a mensagem.'+#10+#13+E.Message);
  end;
end;

procedure TfCadPessoa.tbutCancelaClick(Sender: TObject);
begin
  (FocoPadrao as TWinControl).SetFocus;
  cldsPessoas.Cancel;
end;

procedure TfCadPessoa.tbutGravaClick(Sender: TObject);
begin
  try
    cldsPessoas.Post;
    if cldsPessoas.ChangeCount > 0 then
      cldsPessoas.ApplyUpdates(0);
  except
    on E: Exception do
      begin
        ShowMessage('Houve algum erro na gravao. Verique a mensagem.'+#10+#13+E.Message);
        cldsPessoas.CancelUpdates;
      end;
  end;
  (FocoPadrao as TWinControl).SetFocus;
end;

procedure TfCadPessoa.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  cldsPessoas.Close;
  Action := caFree;
end;

procedure TfCadPessoa.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if (cldsPessoas.ChangeCount > 0) or (cldsPessoas.State in [dsEdit, dsInsert]) then
    case
      Application.MessageBox('Existe uma operao pendente. Deseja Grava-la ?','Ateno', mb_iconquestion+mb_YesNo) of
      idYes :
      begin
        tbutGrava.Click;
        CanClose := true;
      end;
      idNo :
      begin
        tbutCancela.Click;
        CanClose := true;
      end;
      idCancel :
        CanClose := false;
    end;
end;

procedure TfCadPessoa.FormShow(Sender: TObject);
begin
  Left   := 0;
  Top    := 0;
end;

procedure TfCadPessoa.dtsoPessoasStateChange(Sender: TObject);
begin
  tbutNovo.Enabled           := not (cldsPessoas.State in [dsEdit, dsInsert]);
  tbutApaga.Enabled          := (not (cldsPessoas.State in [dsEdit, dsInsert])) and (not cldsPessoas.Eof);
  tbutCancela.Enabled        := (cldsPessoas.State in [dsEdit, dsInsert]);
  tbutGrava.Enabled          := (cldsPessoas.State in [dsEdit, dsInsert]);
  sbarPadrao.Panels[0].Text  := '  '+Estados[cldsPessoas.State];
end;

procedure TfCadPessoa.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
  begin
    Perform(wm_NextDlgCtl,0,0);
    Key := #0;
  end;
end;

procedure TfCadPessoa.tbutSairClick(Sender: TObject);
begin
  Close;
end;

procedure TfCadPessoa.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Shift <> [ssAlt] then
    case key of
      VK_F2     : if tbutNovo.Enabled then tbutNovo.Click;
      VK_F4     : if tbutApaga.Enabled then tbutApaga.Click;
      VK_F6     : if tbutGrava.Enabled then tbutGrava.Click;
      VK_F7     : if tbutCancela.Enabled then tbutCancela.Click;
      VK_F12    : if tbutSair.Enabled then tbutSair.Click;
      VK_ESCAPE : cldsPessoas.Cancel;
    end;
end;

procedure TfCadPessoa.cldsPessoasReconcileError(DataSet: TCustomClientDataSet;
  E: EReconcileError; UpdateKind: TUpdateKind;
  var Action: TReconcileAction);
begin
  Action := HandleReconcileError(DataSet, UpdateKind, E);
end;

procedure TfCadPessoa.FormCreate(Sender: TObject);
begin
  pgctPadrao.ActivePageIndex := 0;
  FocoPadrao                 := dbedCodPessoa; 
  DBTextDestaqueS.DataField  := DBTextDestaqueF.DataField;
  cldsPessoas.Open;
end;

end.


