unit urdmEstoqueServer;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, ServidorEstoque_TLB, StdVcl, FMTBcd, Provider, DB, SqlExpr;

type
  TEstoqueServer = class(TRemoteDataModule, IEstoqueServer)
    sqlqPessoas: TSQLQuery;
    dtspPessoas: TDataSetProvider;
    sqlqPessoasNUM_PESSOA: TFloatField;
    sqlqPessoasCOD_PESSOA: TStringField;
    sqlqPessoasNOM_PESSOA: TStringField;
    sqlqPessoasCOD_TELEFONE: TStringField;
    sqlqPessoasCOD_CELULAR: TStringField;
    sqlqPessoasNOM_LOGRADOURO: TStringField;
    sqlqPessoasNUM_LOGRADOURO: TStringField;
    sqlqPessoasCOD_RG: TStringField;
    sqlqPessoasFLG_CLIENTE: TStringField;
    sqlqPessoasFLG_FORNECEDOR: TStringField;
    sqlqPessoasDSC_COMPLEMENTO: TStringField;
    sqlqPessoasNOM_BAIRRO: TStringField;
    sqlqPessoasNOM_CIDADE: TStringField;
    sqlqPessoasNOM_ESTADO: TStringField;
    sqlqPessoasCOD_CEP: TStringField;
    sqlqPessoasIMG_FOTO: TBlobField;
    sqlqPessoasFLG_TIPOPESSOA: TStringField;
    sqlqPessoasDAT_NASCIMENTO: TDateField;
    sqlqPessoasDSC_EMAIL: TStringField;
    sqlqPessoasMEM_OBSERVACAO: TBlobField;
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
    procedure AddConexao(const Usuario, IP, Sistema: WideString); safecall;
  public
    { Public declarations }
  end;

implementation

uses uPrincipal;

{$R *.DFM}

class procedure TEstoqueServer.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

procedure TEstoqueServer.AddConexao(const Usuario, IP, Sistema: WideString);
var
  Linha : String;
begin
  Linha := Usuario+' - '+IP+' - '+Sistema+' - '+DateTimeToStr(Now);
  fPrincipal.Memo2.Lines.Add(Linha);
end;

initialization
  TComponentFactory.Create(ComServer, TEstoqueServer,
    Class_EstoqueServer, ciMultiInstance, tmApartment);
end.
