unit uCadProdutos;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ImgList, StdCtrls, DBCtrls, ComCtrls, Buttons, ExtCtrls, DB,
  RecError, FMTBcd, DBXpress, SqlExpr, DBClient, Provider,
  dbWeb, ComObj, XMLDoc, XMLIntf, Menus, Mask;

type
  TfCadProdutos = class(TForm)
    panlBotoes: TPanel;
    panlTitulo: TPanel;
    imagLista: TImageList;
    dtsoProdutos: TDataSource;
    sbarPadrao: TStatusBar;
    pgctPadrao: TPageControl;
    tabsFicha: TTabSheet;
    DBTextDestaqueS: TDBText;
    DBTextDestaqueF: TDBText;
    tbutNovo: TBitBtn;
    tbutApaga: TBitBtn;
    tbutGrava: TBitBtn;
    tbutCancela: TBitBtn;
    tbutSair: TBitBtn;
    cldsProdutos: TClientDataSet;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    dbedValidade: TDBEdit;
    dbedPeso: TDBEdit;
    dbedCusto: TDBEdit;
    dbedMinimo: TDBEdit;
    dbedVenda: TDBEdit;
    dbedLucro: TDBEdit;
    dbedUltimaCompra: TDBEdit;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    dbedCodProduto: TDBEdit;
    dbedDscProduto: TDBEdit;
    dbrgStatus: TDBRadioGroup;
    GroupBox3: TGroupBox;
    imagProduto: TDBImage;
    DBNavigator1: TDBNavigator;
    cldsProdutosNUM_PRODUTO: TFloatField;
    cldsProdutosCOD_PRODUTO: TStringField;
    cldsProdutosDSC_PRODUTO: TStringField;
    cldsProdutosIMG_PRODUTO: TBlobField;
    cldsProdutosQTD_DIASVALIDADE: TFMTBCDField;
    cldsProdutosQTD_PESOBRUTO: TFMTBCDField;
    cldsProdutosDSC_ESPECIFICACOES: TBlobField;
    cldsProdutosFLG_LIBERADO: TStringField;
    cldsProdutosVAL_VENDA: TFMTBCDField;
    cldsProdutosVAL_ULTIMACOMPRA: TFMTBCDField;
    cldsProdutosVAL_CUSTO: TFMTBCDField;
    cldsProdutosPER_LUCRO: TFMTBCDField;
    cldsProdutosVAL_MINIMO: TFMTBCDField;
    dbmmEspecificacoes: TDBMemo;
    Panel1: TPanel;
    procedure tbutNovoClick(Sender: TObject);
    procedure tbutApagaClick(Sender: TObject);
    procedure tbutCancelaClick(Sender: TObject);
    procedure tbutGravaClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormShow(Sender: TObject);
    procedure dtsoProdutosStateChange(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure tbutSairClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure cldsProdutosReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
    procedure FormCreate(Sender: TObject);
    procedure cldsProdutosBeforePost(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
    FocoPadrao   : TComponent;
  end;

const
 Estados : array [TDataSetState] of string =
 ('Fechado','Consultando','Alterando','Inserindo','','','','','','','','','');

var
  fCadProdutos: TfCadProdutos;

implementation

uses udmPrincipal;

{$R *.dfm}

procedure TfCadProdutos.tbutNovoClick(Sender: TObject);
begin
  (FocoPadrao as TWinControl).SetFocus;
  cldsProdutos.Insert;
end;

procedure TfCadProdutos.tbutApagaClick(Sender: TObject);
begin
  try
    if Application.MessageBox('Deseja realmente excluir o registro ?','Ateno', mb_iconquestion+mb_YesNo) = idYes then
     begin
       cldsProdutos.Delete;
       cldsProdutos.ApplyUpdates(0);
     end;
   except
     on E: Exception do
       ShowMessage('Houve algum erro na exluso. Verique a mensagem.'+#10+#13+E.Message);
  end;
end;

procedure TfCadProdutos.tbutCancelaClick(Sender: TObject);
begin
  (FocoPadrao as TWinControl).SetFocus;
  cldsProdutos.Cancel;
end;

procedure TfCadProdutos.tbutGravaClick(Sender: TObject);
begin
  try
    cldsProdutos.Post;
    if cldsProdutos.ChangeCount > 0 then
      cldsProdutos.ApplyUpdates(0);
  except
    on E: Exception do
      begin
        ShowMessage('Houve algum erro na gravao. Verique a mensagem.'+#10+#13+E.Message);
        cldsProdutos.CancelUpdates;
      end;
  end;
  (FocoPadrao as TWinControl).SetFocus;
end;

procedure TfCadProdutos.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  cldsProdutos.Close;
  Action := caFree;
end;

procedure TfCadProdutos.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if (cldsProdutos.ChangeCount > 0) or (cldsProdutos.State in [dsEdit, dsInsert]) then
    case
      Application.MessageBox('Existe uma operao pendente. Deseja Grava-la ?','Ateno', mb_iconquestion+mb_YesNo) of
      idYes :
      begin
        tbutGrava.Click;
        CanClose := true;
      end;
      idNo :
      begin
        tbutCancela.Click;
        CanClose := true;
      end;
      idCancel :
        CanClose := false;
    end;
end;

procedure TfCadProdutos.FormShow(Sender: TObject);
begin
  Left   := 0;
  Top    := 0;
end;

procedure TfCadProdutos.dtsoProdutosStateChange(Sender: TObject);
begin
  tbutNovo.Enabled           := not (cldsProdutos.State in [dsEdit, dsInsert]);
  tbutApaga.Enabled          := (not (cldsProdutos.State in [dsEdit, dsInsert])) and (not cldsProdutos.Eof);
  tbutCancela.Enabled        := (cldsProdutos.State in [dsEdit, dsInsert]);
  tbutGrava.Enabled          := (cldsProdutos.State in [dsEdit, dsInsert]);
  sbarPadrao.Panels[0].Text  := '  '+Estados[cldsProdutos.State];
end;

procedure TfCadProdutos.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
  begin
    Perform(wm_NextDlgCtl,0,0);
    Key := #0;
  end;
end;

procedure TfCadProdutos.tbutSairClick(Sender: TObject);
begin
  Close;
end;

procedure TfCadProdutos.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Shift <> [ssAlt] then
    case key of
      VK_F2     : if tbutNovo.Enabled then tbutNovo.Click;
      VK_F4     : if tbutApaga.Enabled then tbutApaga.Click;
      VK_F6     : if tbutGrava.Enabled then tbutGrava.Click;
      VK_F7     : if tbutCancela.Enabled then tbutCancela.Click;
      VK_F12    : if tbutSair.Enabled then tbutSair.Click;
      VK_ESCAPE : cldsProdutos.Cancel;
    end;
end;

procedure TfCadProdutos.cldsProdutosReconcileError(DataSet: TCustomClientDataSet;
  E: EReconcileError; UpdateKind: TUpdateKind;
  var Action: TReconcileAction);
begin
  Action := HandleReconcileError(DataSet, UpdateKind, E);
end;

procedure TfCadProdutos.FormCreate(Sender: TObject);
begin
  pgctPadrao.ActivePageIndex := 0;
  FocoPadrao                 := dbedCodProduto; 
  DBTextDestaqueS.DataField  := DBTextDestaqueF.DataField;
  cldsProdutos.Open;
end;

procedure TfCadProdutos.cldsProdutosBeforePost(DataSet: TDataSet);
begin
  if cldsProdutosNUM_PRODUTO.IsNull then
    cldsProdutosNUM_PRODUTO.AsFloat := dmPrincipal.cnbrPrincipal.AppServer.AutoIncremento('BS_PRODUTOS', 'NUM_PRODUTO');
end;

end.


