unit urdmEstoqueServer;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, ServidorEstoque_TLB, StdVcl, FMTBcd, Provider, DB, SqlExpr;

type
  TEstoqueServer = class(TRemoteDataModule, IEstoqueServer)
    sqlqPessoas: TSQLQuery;
    dtspPessoas: TDataSetProvider;
    sqlqPessoasNUM_PESSOA: TFloatField;
    sqlqPessoasCOD_PESSOA: TStringField;
    sqlqPessoasNOM_PESSOA: TStringField;
    sqlqPessoasCOD_TELEFONE: TStringField;
    sqlqPessoasCOD_CELULAR: TStringField;
    sqlqPessoasNOM_LOGRADOURO: TStringField;
    sqlqPessoasNUM_LOGRADOURO: TStringField;
    sqlqPessoasCOD_RG: TStringField;
    sqlqPessoasFLG_CLIENTE: TStringField;
    sqlqPessoasFLG_FORNECEDOR: TStringField;
    sqlqPessoasDSC_COMPLEMENTO: TStringField;
    sqlqPessoasNOM_BAIRRO: TStringField;
    sqlqPessoasNOM_CIDADE: TStringField;
    sqlqPessoasNOM_ESTADO: TStringField;
    sqlqPessoasCOD_CEP: TStringField;
    sqlqPessoasIMG_FOTO: TBlobField;
    sqlqPessoasFLG_TIPOPESSOA: TStringField;
    sqlqPessoasDAT_NASCIMENTO: TDateField;
    sqlqPessoasDSC_EMAIL: TStringField;
    sqlqPessoasMEM_OBSERVACAO: TBlobField;
    sqlqProdutos: TSQLQuery;
    sqlqProdutosNUM_PRODUTO: TFloatField;
    sqlqProdutosCOD_PRODUTO: TStringField;
    sqlqProdutosDSC_PRODUTO: TStringField;
    sqlqProdutosIMG_PRODUTO: TBlobField;
    sqlqProdutosQTD_DIASVALIDADE: TFMTBCDField;
    sqlqProdutosQTD_PESOBRUTO: TFMTBCDField;
    sqlqProdutosDSC_ESPECIFICACOES: TBlobField;
    sqlqProdutosFLG_LIBERADO: TStringField;
    sqlqProdutosVAL_VENDA: TFMTBCDField;
    sqlqProdutosVAL_ULTIMACOMPRA: TFMTBCDField;
    sqlqProdutosVAL_CUSTO: TFMTBCDField;
    sqlqProdutosPER_LUCRO: TFMTBCDField;
    sqlqProdutosVAL_MINIMO: TFMTBCDField;
    dtspProdutos: TDataSetProvider;
    procedure RemoteDataModuleCreate(Sender: TObject);
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
    procedure AddConexao(const Usuario, IP, Sistema: WideString); safecall;
    function AutoIncremento(const Tabela, Coluna: WideString): Double;
      safecall;
    function Get_ServidorMovimentos: IServidorMovimentos; safecall;
  public
    { Public declarations }
  end;

implementation

uses uPrincipal, urdmMovimentosServer;

{$R *.DFM}

class procedure TEstoqueServer.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

procedure TEstoqueServer.AddConexao(const Usuario, IP, Sistema: WideString);
var
  Linha : String;
begin
  Linha := Usuario+' - '+IP+' - '+Sistema+' - '+DateTimeToStr(Now);
  fPrincipal.Memo2.Lines.Add(Linha);
end;

function TEstoqueServer.AutoIncremento(const Tabela, Coluna: WideString): Double;
var
  qry : TSQLQuery;
begin
  Result := 0;
  {Cria uma instncia do objeto}
  qry := TSQLQuery.Create(nil);
  try
    qry.SQLConnection := fPrincipal.sqlcPrincipal; // Atribui a conexo ao componnete
    qry.SQL.Add('SELECT MAX('+Coluna+') FROM '+Tabela);
    qry.Open;

    if qry.Fields[0].IsNull then
      Result := 1
    else
      Result := qry.Fields[0].AsInteger + 1;
  finally
    FreeAndNil(qry);
  end;
end;

function TEstoqueServer.Get_ServidorMovimentos: IServidorMovimentos;
begin
  {Esta linha foi transferida do initialization que comentamos no RDM ServidorMovimentos alterando a varivel Factory}
  ServidorMovimentosFactory := TComponentFactory.Create(ComServer, TServidorMovimentos,
                                                        CLASS_ServidorMovimentos, ciMultiInstance,
                                                        tmBoth);
  {Faz a ligao entre os RDMs}
  Result := ServidorMovimentosFactory.CreateCOMObject(nil) as IServidorMovimentos;
end;

procedure TEstoqueServer.RemoteDataModuleCreate(Sender: TObject);
begin
  ServidorMovimentos := TServidorMovimentos.Create(Self);
end;

initialization
  TComponentFactory.Create(ComServer, TEstoqueServer,
    Class_EstoqueServer, ciMultiInstance, tmApartment);
end.
