unit urdmMovimentosServer;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, ServidorEstoque_TLB, StdVcl, FMTBcd, Provider, DB, SqlExpr;

type
  TServidorMovimentos = class(TRemoteDataModule, IServidorMovimentos)
    sqlqMovimentos: TSQLQuery;
    dtspMovimentos: TDataSetProvider;
    sqlqMovimentosNUM_MOVIMENTACAO: TFloatField;
    sqlqMovimentosNUM_PESSOA: TFloatField;
    sqlqMovimentosCOD_NOTAFISCAL: TStringField;
    sqlqMovimentosCOD_CEFOP: TStringField;
    sqlqMovimentosCOD_SERIENOTA: TStringField;
    sqlqMovimentosCOD_SUBSERIENOTA: TStringField;
    sqlqMovimentosDAT_ENTREGA: TDateField;
    sqlqMovimentosDAT_PAGAMENTO: TDateField;
    sqlqMovimentosFLG_TIPOMOVIMENTACAO: TStringField;
    sqlqMovimentosVAL_MOVIMENTACAO: TFMTBCDField;
    sqlqMovimentosFLG_STATUS: TStringField;
    sqlqMovimentosVAL_DESCONTO: TFMTBCDField;
    sqlqMovimentosVAL_FRETE: TFMTBCDField;
    sqlqDetMovimentos: TSQLQuery;
    dtspDetMovimentos: TDataSetProvider;
    sqlqDetMovimentosNUM_DETMOVIMENTACAO: TFloatField;
    sqlqDetMovimentosNUM_PRODUTO: TFloatField;
    sqlqDetMovimentosNUM_MOVIMENTACAO: TFloatField;
    sqlqDetMovimentosQTD_MOVIMENTACAO: TFMTBCDField;
    sqlqDetMovimentosQTD_PENDENTE: TFMTBCDField;
    sqlqDetMovimentosVAL_UNITARIO: TFMTBCDField;
    sqlqDetMovimentosVAL_TOTAL: TFMTBCDField;
    sqlqDetMovimentosVAL_DESCONTO: TFMTBCDField;
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
  public
    { Public declarations }
  end;

var
  ServidorMovimentos : TServidorMovimentos;
  ServidorMovimentosFactory : TComponentFactory;

implementation

uses uPrincipal, urdmEstoqueServer;

{$R *.DFM}

class procedure TServidorMovimentos.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

initialization
//  TComponentFactory.Create(ComServer, TServidorMovimentos,
//    Class_ServidorMovimentos, ciMultiInstance, tmApartment);
end.
