{*******************************************************************************
  uExcelDemo
  Copyright(C) 2005 by Brazil Systems
  Descrio: Demonstrao do compomente TmmExcel
*******************************************************************************}
{$I mmControls.inc}

unit uExcelDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, mmExcel, StdCtrls {$IFDEF MM_D6_UP}, Variants{$ENDIF};

type
  TForm1 = class(TForm)
    btnCores: TButton;
    Label1: TLabel;
    btnFormulas: TButton;
    btnPlanilhas: TButton;
    btnFontes: TButton;
    btnCelulas: TButton;
    Excel: TmmExcel;
    procedure btnCoresClick(Sender: TObject);
    procedure btnFormulasClick(Sender: TObject);
    procedure btnPlanilhasClick(Sender: TObject);
    procedure btnFontesClick(Sender: TObject);
    procedure btnCelulasClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.btnCoresClick(Sender: TObject);
begin
  if Excel.OpenExcel() = False then Exit;
  Excel.Visible := True;

  Excel.SetColWidth(20, 'B1', 'B1');

  Excel.CellColor := ccNone;
  Excel.SetColor('A1', 'A1');
  Excel.WriteCell(1, 2, 'ccNone');

  Excel.CellColor := ccBlack;
  Excel.SetColor('A2', 'A2');
  Excel.WriteCell(2, 2, 'ccBlack');

  Excel.CellColor := ccWhite;
  Excel.SetColor('A3', 'A3');
  Excel.WriteCell(3, 2, 'ccWhite');

  Excel.CellColor := ccRed;
  Excel.SetColor('A4', 'A4');
  Excel.WriteCell(4, 2, 'ccRed');

  Excel.CellColor := ccLime;
  Excel.SetColor('A5', 'A5');
  Excel.WriteCell(5, 2, 'ccLime');

  Excel.CellColor := ccBlue;
  Excel.SetColor('A6', 'A6');
  Excel.WriteCell(6, 2, 'ccBlue');

  Excel.CellColor := ccYellow;
  Excel.SetColor('A7', 'A7');
  Excel.WriteCell(7, 2, 'ccYellow');

  Excel.CellColor := ccFuchsia;
  Excel.SetColor('A8', 'A8');
  Excel.WriteCell(8, 2, 'ccFuchsia');

  Excel.CellColor := ccCyan;
  Excel.SetColor('A9', 'A9');
  Excel.WriteCell(9, 2, 'ccCyan');

  Excel.CellColor := ccMaroon;
  Excel.SetColor('A10', 'A10');
  Excel.WriteCell(10, 2, 'ccMaroon');

  Excel.CellColor := ccGreen;
  Excel.SetColor('A11', 'A11');
  Excel.WriteCell(11, 2, 'ccGreen');

  Excel.CellColor := ccNavy;
  Excel.SetColor('A12', 'A12');
  Excel.WriteCell(12, 2, 'ccNavy');

  Excel.CellColor := ccOlive;
  Excel.SetColor('A13', 'A13');
  Excel.WriteCell(13, 2, 'ccOlive');

  Excel.CellColor := ccPurple;
  Excel.SetColor('A14', 'A14');
  Excel.WriteCell(14, 2, 'ccPurple');

  Excel.CellColor := ccTeal;
  Excel.SetColor('A15', 'A15');
  Excel.WriteCell(15, 2, 'ccTeal');

  Excel.CellColor := ccSilver;
  Excel.SetColor('A16', 'A16');
  Excel.WriteCell(16, 2, 'ccSilver');

  Excel.CellColor := ccGray;
  Excel.SetColor('A17', 'A17');
  Excel.WriteCell(17, 2, 'ccGray');

  Excel.CellColor := ccAutumn;
  Excel.SetColor('A18', 'A18');
  Excel.WriteCell(18, 2, 'ccAutumn');

  Excel.CellColor := ccBullet;
  Excel.SetColor('A19', 'A19');
  Excel.WriteCell(19, 2, 'ccBullet');

  Excel.SetColWidth(20, 'D1', 'D1');

  Excel.CellColor := ccIvory;
  Excel.SetColor('C1', 'C1');
  Excel.WriteCell(1, 4, 'ccIvory');

  Excel.CellColor := ccLavender;
  Excel.SetColor('C2', 'C2');
  Excel.WriteCell(2, 4, 'ccLavender');

  Excel.CellColor := ccViolet;
  Excel.SetColor('C3', 'C3');
  Excel.WriteCell(3, 4, 'ccViolet');

  Excel.CellColor := ccSalmon;
  Excel.SetColor('C4', 'C4');
  Excel.WriteCell(4, 4, 'ccSalmon');

  Excel.CellColor := ccWinter;
  Excel.SetColor('C5', 'C5');
  Excel.WriteCell(5, 4, 'ccWinter');

  Excel.CellColor := ccPallidBlue;
  Excel.SetColor('C6', 'C6');
  Excel.WriteCell(6, 4, 'ccPallidBlue');

  Excel.CellColor := ccDarkPetroleum;
  Excel.SetColor('C7', 'C7');
  Excel.WriteCell(7, 4, 'ccDarkPetroleum');

  Excel.CellColor := ccPink;
  Excel.SetColor('C8', 'C8');
  Excel.WriteCell(8, 4, 'ccPink');

  Excel.CellColor := ccYellowColor;
  Excel.SetColor('C9', 'C9');
  Excel.WriteCell(9, 4, 'ccYellowColor');

  Excel.CellColor := ccLightGreen;
  Excel.SetColor('C10', 'C10');
  Excel.WriteCell(10, 4, 'ccLightGreen');

  Excel.CellColor := ccVioletColor;
  Excel.SetColor('C11', 'C11');
  Excel.WriteCell(11, 4, 'ccVioletColor');

  Excel.CellColor := ccMaroonColor;
  Excel.SetColor('C12', 'C12');
  Excel.WriteCell(12, 4, 'ccMaroonColor');

  Excel.CellColor := ccPetroleum;
  Excel.SetColor('C13', 'C13');
  Excel.WriteCell(13, 4, 'ccPetroleum');

  Excel.CellColor := ccBlueColor;
  Excel.SetColor('C14', 'C14');
  Excel.WriteCell(14, 4, 'ccBlueColor');

  Excel.CellColor := ccTurquoise;
  Excel.SetColor('C15', 'C15');
  Excel.WriteCell(15, 4, 'ccTurquoise');

  Excel.CellColor := ccPallidGreen;
  Excel.SetColor('C16', 'C16');
  Excel.WriteCell(16, 4, 'ccPallidGreen');

  Excel.CellColor := ccMoney;
  Excel.SetColor('C17', 'C17');
  Excel.WriteCell(17, 4, 'ccMoney');

  Excel.CellColor := ccLightYellow;
  Excel.SetColor('C18', 'C18');
  Excel.WriteCell(18, 4, 'ccLightYellow');

  Excel.CellColor := ccIce;
  Excel.SetColor('C19', 'C19');
  Excel.WriteCell(19, 4, 'ccIce');

  Excel.SetColWidth(20, 'F1', 'F1');

  Excel.CellColor := ccLightPink;
  Excel.SetColor('E1', 'E1');
  Excel.WriteCell(1, 6, 'ccLightPink');

  Excel.CellColor := ccLightViolet;
  Excel.SetColor('E2', 'E2');
  Excel.WriteCell(2, 6, 'ccLightViolet');

  Excel.CellColor := ccCream;
  Excel.SetColor('E3', 'E3');
  Excel.WriteCell(3, 6, 'ccCream');

  Excel.CellColor := ccSkyColor;
  Excel.SetColor('E4', 'E4');
  Excel.WriteCell(4, 6, 'ccSkyColor');

  Excel.CellColor := ccWaterGreen;
  Excel.SetColor('E5', 'E5');
  Excel.WriteCell(5, 6, 'ccWaterGreen');

  Excel.CellColor := ccLemon;
  Excel.SetColor('E6', 'E6');
  Excel.WriteCell(6, 6, 'ccLemon');

  Excel.CellColor := ccGold;
  Excel.SetColor('E7', 'E7');
  Excel.WriteCell(7, 6, 'ccGold');

  Excel.CellColor := ccOrange;
  Excel.SetColor('E8', 'E8');
  Excel.WriteCell(8, 6, 'ccOrange');

  Excel.CellColor := ccSummer;
  Excel.SetColor('E9', 'E9');
  Excel.WriteCell(9, 6, 'ccSummer');

  Excel.CellColor := ccMediumBlue;
  Excel.SetColor('E10', 'E10');
  Excel.WriteCell(10, 6, 'ccMediumBlue');

  Excel.CellColor := ccGray40;
  Excel.SetColor('E11', 'E11');
  Excel.WriteCell(11, 6, 'ccGray40');

  Excel.CellColor := ccDarkBlue;
  Excel.SetColor('E12', 'E12');
  Excel.WriteCell(12, 6, 'ccDarkBlue');

  Excel.CellColor := ccSpring;
  Excel.SetColor('E13', 'E13');
  Excel.WriteCell(13, 6, 'ccSpring');

  Excel.CellColor := ccBlackGreen;
  Excel.SetColor('E14', 'E14');
  Excel.WriteCell(14, 6, 'ccBlackGreen');

  Excel.CellColor := ccGray80;
  Excel.SetColor('E15', 'E15');
  Excel.WriteCell(15, 6, 'ccGray80');

  Excel.CellColor := ccDarkRed;
  Excel.SetColor('E16', 'E16');
  Excel.WriteCell(16, 6, 'ccDarkRed');

  Excel.CellColor := ccBulletColor;
  Excel.SetColor('E17', 'E17');
  Excel.WriteCell(17, 6, 'ccBulletColor');

  Excel.CellColor := ccIndianBlue;
  Excel.SetColor('E18', 'E18');
  Excel.WriteCell(18, 6, 'ccIndianBlue');

  Excel.CellColor := ccGray90;
  Excel.SetColor('E19', 'E19');
  Excel.WriteCell(19, 6, 'ccGray90');
end;

procedure TForm1.btnFormulasClick(Sender: TObject);
begin
  if Excel.OpenExcel() = False then Exit;
  Excel.Visible := True;
  Excel.SetColWidth(20, 'A1', 'A1');
  Excel.FormulaExcel(1, 1, 'Now()');
  Excel.WriteCell(3, 1, '100');
  Excel.WriteCell(4, 1, '100');
  Excel.WriteCell(5, 1, '100');
  Excel.WriteCell(6, 1, '100');
  Excel.WriteCell(7, 1, '100');
  Excel.FormulaExcel(8, 1, 'SUM(A3:A7');
end;

procedure TForm1.btnPlanilhasClick(Sender: TObject);
begin
  Excel.InitialSheets := 12;
  if Excel.OpenExcel() = False then Exit;
  Excel.Visible := True;
  Excel.RenameSheet('Jan 2004', 1);
  Excel.RenameSheet('Fev 2004', 2);
  Excel.RenameSheet('Mar 2004', 3);
  Excel.RenameSheet('Abr 2004', 4);
  Excel.RenameSheet('Mai 2004', 5);
  Excel.RenameSheet('Jun 2004', 6);
  Excel.RenameSheet('Jul 2004', 7);
  Excel.RenameSheet('Ago 2004', 8);
  Excel.RenameSheet('Set 2004', 9);
  Excel.RenameSheet('Out 2004', 10);
  Excel.RenameSheet('Nov 2004', 11);
  Excel.RenameSheet('Dez 2004', 12);
  Excel.ChangeSheet(1);
end;

procedure TForm1.btnFontesClick(Sender: TObject);
begin
  if Excel.OpenExcel() = False then Exit;
  Excel.Visible := True;

  Excel.MergeCell('A1', 'I1');
  Excel.SetCellFontName('Times New Roman', 'A1', 'I1');
  Excel.SetCellFontSize(24, 'A1', 'I1');
  Excel.SetCellFontColor(clBlue, 'A1', 'I1');
  Excel.SetCellFontStyle(fsBoldItalic, 'A1', 'I1');
  //Excel.SetCellFontStyle(fsNormal, 'A1', 'I1');
  //Excel.SetCellFontStyle(fsItalic, 'A1', 'I1');
  //Excel.SetCellFontStyle(fsBold, 'A1', 'I1');
  Excel.WriteCell(1, 1, 'TIMES NEW ROMAN');

  Excel.SetCellColor(ccLavender, 'A2', 'I2');
  Excel.SetCellFontFull('A2', 'I2', 'Couriew New', clMaroon, 12);
  Excel.WriteCell(2, 1, 'Courier New');
end;

procedure TForm1.btnCelulasClick(Sender: TObject);
begin
  if Excel.OpenExcel() = False then Exit;
  Excel.Visible := True;

  Excel.SetColWidth(20, 'A1', 'A1');
  Excel.SetRowHeight(40, 'A1', 'A1');

// Outra maneira de obter o mesmo resultado:
  //Excel.SetCellColWidth(20, 1, 1);
  //Excel.SetCellRowHeight(40, 1, 1);

  Excel.WriteCellEx('AA', 1, 'Clula AA1');
  Excel.WriteCellEx('AA', 2, 'Clula AA2');
  Excel.WriteCellEx('AA', 3, 'Clula AA3');
end;

end.
