unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, shDataSet;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    DataGrid1: System.Windows.Forms.DataGrid;
    lklblLoad: System.Windows.Forms.LinkLabel;
    lklblSave: System.Windows.Forms.LinkLabel;
    RichTextBox1: System.Windows.Forms.RichTextBox;
    LinkLabel1: System.Windows.Forms.LinkLabel;
    LinkLabel2: System.Windows.Forms.LinkLabel;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TWinForm_Load(sender: System.Object; e: System.EventArgs);
    procedure LinkLabel2_LinkClicked(sender: System.Object; e: System.Windows.Forms.LinkLabelLinkClickedEventArgs);
    procedure lklblLoad_LinkClicked(sender: System.Object; e: System.Windows.Forms.LinkLabelLinkClickedEventArgs);
    procedure LinkLabel1_LinkClicked(sender: System.Object; e: System.Windows.Forms.LinkLabelLinkClickedEventArgs);
    procedure LinkLabel2_LinkClicked1(sender: System.Object; e: System.Windows.Forms.LinkLabelLinkClickedEventArgs);
  private
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
    ds : TshDataSet;  //classe TshDataSet erda de Dataset verificar na unit shDataSet.pas
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.DataGrid1 := System.Windows.Forms.DataGrid.Create;
  Self.lklblLoad := System.Windows.Forms.LinkLabel.Create;
  Self.lklblSave := System.Windows.Forms.LinkLabel.Create;
  Self.RichTextBox1 := System.Windows.Forms.RichTextBox.Create;
  Self.LinkLabel1 := System.Windows.Forms.LinkLabel.Create;
  Self.LinkLabel2 := System.Windows.Forms.LinkLabel.Create;
  (System.ComponentModel.ISupportInitialize(Self.DataGrid1)).BeginInit;
  Self.SuspendLayout;
  // 
  // DataGrid1
  // 
  Self.DataGrid1.AlternatingBackColor := System.Drawing.Color.WhiteSmoke;
  Self.DataGrid1.BackColor := System.Drawing.Color.Gainsboro;
  Self.DataGrid1.BackgroundColor := System.Drawing.Color.DarkGray;
  Self.DataGrid1.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.DataGrid1.CaptionBackColor := System.Drawing.Color.DarkKhaki;
  Self.DataGrid1.CaptionFont := System.Drawing.Font.Create('Microsoft Sans S' +
    'erif', 8);
  Self.DataGrid1.CaptionForeColor := System.Drawing.Color.Black;
  Self.DataGrid1.DataMember := '';
  Self.DataGrid1.FlatMode := True;
  Self.DataGrid1.Font := System.Drawing.Font.Create('Microsoft Sans Serif', 8);
  Self.DataGrid1.ForeColor := System.Drawing.Color.Black;
  Self.DataGrid1.GridLineColor := System.Drawing.Color.Silver;
  Self.DataGrid1.HeaderBackColor := System.Drawing.Color.Black;
  Self.DataGrid1.HeaderFont := System.Drawing.Font.Create('Microsoft Sans Se' +
    'rif', 8);
  Self.DataGrid1.HeaderForeColor := System.Drawing.Color.White;
  Self.DataGrid1.LinkColor := System.Drawing.Color.DarkSlateBlue;
  Self.DataGrid1.Location := System.Drawing.Point.Create(16, 16);
  Self.DataGrid1.Name := 'DataGrid1';
  Self.DataGrid1.ParentRowsBackColor := System.Drawing.Color.LightGray;
  Self.DataGrid1.ParentRowsForeColor := System.Drawing.Color.Black;
  Self.DataGrid1.SelectionBackColor := System.Drawing.Color.Firebrick;
  Self.DataGrid1.SelectionForeColor := System.Drawing.Color.White;
  Self.DataGrid1.Size := System.Drawing.Size.Create(520, 144);
  Self.DataGrid1.TabIndex := 0;
  // 
  // lklblLoad
  // 
  Self.lklblLoad.Location := System.Drawing.Point.Create(104, 168);
  Self.lklblLoad.Name := 'lklblLoad';
  Self.lklblLoad.TabIndex := 2;
  Self.lklblLoad.TabStop := True;
  Self.lklblLoad.Text := 'Schema XML';
  Include(Self.lklblLoad.LinkClicked, Self.lklblLoad_LinkClicked);
  // 
  // lklblSave
  // 
  Self.lklblSave.Location := System.Drawing.Point.Create(16, 168);
  Self.lklblSave.Name := 'lklblSave';
  Self.lklblSave.Size := System.Drawing.Size.Create(80, 23);
  Self.lklblSave.TabIndex := 3;
  Self.lklblSave.TabStop := True;
  Self.lklblSave.Text := 'Dados XML';
  Include(Self.lklblSave.LinkClicked, Self.LinkLabel2_LinkClicked);
  // 
  // RichTextBox1
  // 
  Self.RichTextBox1.Location := System.Drawing.Point.Create(16, 192);
  Self.RichTextBox1.Name := 'RichTextBox1';
  Self.RichTextBox1.Size := System.Drawing.Size.Create(520, 264);
  Self.RichTextBox1.TabIndex := 4;
  Self.RichTextBox1.Text := '';
  // 
  // LinkLabel1
  // 
  Self.LinkLabel1.Location := System.Drawing.Point.Create(216, 168);
  Self.LinkLabel1.Name := 'LinkLabel1';
  Self.LinkLabel1.Size := System.Drawing.Size.Create(88, 16);
  Self.LinkLabel1.TabIndex := 5;
  Self.LinkLabel1.TabStop := True;
  Self.LinkLabel1.Text := 'Gravar XML';
  Include(Self.LinkLabel1.LinkClicked, Self.LinkLabel1_LinkClicked);
  // 
  // LinkLabel2
  // 
  Self.LinkLabel2.Location := System.Drawing.Point.Create(320, 168);
  Self.LinkLabel2.Name := 'LinkLabel2';
  Self.LinkLabel2.Size := System.Drawing.Size.Create(88, 16);
  Self.LinkLabel2.TabIndex := 6;
  Self.LinkLabel2.TabStop := True;
  Self.LinkLabel2.Text := 'Ler XML';
  Include(Self.LinkLabel2.LinkClicked, Self.LinkLabel2_LinkClicked1);
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(552, 470);
  Self.Controls.Add(Self.LinkLabel2);
  Self.Controls.Add(Self.LinkLabel1);
  Self.Controls.Add(Self.RichTextBox1);
  Self.Controls.Add(Self.lklblSave);
  Self.Controls.Add(Self.lklblLoad);
  Self.Controls.Add(Self.DataGrid1);
  Self.Name := 'TWinForm';
  Self.Text := 'WinForm';
  Include(Self.Load, Self.TWinForm_Load);
  (System.ComponentModel.ISupportInitialize(Self.DataGrid1)).EndInit;
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm.TWinForm_Load(sender: System.Object; e: System.EventArgs);
begin
  ds := TShDataSet.Create;
  DataGrid1.DataSource := ds;
end;

procedure TWinForm.LinkLabel2_LinkClicked1(sender: System.Object; e: System.Windows.Forms.LinkLabelLinkClickedEventArgs);
begin
  //lendo as informaes do arquivo xml
  ds.ReadXml('dados.xml');
  // se acceptChanges no for chamado ele interpreta que todos os arquivos do
  // arquivo so novos
  ds.AcceptChanges();
end;

procedure TWinForm.LinkLabel1_LinkClicked(sender: System.Object; e: System.Windows.Forms.LinkLabelLinkClickedEventArgs);
begin
  //salvando o Dataset no formato xml, modo diffgram mostra os valores originais e as alteraes
  ds.WriteXml('dados.xml', XmlWriteMode.DiffGram );
end;

procedure TWinForm.lklblLoad_LinkClicked(sender: System.Object; e: System.Windows.Forms.LinkLabelLinkClickedEventArgs);
begin
  // pegando o esquema xml do dataset gerado
 RichTextBox1.Text := ds.GetXmlSchema();
end;

procedure TWinForm.LinkLabel2_LinkClicked(sender: System.Object; e: System.Windows.Forms.LinkLabelLinkClickedEventArgs);
begin
  //pegando o xml com os dados do dataset gerado
  RichTextBox1.Text :=  ds.GetXml();
end;

end.
