unit shDataSet;

interface

// para podermos usar a classe dataset adicione o uses abaixo.
uses
  System.Data;

type

  TShDataSet = class( Dataset )
  private
    procedure criarTabelaFornecedor();
    procedure criarTabelaProduto();
    procedure criarRelacionamentoProdutoFornecedor();
    procedure preencherDataset();
  protected
  public
    constructor Create;
  end;

implementation

// adicione esta diretriva para que a converso dos tipos redundadetes para
// referencia sejam feitos automaticamente
{$AUTOBOX ON}

{ TShDataSet }

//construtor que cria  as tabelas, relacionamentos e preenche com informaes o
//o data set
constructor TShDataSet.Create;
begin
  inherited;
  //setando nome do dataset
  DataSetName := 'Fornecedores e Produtos';
  criarTabelaFornecedor();
  criarTabelaProduto();
  criarRelacionamentoProdutoFornecedor();
  preencherDataset();
end;

//cria a tabela de fornecedor
procedure TShDataSet.criarTabelaFornecedor;
var
  fornecedores : DataTable;    //tabela de fornecedores
  coluna : DataColumn;         //varivel auxiliar para criar as colunas
  tipo : System.Type;          //variavel auxiliar para informar o tipo da coluna
  restricoes : array of DataColumn; // variavel auxiliar para restries da tabela
begin
  //setando o tamanho do array de restrie para um
  SetLength(restricoes, 1);

  //criando tabela de fornecedores
  fornecedores := DataTable.Create('fornecedores');

  // adicionando coluna cdigo do fornecedor do tipo inteiro 32 e como chave primria
  tipo   := System.Type.GetType('System.Int32');
  coluna := DataColumn.Create('idFornecedor', tipo);
  coluna.AutoIncrement := true;
  // o valor autoincremento iniciara em 1
  coluna.AutoIncrementSeed := 1;
  coluna.ReadOnly := true;
  //vincula a coluna criada a tabela
  fornecedores.Columns.Add( coluna );

  //a propriedade primary key eh um array
  restricoes[0] := coluna;
  fornecedores.PrimaryKey := restricoes;

  // adicionando coluna nome do fornecedor do tipo string
  tipo   := System.Type.GetType('System.String');
  coluna := DataColumn.Create('NomeFornecedor', tipo);
  //tamanho da coluna
  coluna.MaxLength := 1000;
  //coluna requerida
  coluna.AllowDBNull := false;
  fornecedores.Columns.Add( coluna );

  // adicionando coluna data de cadastro do fornecedor do tipo DateTime
  tipo   := System.Type.GetType('System.DateTime');
  coluna := DataColumn.Create('DthFornecedor', tipo);
  fornecedores.Columns.Add( coluna );

  //adicionando constraint da chave primria
  Tables.Add( fornecedores );

end;


procedure TShDataSet.criarTabelaProduto;
var
  produtos : DataTable;             // representa a tabela de produtos
  coluna : DataColumn;              // representa as colunas criadas dinamicamente
  tipo : System.Type;               // representa o tipo cirado dinamicamente
  restricoes : array of DataColumn; // representa as restries (constrainta da tabela);
begin
  //seta o tamannho do array dinamico de restricoes em 1
  SetLength(restricoes, 1);

  //cria a tabela de produtos
  produtos := DataTable.Create('produtos');

  // adicionando coluna cdigo do produto do tipo inteiro 32 e como chave primria
  tipo   := System.Type.GetType('System.Int32');
  coluna := DataColumn.Create('idProduto', tipo);
  coluna.AutoIncrement := true;
  // o valor autoincremento iniciara em 1
  coluna.AutoIncrementSeed := 1;
  coluna.ReadOnly := true;
  produtos.Columns.Add( coluna );

  //adicionando restriao de primary key
  restricoes[0] := coluna;
  produtos.PrimaryKey := restricoes;

  // adicionando coluna nome do produto do tipo string
  tipo   := System.Type.GetType('System.String');
  coluna := DataColumn.Create('NomeProduto', tipo);
  coluna.MaxLength := 1000;
  produtos.Columns.Add( coluna );

  // adicionando coluna nome  do produto do tipo decimal
  tipo   := System.Type.GetType('System.Decimal');
  coluna := DataColumn.Create('qtdProduto', tipo);
  produtos.Columns.Add( coluna );

  // adicionando coluna cdigo do fornecedor do tipo inteiro 32
  tipo   := System.Type.GetType('System.Int32');
  coluna := DataColumn.Create('idFornecedor', tipo);
  coluna.ReadOnly := true;
  produtos.Columns.Add( coluna );

  //adicionando tabela criada ao objeto DataSet oriundo do parametro do metodo
  Tables.Add( produtos );
end;

procedure TShDataSet.preencherDataset;
var
  fornecedor,               //tabela de fornecedor
    produto : DataTable;    //tabela de produto
  novoFornecedor,           //novo registro que sera usado para incluir fornecedores
    novoProduto : DataRow;  //novo registro que sera usado para incluir produtos

begin
  //simplificando a chamada as tabelas de fornecedores e produtos
  fornecedor := Tables[ 'fornecedores' ];
  produto    := Tables[ 'produtos' ];

  //adicionando novo fornecedor
  // new row retorna um registro do esquema definido no DataTable fornecedor
  novoFornecedor := fornecedor.NewRow;
  novoFornecedor['NomeFornecedor'] := 'Borland BlueStar';
  novoFornecedor['dthFornecedor']  := DateTime.Now;
  fornecedor.Rows.Add( novoFornecedor );

  //adicionando novo produto para o fornecedor inserido acima
  novoProduto := produto.NewRow;
  novoProduto['NomeProduto'] := 'Delphi 2005 - O melhor e mais produtivo ambiente de desenvolvimento de sistemas.';
  novoProduto['qtdProduto']  := 1000;
  //o campo idfornecedor  autoincremento e foi gerado ao adicionar o fornecedor
  novoProduto['idFornecedor']  := novoFornecedor['idFornecedor'];
  produto.Rows.Add( novoProduto );

  //adicionando novo produto para o mesmo fornecedo
  novoProduto := produto.NewRow;
  novoProduto['NomeProduto'] := 'StarTeam - O melhor software de Gerncia de configurao';
  novoProduto['qtdProduto']  := 500;
  novoProduto['idFornecedor']  := novoFornecedor['idFornecedor'];
  produto.Rows.Add( novoProduto );
end;

procedure TShDataSet.criarRelacionamentoProdutoFornecedor;
var
  fornecedor,               // tabela de fornecedor
    produto : DataTable;    // tabela de produto
  chavesFornecedor,                       //array para armazenar a PK de fornecedor
    chavesProduto : array of DataColumn;  //array para armazenar a PK de produto

  relacionamento : DataRelation;  //represanta o relacionamento entre tabelas
begin
  //iniciando arrays dinamicos dos valores chaves (PKs)
  SetLength(chavesFornecedor, 1);
  SetLength(chavesProduto, 1);

  //simplificando a chamada das tabelas
  fornecedor := Tables[ 'fornecedores' ];
  produto    := Tables[ 'produtos' ];

  //definindo as chaves do relacionamento
  chavesFornecedor := fornecedor.PrimaryKey;
  chavesProduto[0]   := produto.columns['idFornecedor'];

  //criando e adicionado o relacionamento entre as tabelas fornecedores e
  //produtos ao DataSet
  relacionamento := DataRelation.Create('fkFornecedoresProdutos', chavesFornecedor, chavesProduto);
  Relations.Add( relacionamento );

end;

end.
