unit UPrincipal;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Joystickex, ExtCtrls, StdCtrls, IdGlobal, Menus;

type
  TFPrincipal = class(TForm)
    Joystickex1: TJoystickex;
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    Image4: TImage;
    Image5: TImage;
    Image6: TImage;
    Image7: TImage;
    Image8: TImage;
    Image13: TImage;
    Image14: TImage;
    Image16: TImage;
    Image15: TImage;
    Image18: TImage;
    Image17: TImage;
    Image20: TImage;
    Image19: TImage;
    Image21: TImage;
    Image22: TImage;
    Image23: TImage;
    Image24: TImage;
    Image25: TImage;
    Image26: TImage;
    Image27: TImage;
    Image28: TImage;
    Image29: TImage;
    Image30: TImage;
    Image31: TImage;
    Image32: TImage;
    MainMenu1: TMainMenu;
    Joystick1: TMenuItem;
    Habilitar1: TMenuItem;
    Desabilitar1: TMenuItem;
    N1: TMenuItem;
    Configurar1: TMenuItem;
    N3: TMenuItem;
    Status1: TMenuItem;
    Image33: TImage;
    procedure Joystickex1JoyMove(Sender: TObject; XPos, YPos: Integer;
      ButtonStatus: Word; IsCalibrating: Boolean);
    procedure Joystickex1JoyZMove(Sender: TObject; ZPos: Integer;
      ButtonStatus: Word; IsCalibrating: Boolean);
    procedure Habilitar1Click(Sender: TObject);
    procedure Desabilitar1Click(Sender: TObject);
    procedure Status1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FPrincipal: TFPrincipal;

implementation

uses UStatus;

{$R *.dfm}

procedure TFPrincipal.Joystickex1JoyMove(Sender: TObject; XPos, YPos: Integer;
  ButtonStatus: Word; IsCalibrating: Boolean);
Var
   S: string;
begin
//Converte o valor lido do joystick para um nmero binrio.
//Como esta funo trabalha com binrios de 32 bits 
//necessrio limitar tamanho do binrio gerado.
   S := Copy(IntToBin(ButtonStatus),23,10);
   If FStatus <> nil then
   Begin
      FStatus.Label8.Caption := IntToStr(ButtonStatus);
      FStatus.Label10.Caption := S;
      FStatus.Label4.Caption := IntToStr(Xpos);
      FStatus.Label5.Caption := IntToStr(Ypos);
   End;
//De posse do binrio basta escolher qual figura
//deve ser exibida.
   Image16.Visible := (S[10] = '1');
   Image15.Visible := NOT Image16.Visible;
   Image14.Visible := (S[9] = '1');
   Image13.Visible := NOT Image14.Visible;
   Image20.Visible := (S[8] = '1');
   Image19.Visible := NOT Image20.Visible;
   Image18.Visible := (S[7] = '1');
   Image17.Visible := NOT Image18.Visible;
   Image26.Visible := (S[6] = '1');
   Image25.Visible := NOT Image26.Visible;
   Image28.Visible := (S[5] = '1');
   Image27.Visible := NOT Image28.Visible;
   Image30.Visible := (S[4] = '1');
   Image29.Visible := NOT Image30.Visible;
   Image32.Visible := (S[3] = '1');
   Image31.Visible := NOT Image32.Visible;
   Image24.Visible := (S[2] = '1');
   Image23.Visible := NOT Image24.Visible;
   Image22.Visible := (S[1] = '1');
   Image21.Visible := NOT Image22.Visible;
   Image7.Visible := (XPos < Joystickex1.XScaledBy -1);
   Image8.Visible := (XPos > Joystickex1.XScaledBy +1);
   Image3.Visible := NOT Image7.Visible;
   Image4.Visible := NOT Image8.Visible;
   Image5.Visible := (YPos < Joystickex1.YScaledBy -1);
   Image6.Visible := (YPos > Joystickex1.YScaledBy + 1);
   Image1.Visible := NOT Image5.Visible;
   Image2.Visible := NOT Image6.Visible;   
end;

procedure TFPrincipal.Joystickex1JoyZMove(Sender: TObject; ZPos: Integer;
  ButtonStatus: Word; IsCalibrating: Boolean);
begin
   If FStatus <>  nil then FStatus.Label6.Caption := IntToStr(Zpos);
end;

procedure TFPrincipal.Habilitar1Click(Sender: TObject);
begin
   if not Joystickex1.EnableJoyStick then MessageDLG('ERRO: Joystick nao encontrado.',mtError,[mbOk],0)
   Else
   Begin
      Habilitar1.Enabled := NOT Habilitar1.Enabled;
      Desabilitar1.Enabled := NOT Habilitar1.Enabled;
   End;
end;

procedure TFPrincipal.Desabilitar1Click(Sender: TObject);
begin
   Joystickex1.disableJoystick ;
   Habilitar1.Enabled := NOT Habilitar1.Enabled;
   Desabilitar1.Enabled := NOT Habilitar1.Enabled;
end;

procedure TFPrincipal.Status1Click(Sender: TObject);
begin
  If NOT Status1.Checked then
  Begin
     Status1.Checked := True;
     If FStatus = nil then FStatus := TFStatus.Create(Self);
     FStatus.Show;
  End
  Else
  Begin
     Status1.Checked := False;
     FStatus.Close;
  End;
end;

end.
