unit UConexaoFB;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls,
  //units includas
  IniFiles, SqlExpr;

type
  TFrmConexaoFB = class(TForm)
    btnOK: TBitBtn;
    btnCancelar: TBitBtn;
    lbEdtHost: TLabeledEdit;
    Memo1: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    procedure btnOKClick(Sender: TObject);
    procedure lbEdtHostChange(Sender: TObject);
  private
    { Private declarations }
    FConn: TSQLConnection;
  public
    { Public declarations }
    class function Execute(Conn: TSQLConnection; Erro: String): Boolean;
  end;

var
  FrmConexaoFB: TFrmConexaoFB;

implementation

{$R *.dfm}

{ TFrmConexaoFB }

class function TFrmConexaoFB.Execute(conn: TSQLConnection; Erro: String): Boolean;
var
  path: string;
  i: integer;
begin
  //cria o form
  with TFrmConexaoFB.Create(Application) do
  try
    //Pega a string de conexo com o banco do SQLConnection.
    path:= conn.Params.Values['database'];
    {Copia apenas o ip ou nome do servidor da string de conexo.
     Se no tiver os dois-pontos,  porque a conexo  local,
     assim, atribui o valor localhost como sendo o servidor
     (o valor antes de dois-pontos). }
    i:= pos(':', path);
    if i = 0 then
       lbEdtHost.Text:= 'localhost'
    else lbEdtHost.Text:= copy(path, 1, i-1);
    //Mostra a mensagem de erro no memo.
    Memo1.Lines.Text := erro;
    {Atribui a conexo passada por parmetro a varivel privada FConn
    para ser utilizada em outras rotinas desta unit, como no click
    do boto OK.}
    FConn:= Conn;
    {Verifica se o form foi fechado clicando no boto OK retornando True
    para informar que a conexo foi configurada com sucesso.}
    Result:= ShowModal = mrOK;
  finally
    //Libera o form da memria.
    free;
  end;
end;

procedure TFrmConexaoFB.btnOKClick(Sender: TObject);
var
  ini: TIniFile;
  path: string;
  i: integer;
  
begin
  {Acessa o arquivo dbxconnections.ini na
  pasta do executvel.}
  ini:= TIniFile.Create(
     ExtractFilePath(Application.ExeName) +
     'dbxconnections.ini');
  try
    {L o identificador "database" que contm
    a string de conexo com o banco de dados,
    armazenada no arquivo .ini}
    path:=
       ini.ReadString(FConn.ConnectionName,
       'database', FConn.ConnectionName);
    {Procura um caractere dois-pontos dentro
    da string de conexo com o banco. Se
    encontrar, o que est aps os dois pontos
     o nome do banco de dados que a aplicao
    utiliza, seno,  porque a string de conexo
    possui apenas o nome do banco de dados,
    sem o host. Assim, ser feita uma tentativa
    de conexo com o servidor Firebird, utilizando
    o Host informado pelo usurio, com o banco
    de dados j gravado no arquivo .ini}
    i:= pos(':', path);
    if i <> 0 then
       path:= copy(path, i+1, length(path));
    path:= lbEdtHost.Text + ':' + path;
    {Altera a string de conexo para o novo valor.
    Este novo valor contm apenas o host que foi
    informado pelo usurio.}
    FConn.Params.Values['database']:= path;
    try
      //Tenta conectar ao banco.
      FConn.Open;
    except
      {Se no conseguir, impede que o form
      seja fechado. O usurio poder desistir
      clicando no boto Cancelar.}
      ModalResult := mrNone;
      //Mostra a mensagem de erro.
      raise;
    end;
    {Se chegou at aqui,  porque a conexo foi estabelecida
    com sucesso. Assim, grava a nova string de conexo
    no arquivo .ini}
    ini.WriteString(FConn.ConnectionName, 'database', path);
  finally
    //Fecha o arquivo .ini
    ini.free;
  end;
end;

procedure TFrmConexaoFB.lbEdtHostChange(Sender: TObject);
begin
  btnOK.Enabled:= trim(lbEdtHost.Text) <> '';
end;

end.
