unit UDM;

interface

uses
  SysUtils, Classes, DBXpress, FMTBcd, DBClient, Provider, DB, SqlExpr;

type
  TDM = class(TDataModule)
    SQLConnection1: TSQLConnection;
    SQLDataSet1: TSQLDataSet;
    DataSetProvider1: TDataSetProvider;
    ClientDataSet1: TClientDataSet;
    SQLDataSet1COUNTRY: TStringField;
    SQLDataSet1CURRENCY: TStringField;
    ClientDataSet1COUNTRY: TStringField;
    ClientDataSet1CURRENCY: TStringField;
    procedure DataModuleDestroy(Sender: TObject);
    procedure ClientDataSet1AfterPost(DataSet: TDataSet);
    procedure ClientDataSet1AfterDelete(DataSet: TDataSet);
    procedure ClientDataSet1ReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DM: TDM;

implementation

{$R *.dfm}

procedure TDM.DataModuleDestroy(Sender: TObject);
begin
  SQLConnection1.Close;
end;

procedure TDM.ClientDataSet1AfterPost(DataSet: TDataSet);
begin
  if ClientDataSet1.ApplyUpdates(0) > 0 then
     ClientDataSet1.Edit;
end;

procedure TDM.ClientDataSet1AfterDelete(DataSet: TDataSet);
begin
  if ClientDataSet1.ApplyUpdates(0) > 0 then
     ClientDataSet1.CancelUpdates;
end;

procedure TDM.ClientDataSet1ReconcileError(DataSet: TCustomClientDataSet;
  E: EReconcileError; UpdateKind: TUpdateKind;
  var Action: TReconcileAction);
begin
  Action := raAbort;
  raise exception.create(e.message);
end;

end.
