program cadastro_firebird_dbexpress;

uses
  Forms,  Dialogs, SysUtils,
  UCadastro in 'UCadastro.pas' {FrmCadastro},
  UConexaoFB in 'UConexaoFB.pas' {FrmConexaoFB},
  UDM in 'UDM.pas' {DM: TDataModule};

{$R *.res}

var ExePath: String;
begin
  Application.Initialize;

  Application.CreateForm(TDM, DM);
  //verificar arquivo .ini -----------------------------
  //includa unit SysUtils
  //extrai a pasta do executvel
  ExePath:= ExtractFilePath(Application.Exename);
  if not FileExists(ExePath + 'dbxconnections.ini') then
  begin
    //includa unit Dialogs
    ShowMessage(
      'O arquivo de conexo com o banco de dados, ' +
      'dbxconnections.ini, no foi encontrado.');
    //encerra a aplicao
    exit;
  end;
  DM.SQLConnection1.LoadParamsFromIniFile(
     ExePath + 'dbxconnections.ini');
  //---------------------------------------------------

  try
    //Tenta conectar no banco.
    DM.SQLConnection1.Open;
  except
    //Se ocorrer algum erro, abre o form de conexo.
    //includa unit SysUtils
    on e: exception do
    begin
      {Chama o form de conexo utilizando o mtodo Execute da sua classe,
      no precisando se preocupar em criar nem destruir o form. O mtodo
      j faz isso tudo. O mtodo Execute recebe o SQLConnection1
      e a mensagem de erro gerada.}
      if not TFrmConexaoFB.Execute(DM.SQLConnection1, e.Message) then
         exit;
    end;
  end;
  Application.CreateForm(TFrmCadastro, FrmCadastro);
  Application.Run;
end.
