unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TActiveDelphiObj = class(TComponent)
  private
    FCodigo: Integer;
    FNome: String;
    function GetCodigo: Integer;
    function GetNome: String;
    procedure SetCodigo(const Value: Integer);
    procedure SetNome(const Value: String);
  published
    property Codigo: Integer read GetCodigo write SetCodigo;
    property Nome: String read GetNome write SetNome;
  end;

  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
  private
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{ TActiveDelphiObj }

function TActiveDelphiObj.GetCodigo: Integer;
begin
  Result := FCodigo;
end;

function TActiveDelphiObj.GetNome: String;
begin
  Result := FNome;
end;

procedure TActiveDelphiObj.SetCodigo(const Value: Integer);
begin
  if Value <> FCodigo then
    FCodigo := Value;
end;

procedure TActiveDelphiObj.SetNome(const Value: String);
begin
  if Value <> FNome then
    FNome := Value;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  BinStream:TMemoryStream;
  StrStream: TStringStream;
  fileStream: TFileStream;
  ADObj: TActiveDelphiObj;
  s: string;
begin
  BinStream := TMemoryStream.Create;
  fileStream := TFileStream.Create(ExtractFilePath(Application.ExeName) + 'ActiveDelphiObj.ser', fmCreate);
  ADObj := TActiveDelphiObj.Create(Self);
  try
    StrStream := TStringStream.Create(s);
    ADObj.Codigo := 1;
    ADObj.Nome := 'Active Delphi';
    try
      BinStream.WriteComponent(ADObj);
      BinStream.Seek(0, soFromBeginning);
      ObjectBinaryToText(BinStream, StrStream);
      StrStream.Seek(0, soFromBeginning);
      Memo1.Lines.Add(StrStream.DataString);
      fileStream.CopyFrom(StrStream, StrStream.Size);
    finally
      StrStream.Free;
    end;
  finally
    BinStream.Free;
    fileStream.Free;
    ADObj.Free;
  end;
end;

end.
