unit DataSetFormUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ActnList, ComCtrls, ToolWin, DB, Grids, DBGrids, ImgList;

type
  TDataSetForm = class(TForm)
    DataSource: TDataSource;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    DataSetActionList: TActionList;
    NewAction: TAction;
    SaveAction: TAction;
    DeleteAction: TAction;
    FirstAction: TAction;
    PriorAction: TAction;
    NextAction: TAction;
    LastAction: TAction;
    DataSetImageList: TImageList;
    DBGrid1: TDBGrid;
    procedure NewActionExecute(Sender: TObject);
    procedure SaveActionExecute(Sender: TObject);
    procedure DeleteActionExecute(Sender: TObject);
    procedure FirstActionExecute(Sender: TObject);
    procedure PriorActionExecute(Sender: TObject);
    procedure NextActionExecute(Sender: TObject);
    procedure LastActionExecute(Sender: TObject);
  private
    FConfirmDeleteMessage: String;
    procedure SetConfirmDeleteMessage(const Value: String);
    { Private declarations }
  public
    { Public declarations }
  published
    property ConfirmDeleteMessage: String read FConfirmDeleteMessage write SetConfirmDeleteMessage;
  end;

var
  DataSetForm: TDataSetForm;

procedure Register;

implementation

{$R *.dfm}

uses
  DesignIntF, DesignEditors;

procedure Register;
begin
  RegisterCustomModule(TDataSetForm, TCustomModule)
end;

procedure TDataSetForm.NewActionExecute(Sender: TObject);
begin
  DataSource.DataSet.Append;
end;

procedure TDataSetForm.SaveActionExecute(Sender: TObject);
begin
  DataSource.DataSet.Post;
end;

procedure TDataSetForm.DeleteActionExecute(Sender: TObject);
begin
  if MessageDlg(ConfirmDeleteMessage, mtConfirmation, [mbYes, mbNo], 0) = mrYes then
    DataSource.DataSet.Delete;
end;

procedure TDataSetForm.FirstActionExecute(Sender: TObject);
begin
  DataSource.DataSet.First;
end;

procedure TDataSetForm.PriorActionExecute(Sender: TObject);
begin
  DataSource.DataSet.Prior;
end;

procedure TDataSetForm.NextActionExecute(Sender: TObject);
begin
  DataSource.DataSet.Next;
end;

procedure TDataSetForm.LastActionExecute(Sender: TObject);
begin
  DataSource.DataSet.Last;
end;

procedure TDataSetForm.SetConfirmDeleteMessage(const Value: String);
begin
  FConfirmDeleteMessage := Value;
end;

end.
