unit uExemplo;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons, ComCtrls;

type
  TfPrinc = class(TForm)
    GroupBox1: TGroupBox;
    edtNumero: TLabeledEdit;
    edtEmissao: TLabeledEdit;
    edtVencimento: TLabeledEdit;
    edtValor: TLabeledEdit;
    edtEmitente: TLabeledEdit;
    edtCPF: TLabeledEdit;
    edtEndereco: TLabeledEdit;
    edtLocal: TLabeledEdit;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    edtCopias: TLabeledEdit;
    bbImprimir: TBitBtn;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    memoLay: TMemo;
    memoDados: TMemo;
    chkPrev: TCheckBox;
    bbGerar: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    edtPagavel: TLabeledEdit;
    chkFundo: TCheckBox;
    procedure bbImprimirClick(Sender: TObject);
    procedure bbGerarClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fPrinc: TfPrinc;

implementation

uses urImpForm, uExtenso;

{$R *.dfm}

procedure TfPrinc.bbImprimirClick(Sender: TObject);
begin
   with TformImpForm.Create(Nil) do begin
      Try
         ItemIni     := 1;
         ItemFim     := strtoint(edtCopias.Text);
         LayOut      := TStringList.Create;
         Layout.Text := memoLay.Lines.Text;
         Dados       := TStringList.Create;
         Dados.Text  := memoDados.Lines.Text;
         ComFundo    := chkFundo.Checked;
         if chkPrev.Checked then frImpForm.Preview else frImpForm.Print;
      finally
         LayOut.Free;
         Dados.Free;
         frImpForm.Free;
         formImpForm.Free;
      End
   End;
end;

procedure TfPrinc.bbGerarClick(Sender: TObject);
Var
   Aux,Cod : String;
   i   : Integer;
begin
   memoDados.Clear;
   for i := 1 to strtoint(edtCopias.Text) do begin
       Cod := FormatFloat('000',i);
       aux := cod + 'Numero      :=' + edtNumero.Text;
       memoDados.Lines.Add(aux);
       aux := cod + 'Emissao     :=' + edtLocal.Text + ', ' + formatdatetime(' dd " de " mmmm " de " yyyy',strtodatetime(edtEmissao.Text));
       memoDados.Lines.Add(aux);
       aux := cod + 'Vencimento  :=' + formatdatetime(' dd " de " mmmm " de " yyyy',strtodatetime(edtVencimento.Text));
       memoDados.Lines.Add(aux);
       aux := cod + 'VencExtenso :=' + 'No dia ' + formatdatetime(' dd " de " mmmm " de " yyyy',strtodatetime(edtVencimento.Text));
       memoDados.Lines.Add(aux);
       aux := cod + 'Valor       :=' + edtValor.Text;
       memoDados.Lines.Add(aux);
       aux := cod + 'Porextenso  :=' + Extenso(strtofloat(edtValor.Text),'Real','Reais','Centavo','Centavos');
       memoDados.Lines.Add(aux);
       aux := cod + 'Emitente    :=' + edtEmitente.Text;
       memoDados.Lines.Add(aux);
       aux := cod + 'CPFemitente :=' + edtCPF.Text;
       memoDados.Lines.Add(aux);
       aux := cod + 'Endereco    :=' + edtEndereco.Text;
       memoDados.Lines.Add(aux);
       aux := cod + 'Pagavel_a   :=' + edtPagavel.Text;
       memoDados.Lines.Add(aux);
   End;
end;

end.
