unit urImpForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, RLFilters, RLDraftFilter, RLHTMLFilter, RLPDFFilter, DB,
  MDOCustomDataSet, MDOQuery, MDODatabase, RLReport, RLPreviewForm,
  RLRichFilter;

type
  TformImpForm = class(TForm)
    frImpForm: TRLReport;
    Cabecalho: TRLBand;
    pdf: TRLPDFFilter;
    filHTML: TRLHTMLFilter;
    Matricial: TRLDraftFilter;
    Detalhe: TRLBand;
    Rodape: TRLBand;
    fiRTF: TRLRichFilter;
    procedure frImpFormBeforePrint(Sender: TObject; var PrintIt: Boolean);
    procedure frImpFormNeedData(Sender: TObject; var MoreData: Boolean);
  private
    { Private declarations }
    ItemAtu : Integer;
    function leconteudo(var Lista : TStrings;Campo,padrao : String) : String;
    function StrparaInt(Texto : String) : Integer;
    procedure Imprimir(Sender: TObject; var Text: String; var PrintIt: Boolean);
    function pegaseq(Texto : String; posicao : Integer;sep : Char = #44) : String;
    function StrZero(Zeros:string;Quant:integer):String;    
  public
    { Public declarations }
    LayOut,Dados      : TStrings;
    ItemIni,ItemFim   : Integer;
    ComFundo          : Boolean;
    Imgfundo          : String;
  end;

var
  formImpForm: TformImpForm;
  aux : integer;

implementation

uses StrUtils;

{$R *.dfm}

procedure TformImpForm.frImpFormBeforePrint(Sender: TObject;
  var PrintIt: Boolean);
  Var
     i,y           : Integer;
     Aux,NomeFonte : String;
     TamFontePadrao,LarguraColuna,AlturaLinha,AlturaCabecalho,AlturaRodape : Smallint;
     LargPag,AltPag : Single;
     Campo,conteudo : String;
     X : TRLMemo;
     Lin,col,larg,alin,pai,Negri,TamFonte,Quebra,AltCampo : Smallint;
     tLin,tCol,tLarg : String;
begin
   NomeFonte        := leconteudo(LayOut,'NomeFonte','Courier New');
   TamFontePadrao   := StrparaInt(leconteudo(LayOut,'TamFontePadrao','0'));
   LarguraColuna    := StrparaInt(leconteudo(LayOut,'LarguraColuna','0'));
   AlturaLinha      := StrparaInt(leconteudo(LayOut,'AlturaLinha','0'));
   AlturaCabecalho  := StrparaInt(leconteudo(LayOut,'AlturaCabecalho','0'));
   AlturaRodape     := StrparaInt(leconteudo(LayOut,'AlturaRodape','0'));
   LargPag          := StrparaInt(leconteudo(LayOut,'LarguraPagina','210'));
   AltPag           := StrparaInt(leconteudo(LayOut,'AlturaPagina','297'));
   frImpForm.PageSetup.PaperHeight := AltPag;
   frImpForm.PageSetup.PaperWidth  := LargPag;
   Cabecalho.Height := AlturaCabecalho;
   Rodape.Height    := AlturaRodape;
   Detalhe.Height   := round(AltPag * 3.78) - Cabecalho.Height - Rodape.Height;
   frImpForm.Realign;
   For i := 0 to LayOut.Count -1 do begin
     Aux            := LayOut.Strings[i];
     if (copy(Aux,1,1) = '.') and (pos(':=',Aux) > 0) then begin
        campo := trim(copy(aux,2,pos(':=',aux)-2));
        Aux   := leconteudo(LayOut,'.'+campo,'0');
        for y := 1 to ComponentCount -1 do if Components[y].Name = Campo then aux := '0';
        if aux <> '0' then begin
           tlin           := pegaseq(aux,1,'|');
           tcol           := pegaseq(aux,2,'|');
           tlarg          := pegaseq(aux,3,'|');
           lin            := StrparaInt(tlin);
           col            := StrparaInt(tcol);
           larg           := StrparaInt(tLarg);
           alin           := StrparaInt(pegaseq(aux,4,'|'));
           pai            := StrparaInt(pegaseq(aux,5,'|'));
           negri          := StrparaInt(pegaseq(aux,6,'|'));
           TamFonte       := StrparaInt(pegaseq(aux,7,'|'));
           Quebra         := StrparaInt(pegaseq(aux,8,'|'));
           AltCampo       := StrparaInt(pegaseq(aux,9,'|'));
           if length(tLin) < 4 then  lin  := (lin * AlturaLinha);
           if length(tCol) < 4 then  col  := (col * LarguraColuna);
           if length(tLarg) < 4 then larg := (Larg * LarguraColuna);
           X              := TRLMemo.Create(Self);
           if ComFundo then X.Color := clSilver;
           X.Font.Name    := NomeFonte;
           X.Font.Size    := TamFonte;
           case pai of
             0 : X.Parent := Detalhe;
             1 : X.Parent := Detalhe;
             2 : X.Parent := Rodape;
           End;
           X.Left         := col;
           X.Top          := lin;
           X.AutoSize     := False;
           X.Width        := larg;
           case alin of
             0 : X.Alignment := taLeftJustify;
             1 : X.Alignment := taCenter;
             2 : X.Alignment := taRightJustify;
           End;
           if Negri = 1 then X.Font.Style := [fsBold];
           X.WordWrap    := Quebra = 1;
           if AltCampo = 0 then AltCampo := AlturaLinha;
           X.Height      := AltCampo;
           X.Name        := Campo;
           X.BeforePrint := Imprimir;
        End;
     End;
   End;
   ItemAtu := ItemIni -1;
   if FileExists(Imgfundo) then frImpForm.Background.Picture.LoadFromFile(Imgfundo);
end;

function TformImpForm.leconteudo(var Lista: TStrings; Campo,Padrao: String): String;
Var
   i,y   : Integer;
   Aux1  : String;
begin
   for i := 0 to Lista.Count -1 do begin
      Aux1 := Lista.Strings[i];
      if copy(Aux1,1,1) <> '#' then begin
         y    := pos(':=',Aux1);
         if (y > 0) and (pos(UpperCase(campo),uppercase(Aux1))>0) then begin
            Result := trim(copy(Aux1,Y+2,length(aux1)));
            Break;
         End;
      End;
   End;
   if Result = '' then result := padrao;
end;

function TformImpForm.StrparaInt(Texto: String): Integer;
begin
  texto := trim(texto);
  if texto = '' then texto := '0';
  Result := 0;
  try
     result := StrToInt(Texto);
  except end;
end;

procedure TformImpForm.frImpFormNeedData(Sender: TObject;
  var MoreData: Boolean);
begin
   inc(ItemAtu);
   MoreData := ItemAtu <= ItemFim;
   if MoreData then frImpForm.NewPage;
end;

procedure TformImpForm.Imprimir(Sender: TObject; var Text: String; var PrintIt: Boolean);
Var
   NomeCam : String;
begin
   NomeCam  := strzero(inttostr(ItemAtu),3) + TRLMemo(Sender).Name;
   Text     := leconteudo(Dados,NomeCam,'');
   while pos('|',Text)>0 do Text := StuffString(Text,pos('|',Text),1,chr(13)+chr(10));
end;

function TformImpForm.pegaseq(Texto: String; posicao: Integer;
  sep: Char): String;
// Retorna a string n de uma sequencia do tipo: 23,78,58,90 ou 10|25|52|58
// Exemplo: pegaseq(tipo,2) = 78
Var
   conta : Integer;
   tmp   : String;
begin
   Result := '';
   conta  := 1;
   while length(Texto) > 0 do begin
      if pos(sep,Texto) > 0 then begin
         tmp   := copy(Texto,1,pos(sep,Texto)-1);
         Texto := copy(Texto,pos(sep,texto)+1,length(Texto));
      end else begin
         tmp   := texto;
         Texto := '';
      End;
      if conta = posicao then result := tmp;
      inc(conta);
   End;
end;

function TformImpForm.StrZero(Zeros: string; Quant: integer): String;
{Insere Zeros  frente de uma string}
var
  i : integer;
begin
  Zeros := trim(zeros);
  for I:=1 to Quant - length(Zeros) do Zeros:= '0' + Zeros;
  Result := Zeros;
end;

end.
