unit UDialogsBr;

interface

uses
   Dialogs, Forms, StdCtrls, Controls, SysUtils, ExtCtrls,
   Graphics;

const
  mbPrint = [mbYes, mbNo, mbCancel, mbIgnore];
  mbFind  = [mbYes, mbNo, mbCancel, mbAbort];

   function MessageDlgBr(const Path, Title,Msg: string; DlgType: TMsgDlgType; Buttons: TMsgDlgButtons): Word; overload;
   function MessageDlgBr(const Ico: TIcon; const Title, Msg: string; DlgType: TMsgDlgType; Buttons: TMsgDlgButtons): Word; overload;
   function MessageDlgBr(const Title,Msg: string; DlgType: TMsgDlgType; Buttons: TMsgDlgButtons): Word; overload;
   function MessageDlgBr(const Title,Msg: string; DlgType: TMsgDlgType): Word; overload;
   function MessageDlgBr(const Msg: string; DlgType: TMsgDlgType): Word; overload;
   function MessageDlgBr(const Msg: string; DlgType: TMsgDlgType; Buttons: TMsgDlgButtons): Word; overload;
   function MessageDlgBr(const Msg: string; DlgType: TMsgDlgType; Buttons: TMsgDlgButtons; HelpCtx: Longint): Word; overload;

implementation

function MessageDlgBr(const Path,Title,Msg: string; DlgType: TMsgDlgType; Buttons: TMsgDlgButtons): Word; overload;
var
   Form : TForm;
   i,j: integer;
   Prt, Fnd: Boolean;
begin
   if Buttons = [] then Buttons := [mbOk];
   Prt := (Buttons = mbPrint);
   Fnd := (Buttons = mbFind);

   if (Buttons = mbPrint) or (Buttons = mbFind) then Buttons := mbYesNoCancel;

   Form := CreateMessageDialog(Msg,DlgType,Buttons);
   try
      for i := 0 to Form.ComponentCount-1 do
      begin
         If Form.Components[i] is TButton then
         begin
            Case TButton(Form.Components[i]).ModalResult of
            mrYes:
               if Prt then TButton(Form.Components[i]).Caption := 'Imprimir'
               else if Fnd then
               begin
                  TButton(Form.Components[i]).Caption := 'Intermedirio';
                  TButton(Form.Components[i]).Width   := 100;
                  Form.Width := Form.Width + 37;
                  for j := 0 to Form.ComponentCount-1 do
                  begin
                     If (Form.Components[j] is TButton) then
                        If (TButton(Form.Components[i]).Left < TButton(Form.Components[j]).Left) then
                           TButton(Form.Components[j]).Left := TButton(Form.Components[j]).Left + 37;
                  end;
               end
               else TButton(Form.Components[i]).Caption := 'Sim';
            mrNo:
               if Prt then TButton(Form.Components[i]).Caption := 'Visualizar'
               else if Fnd then TButton(Form.Components[i]).Caption := 'Seqencial'
               else TButton(Form.Components[i]).Caption := 'No';
            mrOk:       TButton(Form.Components[i]).Caption := 'Ok';
            mrCancel:   TButton(Form.Components[i]).Caption := 'Cancelar';
            mrAll:      TButton(Form.Components[i]).Caption := 'Todos';
            mrIgnore:   TButton(Form.Components[i]).Caption := 'Ignorar';
            mrRetry:    TButton(Form.Components[i]).Caption := 'Repetir';
            mrAbort:    TButton(Form.Components[i]).Caption := 'Abortar';
            mrYesToAll:
            begin
               TButton(Form.Components[i]).Caption := 'Sim para todos';
               TButton(Form.Components[i]).Width := 100;
               Form.Width := Form.Width + 37;
               for j := 0 to Form.ComponentCount-1 do
               begin
                  If (Form.Components[j] is TButton) then
                     If (TButton(Form.Components[i]).Left < TButton(Form.Components[j]).Left) and (TButton(Form.Components[i]).Left+TButton(Form.Components[i]).Width >= TButton(Form.Components[j]).Left) then
                        TButton(Form.Components[j]).Left := TButton(Form.Components[j]).Left + 37;
               end;
            end;
            mrNoToAll:
            begin
               TButton(Form.Components[i]).Caption := 'No para todos';
               TButton(Form.Components[i]).Width := 100;
               Form.Width := Form.Width + 37;
               for j := 0 to Form.ComponentCount-1 do
               begin
                  If (Form.Components[j] is TButton) then
                     If (TButton(Form.Components[i]).Left < TButton(Form.Components[j]).Left) and (TButton(Form.Components[i]).Left+TButton(Form.Components[i]).Width >= TButton(Form.Components[j]).Left) then
                        TButton(Form.Components[j]).Left := TButton(Form.Components[j]).Left + 37;
               end;
            end;
            mrNone:     TButton(Form.Components[i]).Caption := 'Nenhum';
            end;
         end
         else if (Form.Components[i] is TImage) and (FileExists(Path)) then (Form.Components[i] as TImage).Picture.LoadFromFile(Path);
      end;
      Form.Caption := Title;
      Form.ShowModal;
      Result := Form.ModalResult;
   finally
      Form.Free;
   end;
end;

function MessageDlgBr(const Ico: TIcon; const Title,Msg: string; DlgType: TMsgDlgType; Buttons: TMsgDlgButtons): Word; overload;
var
   Form : TForm;
   i,j: integer;
   Prt, Fnd: Boolean;
begin
   if Buttons = [] then Buttons := [mbOk];
   Prt := (Buttons = mbPrint);
   Fnd := (Buttons = mbFind);

   if (Buttons = mbPrint) or (Buttons = mbFind) then Buttons := mbYesNoCancel;

   Form := CreateMessageDialog(Msg,DlgType,Buttons);
   try
      for i := 0 to Form.ComponentCount-1 do
      begin
         If Form.Components[i] is TButton then
         begin
            Case TButton(Form.Components[i]).ModalResult of
            mrYes:
               if Prt then TButton(Form.Components[i]).Caption := 'Imprimir'
               else if Fnd then
               begin
                  TButton(Form.Components[i]).Caption := 'Intermedirio';
                  TButton(Form.Components[i]).Width   := 100;
                  Form.Width := Form.Width + 37;
                  for j := 0 to Form.ComponentCount-1 do
                  begin
                     If (Form.Components[j] is TButton) then
                        If (TButton(Form.Components[i]).Left < TButton(Form.Components[j]).Left) then
                           TButton(Form.Components[j]).Left := TButton(Form.Components[j]).Left + 37;
                  end;
               end
               else TButton(Form.Components[i]).Caption := 'Sim';
            mrNo:
               if Prt then TButton(Form.Components[i]).Caption := 'Visualizar'
               else if Fnd then TButton(Form.Components[i]).Caption := 'Seqencial'
               else TButton(Form.Components[i]).Caption := 'No';
            mrOk:       TButton(Form.Components[i]).Caption := 'Ok';
            mrCancel:   TButton(Form.Components[i]).Caption := 'Cancelar';
            mrAll:      TButton(Form.Components[i]).Caption := 'Todos';
            mrIgnore:   TButton(Form.Components[i]).Caption := 'Ignorar';
            mrRetry:    TButton(Form.Components[i]).Caption := 'Repetir';
            mrAbort:    TButton(Form.Components[i]).Caption := 'Abortar';
            mrYesToAll:
            begin
               TButton(Form.Components[i]).Caption := 'Sim para todos';
               TButton(Form.Components[i]).Width := 100;
               Form.Width := Form.Width + 37;
               for j := 0 to Form.ComponentCount-1 do
               begin
                  If (Form.Components[j] is TButton) then
                     If (TButton(Form.Components[i]).Left < TButton(Form.Components[j]).Left) and (TButton(Form.Components[i]).Left+TButton(Form.Components[i]).Width >= TButton(Form.Components[j]).Left) then
                        TButton(Form.Components[j]).Left := TButton(Form.Components[j]).Left + 37;
               end;
            end;
            mrNoToAll:
            begin
               TButton(Form.Components[i]).Caption := 'No para todos';
               TButton(Form.Components[i]).Width := 100;
               Form.Width := Form.Width + 37;
               for j := 0 to Form.ComponentCount-1 do
               begin
                  If (Form.Components[j] is TButton) then
                     If (TButton(Form.Components[i]).Left < TButton(Form.Components[j]).Left) and (TButton(Form.Components[i]).Left+TButton(Form.Components[i]).Width >= TButton(Form.Components[j]).Left) then
                        TButton(Form.Components[j]).Left := TButton(Form.Components[j]).Left + 37;
               end;
            end;
            mrNone:     TButton(Form.Components[i]).Caption := 'Nenhum';
            end;
         end
         else if (Form.Components[i] is TImage) and (Ico.Handle <> 0) then TImage(Form.Components[i]).Picture.Icon := Ico;
      end;
      Form.Caption := Title;
      Form.ShowModal;
      Result := Form.ModalResult;
   finally
      Form.Free;
   end;
end;

function MessageDlgBr(const Title, Msg: string; DlgType: TMsgDlgType; Buttons: TMsgDlgButtons): Word;
var
   Form : TForm;
   i,j: integer;
begin
   if Buttons = [] then Buttons := [mbOk];

   Form := CreateMessageDialog(Msg,DlgType,Buttons);
   try
      for i := 0 to Form.ComponentCount-1 do
      begin
         If Form.Components[i] is TButton then
            Case TButton(Form.Components[i]).ModalResult of
            mrYes:      TButton(Form.Components[i]).Caption := 'Sim';
            mrNo:       TButton(Form.Components[i]).Caption := 'No';
            mrOk:       TButton(Form.Components[i]).Caption := 'Ok';
            mrCancel:   TButton(Form.Components[i]).Caption := 'Cancelar';
            mrAll:      TButton(Form.Components[i]).Caption := 'Todos';
            mrIgnore:   TButton(Form.Components[i]).Caption := 'Ignorar';
            mrRetry:    TButton(Form.Components[i]).Caption := 'Repetir';
            mrAbort:    TButton(Form.Components[i]).Caption := 'Abortar';
            mrYesToAll:
            begin
               TButton(Form.Components[i]).Caption := 'Sim para todos';
               TButton(Form.Components[i]).Width := 100;
               Form.Width := Form.Width + 37;
               for j := 0 to Form.ComponentCount-1 do
               begin
                  If (Form.Components[j] is TButton) then
                     If (TButton(Form.Components[i]).Left < TButton(Form.Components[j]).Left) and (TButton(Form.Components[i]).Left+TButton(Form.Components[i]).Width >= TButton(Form.Components[j]).Left) then
                        TButton(Form.Components[j]).Left := TButton(Form.Components[j]).Left + 37;
               end;
            end;
            mrNoToAll:
            begin
               TButton(Form.Components[i]).Caption := 'No para todos';
               TButton(Form.Components[i]).Width := 100;
               Form.Width := Form.Width + 37;
               for j := 0 to Form.ComponentCount-1 do
               begin
                  If (Form.Components[j] is TButton) then
                     If (TButton(Form.Components[i]).Left < TButton(Form.Components[j]).Left) and (TButton(Form.Components[i]).Left+TButton(Form.Components[i]).Width >= TButton(Form.Components[j]).Left) then
                        TButton(Form.Components[j]).Left := TButton(Form.Components[j]).Left + 37;
               end;
            end;
            mrNone:     TButton(Form.Components[i]).Caption := 'Nenhum';
            end;
      end;
      Form.Caption := Title;
      Form.ShowModal;
      Result := Form.ModalResult;
   finally
      Form.Free;
   end;
end;

function MessageDlgBr(const Title,Msg: string; DlgType: TMsgDlgType): Word; overload;
begin
   Result := MessageDlgBr(Title, Msg, DlgType, [mbOk]);
end;

function MessageDlgBr(const Msg: string; DlgType: TMsgDlgType): Word; overload;
Var
   Title: String;
begin
   Case DlgType of
   mtCustom: Title := 'Personalisada';
   mtInformation: Title := 'Informao';
   mtWarning: Title := 'Ateno';
   mtError: Title := 'Erro';
   mtConfirmation: Title := 'Confirmao';
   end;
   Result := MessageDlgBr(Title, Msg, DlgType, [mbOk]);
end;

function MessageDlgBr(const Msg: string; DlgType: TMsgDlgType; Buttons: TMsgDlgButtons): Word; overload;
Var
   Title: String;
begin
   Case DlgType of
   mtCustom: Title := 'Personalisada';
   mtInformation: Title := 'Informao';
   mtWarning: Title := 'Ateno';
   mtError: Title := 'Erro';
   mtConfirmation: Title := 'Confirmao';
   end;
   Result := MessageDlgBr(Title, Msg, DlgType, Buttons);
end;

function MessageDlgBr(const Msg: string; DlgType: TMsgDlgType; Buttons: TMsgDlgButtons; HelpCtx: Longint): Word; overload;
Var
   Title: String;
begin
   Case DlgType of
   mtCustom: Title := 'Personalisada';
   mtInformation: Title := 'Informao';
   mtWarning: Title := 'Ateno';
   mtError: Title := 'Erro';
   mtConfirmation: Title := 'Confirmao';
   end;
   Result := MessageDlgBr(Title, Msg, DlgType, Buttons);
end;

end.
