unit UPrincipal;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ExtDlgs;

type
  TFPrincipal = class(TForm)
    Image1: TImage;
    Label1: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Label2: TLabel;
    Label5: TLabel;
    ComboBox1: TComboBox;
    Label3: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    CheckBox11: TCheckBox;
    CheckBox12: TCheckBox;
    Label4: TLabel;
    OpenPictureDialog1: TOpenPictureDialog;
    Button1: TButton;
    Button2: TButton;
    procedure ComboBox1Change(Sender: TObject);
    procedure Label4Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure CheckBox11Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FPrincipal: TFPrincipal;

implementation

uses UDialogsBr;

{$R *.dfm}

procedure TFPrincipal.ComboBox1Change(Sender: TObject);
begin
   Image1.Visible := ComboBox1.ItemIndex = 4;
   Label4.Visible := ComboBox1.ItemIndex = 4;

   If ComboBox1.ItemIndex = 4 then ComboBox1.Width := 361
   else ComboBox1.Width := 393;
end;

procedure TFPrincipal.Label4Click(Sender: TObject);
begin
   If OpenPictureDialog1.Execute then
      Image1.Picture.LoadFromFile(OpenPictureDialog1.FileName);
end;

procedure TFPrincipal.Button1Click(Sender: TObject);
Var
   Buttons: TMsgDlgButtons;
begin
   Buttons := [];
   If CheckBox1.Checked  then Buttons := Buttons + [mbYes];
   If CheckBox2.Checked  then Buttons := Buttons + [mbNo];
   If CheckBox3.Checked  then Buttons := Buttons + [mbCancel];
   If CheckBox4.Checked  then Buttons := Buttons + [mbOk];
   If CheckBox5.Checked  then Buttons := Buttons + [mbAll];
   If CheckBox6.Checked  then Buttons := Buttons + [mbIgnore];
   If CheckBox7.Checked  then Buttons := Buttons + [mbRetry];
   If CheckBox8.Checked  then Buttons := Buttons + [mbAbort];
   If CheckBox9.Checked  then Buttons := Buttons + [mbYesToAll];
   If CheckBox10.Checked then Buttons := Buttons + [mbNoToAll];
   If CheckBox11.Checked then Buttons := mbFind;
   If CheckBox12.Checked then Buttons := mbPrint;

   If Edit1.Text = '' then
   begin
//Se no se deseja alterar o caption do dilogo este assume um valor padro
      Case ComboBox1.ItemIndex of
      0: MessageDLGbr(Edit2.Text, mtWarning, Buttons);
      1: MessageDLGbr(Edit2.Text, mtConfirmation, Buttons);
      2: MessageDLGbr(Edit2.Text, mtError, Buttons);
      3: MessageDLGbr(Edit2.Text, mtInformation, Buttons);
      4:
      begin
         If OpenPictureDialog1.FileName <> '' then
            MessageDLGbr(OpenPictureDialog1.FileName, '',Edit2.Text, mtError, Buttons)
         else MessageDLGbr(Edit2.Text, mtCustom, Buttons);
      end;
      end;
   end
   Else
   Begin
      Case ComboBox1.ItemIndex of
      0: MessageDLGbr(Edit1.Text, Edit2.Text, mtWarning, Buttons);
      1: MessageDLGbr(Edit1.Text, Edit2.Text, mtConfirmation, Buttons);
      2: MessageDLGbr(Edit1.Text, Edit2.Text, mtError, Buttons);
      3: MessageDLGbr(Edit1.Text, Edit2.Text, mtInformation, Buttons);
      4:
      begin
         If OpenPictureDialog1.FileName <> '' then
            MessageDLGbr(OpenPictureDialog1.FileName, Edit1.Text, Edit2.Text, mtError, Buttons)
         else MessageDLGbr(Edit1.Text, Edit2.Text, mtCustom, Buttons);
      end;
      end;
   End;
end;

procedure TFPrincipal.Button2Click(Sender: TObject);
begin
   Close;
end;

procedure TFPrincipal.CheckBox11Click(Sender: TObject);
Var i: integer;
begin
   for i := 0 to ComponentCount-1 do
      if Components[i] is TCheckBox then
      begin
         If ((Sender as TCheckBox).Checked) and (Components[i] <> Sender) then
         begin
            (Components[i] as TCheckBox).Checked := False;
            (Components[i] as TCheckBox).Enabled := False;
         end
         else (Components[i] as TCheckBox).Enabled := True;
      end;
end;

end.
