unit ufrmCliente;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, frmCadBasico, FMTBcd, Provider, DBClient, DB, SqlExpr, ImgList,
  Menus, ComCtrls, Grids, DBGrids, StdCtrls, Buttons, ExtCtrls, Mask,
  DBCtrls;

type
  TfrmCliente = class(TfCadBasico)
    cdsCadBasicoCOD_CLIENTE: TIntegerField;
    cdsCadBasicoNOM_CLIENTE: TStringField;
    cdsCadBasicoTXT_ENDERECO: TStringField;
    cdsCadBasicoTXT_CEP: TStringField;
    cdsCadBasicoTXT_BAIRRO: TStringField;
    cdsCadBasicoTXT_CIDADE: TStringField;
    cdsCadBasicoCOD_ESTADO: TIntegerField;
    cdsCadBasicoNUM_DDD_TELEFONE: TStringField;
    cdsCadBasicoNUM_TELEFONE: TStringField;
    Label1: TLabel;
    NOM_CLIENTE: TDBEdit;
    Label2: TLabel;
    TXT_ENDERECO: TDBEdit;
    Label3: TLabel;
    TXT_CEP: TDBEdit;
    Label4: TLabel;
    TXT_BAIRRO: TDBEdit;
    Label5: TLabel;
    TXT_CIDADE: TDBEdit;
    Label6: TLabel;
    Label7: TLabel;
    NUM_DDD_TELEFONE: TDBEdit;
    Label8: TLabel;
    NUM_TELEFONE: TDBEdit;
    COD_ESTADO: TDBLookupComboBox;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    edtCodEstado: TDBLookupComboBox;
    edtNomCliente: TEdit;
    edtNomCidade: TEdit;
    procedure bbtPesquisarRegistroClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  protected
    function PersistirDados(): Integer; Override;
  public
    { Public declarations }
  end;

var
  frmCliente: TfrmCliente;

implementation

uses uDMConsulta;

{$R *.dfm}

{ TfrmCliente }

function TfrmCliente.PersistirDados(): Integer;
begin
  if cdsCadBasicoCOD_CLIENTE.IsNull then
  begin
   { TODO 1 -oDaniel -cClientes : Escolher e implementar forma de incrementar o cdigo do cliente (Artigo 004) }
   cdsCadBasicoCOD_CLIENTE.Value := -1;
  end;
  if cdsCadBasicoNOM_CLIENTE.IsNull then
  begin
    Application.MessageBox('O nome do cliente no foi informado!', 'Ateno', MB_ICONEXCLAMATION + MB_OK);
    NOM_CLIENTE.SetFocus;
    Result := -1;
    Exit;
  end;
  if cdsCadBasicoTXT_ENDERECO.IsNull then
  begin
    Application.MessageBox('O endereo do cliente no foi informado!', 'Ateno', MB_ICONEXCLAMATION + MB_OK);
    TXT_ENDERECO.SetFocus;
    Result := -1;
    Exit;
  end;
  if cdsCadBasicoTXT_CEP.IsNull then
  begin
    Application.MessageBox('O CEP do cliente no foi informado!', 'Ateno', MB_ICONEXCLAMATION + MB_OK);
    TXT_CEP.SetFocus;
    Result := -1;
    Exit;
  end;
  if cdsCadBasicoTXT_BAIRRO.IsNull then
  begin
    Application.MessageBox('O bairro do cliente no foi informado!', 'Ateno', MB_ICONEXCLAMATION + MB_OK);
    TXT_BAIRRO.SetFocus;
    Result := -1;
    Exit;
  end;
  if cdsCadBasicoTXT_CIDADE.IsNull then
  begin
    Application.MessageBox('A cidade do cliente no foi informado!', 'Ateno', MB_ICONEXCLAMATION + MB_OK);
    TXT_CIDADE.SetFocus;
    Result := -1;
    Exit;
  end;
  if cdsCadBasicoCOD_ESTADO.IsNull then
  begin
    Application.MessageBox('O estado do cliente no foi informado!', 'Ateno', MB_ICONEXCLAMATION + MB_OK);
    COD_ESTADO.SetFocus;
    Result := -1;
    Exit;
  end;
  if cdsCadBasicoNUM_DDD_TELEFONE.IsNull then
  begin
    Application.MessageBox('O DDD do cliente no foi informado!', 'Ateno', MB_ICONEXCLAMATION + MB_OK);
    NUM_DDD_TELEFONE.SetFocus;
    Result := -1;
    Exit;
  end;
  if cdsCadBasicoNUM_TELEFONE.IsNull then
  begin
    Application.MessageBox('O telefone do cliente no foi informado!', 'Ateno', MB_ICONEXCLAMATION + MB_OK);
    NUM_TELEFONE.SetFocus;
    Result := -1;
    Exit;
  end;

  Result := 0;
end;

procedure TfrmCliente.bbtPesquisarRegistroClick(Sender: TObject);
begin
  inherited;
  try
    cdsCadBasico.Close;
    with qryCadBasico do
    begin
      SQL.Clear;
      SQL.Add(' SELECT FIRST 500 ');
      SQL.Add('        COD_CLIENTE ');
      SQL.Add('      , NOM_CLIENTE ');
      SQL.Add('      , TXT_ENDERECO ');
      SQL.Add('      , TXT_CEP ');
      SQL.Add('      , TXT_BAIRRO ');
      SQL.Add('      , TXT_CIDADE ');
      SQL.Add('      , COD_ESTADO ');
      SQL.Add('      , NUM_DDD_TELEFONE ');
      SQL.Add('      , NUM_TELEFONE ');
      SQL.Add('   FROM TAB_CLIENTE ');
      SQL.Add('  WHERE (1 = 1) ');
      if Length(Trim(edtNomCliente.Text)) > 0 then
      begin
        SQL.Add('  AND NOM_CLIENTE LIKE :NOM_CLIENTE ');
        ParamByName('NOM_CLIENTE').AsString := '%' + edtNomCliente.Text + '%';
      end;
      if Length(Trim(edtNomCidade.Text)) > 0 then
      begin
        SQL.Add('  AND TXT_CIDADE LIKE :TXT_CIDADE ');
        ParamByName('TXT_CIDADE').AsString := '%' + edtNomCidade.Text + '%';
      end;
      if COD_ESTADO.KeyValue <> null then
      begin
        SQL.Add('  AND COD_ESTADO = :COD_ESTADO ');
        ParamByName('COD_ESTADO').AsInteger := COD_ESTADO.KeyValue;
      end;
      SQL.Add('  ORDER ');
      SQL.Add('     BY NOM_CLIENTE ');
      cdsCadBasico.Open;
    end;
  except
    on E:Exception do
    begin
      Raise Exception.Create('Ocorreu um erro ao pesquisar os clientes.' +#13+
                             'Mensagem: ' + e.Message + '.');
    end;
  end;
end;

procedure TfrmCliente.FormShow(Sender: TObject);
begin
  inherited;
  if dmConsulta.cdsEstado.Active then
  begin
    dmConsulta.cdsEstado.Close;
  end;
  dmConsulta.cdsEstado.Open;
end;

end.
