unit ufrmHTTP;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient,
  IdHTTP, ComCtrls, dateutils, IdException;

type
  TfrmHTTP = class(TForm)
    lbTaxa: TLabel;
    lbTamanho: TLabel;
    Button1: TButton;
    pbProgresso: TProgressBar;
    edtEndereco: TEdit;
    IdHTTP1: TIdHTTP;
    edtArquivo: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    procedure IdHTTP1WorkEnd(ASender: TObject; AWorkMode: TWorkMode);
    procedure Button1Click(Sender: TObject);
    procedure IdHTTP1Work(ASender: TObject; AWorkMode: TWorkMode;
      AWorkCount: Integer);
    procedure IdHTTP1WorkBegin(ASender: TObject; AWorkMode: TWorkMode;
      AWorkCountMax: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmHTTP: TfrmHTTP;

implementation

var
 TotalBytes: Integer;
 DataInicial: TDateTime;

{$R *.dfm}

procedure TfrmHTTP.IdHTTP1WorkBegin(ASender: TObject; AWorkMode: TWorkMode;
  AWorkCountMax: Integer);
begin
  if AWorkMode = wmRead then
    begin
    lbTaxa.Caption := '0 Kb/s ';
    DataInicial:= Now;
    Application.ProcessMessages;
    pbProgresso.Max := AWorkCountMax;
    TotalBytes:= AWorkCountMax;
    pbProgresso.Position := 0;
    end;

end;

procedure TfrmHTTP.IdHTTP1Work(ASender: TObject; AWorkMode: TWorkMode;
  AWorkCount: Integer);
Var
  TempoDecorrido: Cardinal;
begin
 try
  if AWorkMode=wmRead then
    pbProgresso.Position := AWorkCount;
  if AWorkMode=wmRead then
    begin
      TempoDecorrido := SecondsBetween(Now, DataInicial);
        if TempoDecorrido  > 0 then
          begin
          lbTaxa.Caption := Format(' %s Kbytes/segundo',
          [FormatFloat('0.00',(AWorkCount/1024)/ TempoDecorrido)]);
          Application.ProcessMessages;
          lbTamanho.Caption :=
       IntToStr(AWorkCount) + ' de ' + IntToStr(TotalBytes) + ' bytes';

          end;
     end;
  except
     On E : Exception do
        ShowMessage(E.Message);
  end;
end;




procedure TfrmHTTP.Button1Click(Sender: TObject);
var
  Dados : TFileStream;
begin
  Dados := TFileStream.Create(edtArquivo.Text,fmCreate);
  with IdHTTP1 do
  try
    try
      Get(edtEndereco.Text+edtArquivo.Text,Dados);
    except
      On E : Exception do
        ShowMessage('Problemas no download : '+E.Message);
    end;
  finally
    Dados.Free;
  end;


end;

procedure TfrmHTTP.IdHTTP1WorkEnd(ASender: TObject; AWorkMode: TWorkMode);
begin
ShowMessage('Download terminado com sucesso !');
end;

end.
