unit untIdioma;

interface


uses
  Windows,
  Messages,
  SysUtils,
  Variants,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  DB,
  DBClient,
  Grids,
  IniFiles,
  DBGrids,
  DBCtrls,
  StrUtils, Buttons {Adicionar esta Unit para funes de tratamento de strings};

const
  strDelimitador : String = '|';

type
  TfrmIdioma = class(TForm)
    pnlRodape: TPanel;
    btnGravar: TBitBtn;
    btnCancelar: TBitBtn;
    rdgIdioma: TRadioGroup;
    procedure btnGravarClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

    //* Abre formulrio para configurao do idioma [FB]
    class procedure GetConfiguracaoIdioma;

    //* Pega a configurao do idioma atual [FB]
    class function GetIdioma : Integer;


    //* Seta idioma [FB]
    class procedure SetIdioma(intIdioma: Integer; wclRecipiente: TWinControl);


  end;

var
  frmIdioma: TfrmIdioma;

implementation

uses TypInfo, untIdiomaTeste;

{$R *.dfm}

{ TfrmPrincipal }
class procedure TfrmIdioma.SetIdioma(intIdioma: Integer; wclRecipiente: TWinControl);
	Var
  	intObjeto : Integer;
  	intSelecionado : Integer;
    intPosFinal : Integer;
    intPropTexto : Integer;
    strTexto : String;
    stlPropTexto : TStringList;

  procedure SetPropObjeto( objInstancia : TObject; strPropriedade : String );
  Begin
      //* Verificando se existe uma propriedade de interface com usurio [FB]
      If ( GetPropInfo( objInstancia, stlPropTexto.Strings[ intPropTexto ] ) <> Nil ) Then
      Begin

        //* Recuperando o texto contido na propriedade [FB]
        strTexto := GetPropValue( objInstancia, stlPropTexto.Strings[ intPropTexto ] );

        //* Verificando se o texto foi recuperado [FB]
        If ( strTexto <> '' ) Then
        Begin
          //* Iniciando variveis [FB]
          intPosFinal := 0;
          intSelecionado := 0;

          //* Recuperando texto correspondente ao idioma setado [FB]
          While ( intSelecionado <= intIdioma ) Do
          Begin
            //* Recuperando a prxima posio do delimitador [FB]
            intPosFinal := Pos( strDelimitador, strTexto );

            //* Verificando se o delimitador foi encontrado [FB]
            If ( intPosFinal = 0 ) Then intPosFinal := Length( strTexto )+1;

            //* Verificando se o idioma atual NO  o que est configurado [FB]
            If ( intSelecionado <> intIdioma ) Then
            Begin
              //* Desprezando o idioma processado, pois no  o idioma configurado [FB]
              strTexto := MidStr( strTexto, intPosFinal+1, Length( strTexto ) );
            End;

            //* Processando o prximo idioma [FB]
            Inc( intSelecionado );
          End;

          //* Recuperando o texto correspondente ao idioma configurado [FB]
          strTexto := Trim( LeftStr( strTexto, intPosFinal-1 ) );

          //* Verificando se algum texto foi selecinado [FB]
          If (Length( strTexto ) > 0) And (intPosFinal > 0) Then
          Begin
            //* Setando o texto correspondente ao idioma na propriedade de interface com o usurio [FB]
            SetPropValue( objInstancia, stlPropTexto.Strings[ intPropTexto ], strTexto );
          End;
        End;
      End;
  End;

begin
  //* Configurando as propriedade de interface com o usurio [FB]
  stlPropTexto := TStringList.Create;
  stlPropTexto.Add( 'Caption' );
  stlPropTexto.Add( 'DisplayLabel' );
  stlPropTexto.Add( 'Hint' );

  //* Idiomas suportados: [FB]
	//* 0 = Portugus [FB]
  //* 1 = Ingls [FB]
  //* 2 = Espanhol [FB]

  //* Processando todos os objetos contidos no recipiente [FB]
  For intObjeto := 0 To wclRecipiente.ComponentCount-1 Do
  Begin
    //* Processando as propriedade de interface com o usurio que foram configuradas [FB]
    For intPropTexto := 0 To stlPropTexto.Count-1 Do
    Begin
      //* Setando a propriedade do objeto se necessrio [FB]
      SetPropObjeto( wclRecipiente.Components[ intObjeto ], stlPropTexto[ intPropTexto ] );
    End;
  End;

  //* Processando as propriedade de interface com o usurio que foram configuradas [FB]
  For intPropTexto := 0 To stlPropTexto.Count-1 Do
  Begin
    //* Setando a propriedade do objeto recipiente se necessrio [FB]
    SetPropObjeto( wclRecipiente, stlPropTexto[ intPropTexto ] );
  End;

end;


class function TfrmIdioma.GetIdioma: Integer;
  Var
    //*  necessrio adicionar a DCU: IniFiles [FB]
    iniArquivo : TIniFile;
begin
  //* Setando idioma de retorno padro (No caso 0 corresponde a portugus) [FB]
  Result := 0;

  //* Instanciando um objeto de controle de arquivos INI [FB]
  iniArquivo := TIniFile.Create( ExtractFilePath( Application.ExeName ) + 'idioma.ini' );

  Try

    //* Recuperando o idioma setado [FB]
    Result := StrToInt( iniArquivo.ReadString( 'GERAL', 'IDIOMA', '0' ) );

  Finally
    //* Destruindo o objeto de controle do arquivo INI [FB]
    FreeAndNil( iniArquivo );

  End;

end;

procedure TfrmIdioma.btnGravarClick(Sender: TObject);
  Var
    //*  necessrio adicionar a DCU: IniFiles [FB]
    iniArquivo : TIniFile;

begin

  //* Instanciando um objeto de controle de arquivos INI [FB]
  iniArquivo := TIniFile.Create( ExtractFilePath( Application.ExeName ) + 'idioma.ini' );

  Try
    //* Gravando o idioma selecionado no arquivo INI [FB]
    iniArquivo.WriteString( 'GERAL', 'IDIOMA', IntToStr( rdgIdioma.ItemIndex ) );

  Finally
    //* Destruindo o objeto de controle do arquivo INI [FB]
    FreeAndNil( iniArquivo );

  End;

end;

procedure TfrmIdioma.FormShow(Sender: TObject);
begin
  //* Recuperando o idioma setado [FB]
  rdgIdioma.ItemIndex := frmIdioma.GetIdioma;
end;

class procedure TfrmIdioma.GetConfiguracaoIdioma;
begin
  //* Instanciando o formulrio de configurao do idioma [FB]

  Try
    Application.CreateForm( TfrmIdioma, frmIdioma );
    frmIdioma.ShowModal;
  Finally
    FreeAndNil( frmIdioma );
  End;
end;

end.
