unit unBackupRest;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, IBServices, StdCtrls, Buttons, BmsXPButton, ComCtrls, ExtCtrls;

type
  TfrmRestBackup = class(TForm)
    Panel1: TPanel;
    RichEdit1: TRichEdit;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    GroupBox1: TGroupBox;
    Memo1: TMemo;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    SpeedButton1: TSpeedButton;
    IBRestoreService1: TIBRestoreService;
    procedure BitBtn1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private declarations }
    function RestauraBackup: boolean;
    function RestauraBackup_Completo: boolean;
  public
    { Public declarations }
  end;

var
  frmRestBackup: TfrmRestBackup;

implementation

{$R *.dfm}


procedure TfrmRestBackup.BitBtn1Click(Sender: TObject);
begin
  close;
end;

procedure TfrmRestBackup.SpeedButton1Click(Sender: TObject);
begin
  if RestauraBackup_Completo then
    MessageDlg('Restaurao realizada com sucesso', mtInformation, [mbOk], 0)
  else
    MessageDlg('Falhou a Restaurao do Backup', mtError, [mbOk], 0);
end;

function TfrmRestBackup.RestauraBackup: boolean;
begin
  Result := false;
  // permitir ao usurio selecionar o arquivo a ser restaurado
  if OpenDialog1.Execute then
  begin
    try
      Screen.Cursor := crHourGlass;
      // permitir ao usurio fornecer o nome do arquivo a ser gerado
      if SaveDialog1.Execute then
      begin
        Result := true;
        IBRestoreService1.LoginPrompt := False;
        IBRestoreService1.Params.Add('user_name=sysdba');
        IBRestoreService1.Params.Add('password=masterkey');
        try
          IBRestoreService1.Active := True;
          IBRestoreService1.DatabaseName.Add(SaveDialog1.FileName);
          IBRestoreService1.BackupFile.Add(OpenDialog1.FileName);
          IBRestoreService1.ServiceStart;
        except
          Result := false;
        end;
      end;
    finally
      IBRestoreService1.Active := False;
      Screen.Cursor := crDefault;
    end;
  end;
end;


function TfrmRestBackup.RestauraBackup_Completo: boolean;
begin
  Result := false;
  // permitir ao usurio selecionar o arquivo a ser restaurado
  if OpenDialog1.Execute then
  begin
    try
      Screen.Cursor := crHourGlass;
      RichEdit1.Clear;
      // permitir ao usurio fornecer o nome do arquivo a ser gerado
      if SaveDialog1.Execute then
      begin
        Result := true;
        IBRestoreService1.LoginPrompt := False;
        IBRestoreService1.Params.Add('user_name=sysdba');
        IBRestoreService1.Params.Add('password=masterkey');
        RichEdit1.SelAttributes.Color := clGreen;
        RichEdit1.SelAttributes.Size := 12;
        RichEdit1.Lines.Add(Format('Restaurao iniciada s %s h', [FormatDateTime('hh:nn:ss', now)]));
        try
          IBRestoreService1.Active := True;
          IBRestoreService1.Verbose := True;
          IBRestoreService1.DatabaseName.Add(SaveDialog1.FileName);
          IBRestoreService1.BackupFile.Add(OpenDialog1.FileName);
          IBRestoreService1.ServiceStart;
          //para escrever no memo ( direita do form)
          memo1.Clear;
          While not IBRestoreService1.Eof do
            Memo1.Lines.Add(IBRestoreService1.GetNextLine);
          RichEdit1.SelAttributes.Color := clBlack;      RichEdit1.SelAttributes.Size := 12;
          RichEdit1.Lines.Add('nome do arquivo gerado: ');
          RichEdit1.SelAttributes.Color := clBlue;
          RichEdit1.Lines.Add(SaveDialog1.FileName);
          RichEdit1.SelAttributes.Color := clGreen;
          RichEdit1.Lines.Add(Format('Finalizada s %s h', [FormatDateTime('hh:nn:ss', now)]));
        except
          Result := false;
          RichEdit1.SelAttributes.Color := clRed;
          RichEdit1.SelAttributes.Size := 14;
          RichEdit1.Lines.Add('Problemas na restaurao do Backup');
        end;
      end;
    finally
      IBRestoreService1.Active := False;
      Screen.Cursor := crDefault;
    end;
  end;
end;

end.
