unit untMosFotAssistente;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, untPaiAssistente, ComCtrls, StdCtrls, ExtCtrls, Buttons, ExtDlgs;

type
  TfrmMosFotAssistente = class(TfrmPaiAssistente)
    tabSelArquivo: TTabSheet;
    tabMosImagem: TTabSheet;
    edtArquivo: TEdit;
    Label2: TLabel;
    btnPesquisar: TButton;
    imgFigura: TImage;
    opdArquivo: TOpenPictureDialog;
    procedure btnConcluirClick(Sender: TObject);
    procedure btnPesquisarClick(Sender: TObject);
    procedure tabMosImagemShow(Sender: TObject);
    procedure btnCancelarClick(Sender: TObject);
  private
    { Private declarations }
  protected
    procedure ChkPasso( intPasso, intProPasso : Integer; var blnOk : Boolean ); Override;
  public
    { Public declarations }
  end;

var
  frmMosFotAssistente: TfrmMosFotAssistente;

implementation

{$R *.dfm}

procedure TfrmMosFotAssistente.btnConcluirClick(Sender: TObject);
begin
  inherited;
  Close;
end;

procedure TfrmMosFotAssistente.btnPesquisarClick(Sender: TObject);
begin
  inherited;

  If opdArquivo.Execute Then
  Begin
    edtArquivo.Text := opdArquivo.FileName;
  End;

end;



procedure TfrmMosFotAssistente.ChkPasso( intPasso, intProPasso : Integer; var blnOk : Boolean );
begin
  //* Executando a funcionalidade contida no ancestral [FB]
  inherited;

  //* Veririficando se o pai validou corretamente o passo a ser setado, se o passo  vlido e se est avanando [FB]
  If blnOk And ( intPasso >= 0 ) And ( intProPasso > intPasso ) Then
  Begin
    //* Checando condio para avanar para prxima pgina [FB]
    If pagAssistente.Pages[ intPasso ] = tabSelArquivo Then
    Begin
      //* Caso seja a pgina de seleo de arquivo [FB]

      //* Verificando se o arquivo foi informado [FB]
      If Length( Trim( edtArquivo.Text ) ) = 0 Then
      Begin
        //* O arquivo no foi informado [FB]
        ShowMessage( 'O nome do arquivo deve ser informado.' );
        If edtArquivo.CanFocus Then edtArquivo.SetFocus;
        blnOk := False;
      End;
    End;
  End;

end;

procedure TfrmMosFotAssistente.tabMosImagemShow(Sender: TObject);
begin
  inherited;

  If Length( Trim( edtArquivo.Text ) ) > 0 Then
  Begin
    //* Caso seja a pgina de mostragem da imagem [FB]
    imgFigura.Picture.LoadFromFile( edtArquivo.Text );
  End;

end;

procedure TfrmMosFotAssistente.btnCancelarClick(Sender: TObject);
begin
  inherited;
  Close;
end;

end.
