unit untPaiAssistente;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, StdCtrls, Buttons;

const
  //* Distncia entre um shape e outro [FB]
  intShaDistancia = 15;

  //* Posio horizontal do TShape [FB]
  intPosXShape = 32;

  //* Posio horizontal do TLabel [FB]
  intPosXLabel = 56;

type
  TfrmPaiAssistente = class(TForm)
    pnlRodape: TPanel;
    pnlControle: TPanel;
    pagAssistente: TPageControl;
    tabPasso0: TTabSheet;
    tabPassoN: TTabSheet;
    pnlBotDireita: TPanel;
    btnCancelar: TBitBtn;
    btnVoltar: TBitBtn;
    btnAvancar: TBitBtn;
    btnConcluir: TBitBtn;
    shaCaminho: TShape;
    shaPasso0: TShape;
    shaPassoN: TShape;
    shaPassoAtual: TShape;
    lblPasso0: TLabel;
    lblPassoN: TLabel;
    lblTitAssistente: TLabel;
    lblFinal: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnAvancarClick(Sender: TObject);
    procedure btnVoltarClick(Sender: TObject);
  private
    { Private declarations }
    stlShaObjeto : TStringList;
    stlLabObjeto : TStringList;

    //* Configura os passos de acordo com as novas folhas inseridas [FB]
  	procedure SetPassoConfiguracao;

    //* Setando o passo atual [FB]
    procedure SetPasso( intProPasso: Integer );

  protected
    //* Validando as informaes [FB]
    procedure ChkPasso( intPasso, intProPasso : Integer; var blnOk : Boolean ); Virtual;

  public
    { Public declarations }
  end;

var
  frmPaiAssistente: TfrmPaiAssistente;

implementation

{$R *.DFM}

procedure TfrmPaiAssistente.SetPassoConfiguracao;
	Var
  	intTabAtual : Integer;
    intProPosicao : Integer;

  procedure SetPasso;
  Begin

    //* Instanciando um TShape [FB]
    stlShaObjeto.AddObject( 'shaPasso' + IntToStr( stlShaObjeto.Count+1 ), TShape.Create( Self ) );
    With ( stlShaObjeto.Objects[ stlShaObjeto.Count-1 ] As TShape ) Do
    Begin
      Parent := pnlControle;
      Name := stlShaObjeto.Names[ stlShaObjeto.Count-1 ];
      Top := intProPosicao;
      Left := intPosXShape;
      Height := shaPasso0.Height;
      Width := shaPasso0.Width;
      Brush.Color := shaPasso0.Brush.Color;
      Pen.Color := shaPasso0.Pen.Color;
      Visible := True;
    End;

    //* Instanciando um TLabel [FB]
    stlLabObjeto.AddObject( 'lblPasso' + IntToStr( stlLabObjeto.Count+1 ), TLabel.Create( Self ) );
    With ( stlLabObjeto.Objects[ stlLabObjeto.Count-1 ] As TLabel ) Do
    Begin
      Parent := pnlControle;
      Name := stlLabObjeto.Names[ stlLabObjeto.Count-1 ];
      Top := intProPosicao;
      Left := intPosXLabel;
      Caption := pagAssistente.Pages[ intTabAtual ].Caption;
      Visible := True;
      Color := pnlControle.Color;
      Font := lblPasso0.Font;
    End;

    //* Calculando a prxima posio [FB]
    intProPosicao := ( stlShaObjeto.Objects[ stlShaObjeto.Count-1 ] As TShape ).Top + ( stlShaObjeto.Objects[ stlShaObjeto.Count-1 ] As TShape ).Width + intShaDistancia;

  End;
begin
  //* Prxima posio do objeto [FB]
  intProPosicao := shaPasso0.Top + shaPasso0.Height + intShaDistancia;

	//* Garantindo que a pgina de inicio seja o "Passo0"  [FB]
  tabPasso0.PageIndex := 0;

	//* Garantindo que a pgina final seja o "PassoN" [FB]
  tabPassoN.PageIndex := pagAssistente.PageCount-1;

	//* Verificando os passos inseridos [FB]
  For intTabAtual := 0 To pagAssistente.PageCount-1 Do
  Begin

  	//* Verificando se o TabSheet que est sendo verificado no  o de incio e nem o de trmino [FB]
  	If ( UpperCase( pagAssistente.Pages[ intTabAtual ].Name ) <> 'TABPASSO0' ) And
       ( UpperCase( pagAssistente.Pages[ intTabAtual ].Name ) <> 'TABPASSON' ) Then
    Begin

    	//* Setando o passo atual [FB]
      SetPasso;
    End;

    //* Setando as tabs do assistente para ficarem invisiveis [FB]
    pagAssistente.Pages[ intTabAtual ].TabVisible := False;

	End;


  //* Calculando posio do caminho de trmino [FB]
  shaPassoN.Top := ( stlShaObjeto.Objects[ stlShaObjeto.Count-1 ] As TShape ).Top + ( stlShaObjeto.Objects[ stlShaObjeto.Count-1 ] As TShape ).Height + intShaDistancia;

  //* Calculando posio do label de trmino [FB]
  lblPassoN.Top := shaPassoN.Top;

  //* Calculando tamanho do quadro do caminho [FB]
  shaCaminho.Height := shaPassoN.Top - intShaDistancia;

  //* Setando o ttulo do assistente [FB]
  lblTitAssistente.Caption := 'Iniciando o Assistente ' + Self.Caption;

  //* Habilitando passo atual [FB]
  shaPassoAtual.Visible := True;


end;

procedure TfrmPaiAssistente.SetPasso(intProPasso: Integer);
  Var
    blnOk : Boolean;
begin

  //* Verificando se  possvel passar para o passo informado [FB]
  ChkPasso( pagAssistente.ActivePageIndex, intProPasso, blnOk );

  //* Caso tudo esteja correto muda de passo [FB]
  If blnOk Then
  Begin

    //* Setando TabSheet Atual [FB]
    pagAssistente.ActivePageIndex := intProPasso;

    //* Posicionando o caminho [FB]
    If intProPasso = 0 Then
    Begin
      //* Caso seja passo 0 [FB]
      shaPassoAtual.Top := shaPasso0.Top;
      shaPassoAtual.Left := shaPasso0.Left;
    End
    Else If (intProPasso = pagAssistente.PageCount-1) Then
    Begin
      //* Caso seja passo N [FB]
      shaPassoAtual.Top := shaPassoN.Top;
      shaPassoAtual.Left := shaPassoN.Left;
    End
    Else
    Begin
      //* Caso seja outro passo [FB]
      shaPassoAtual.Top := ( stlShaObjeto.Objects[ intProPasso-1 ] As TShape ).Top;
      shaPassoAtual.Left := ( stlShaObjeto.Objects[ intProPasso-1 ] As TShape ).Left;
    End;

    //* Trazendo o Shape do caminho atual para frente [FB]
    shaPassoAtual.BringToFront;

  End;

  //* Se no for o ltimo passo libera o boto de avanar [FB]
  btnAvancar.Enabled := ( pagAssistente.ActivePageIndex < pagAssistente.PageCount-1 );

  //* Se no for o primeiro passo libera o boto de voltar [FB]
  btnVoltar.Enabled := ( pagAssistente.ActivePageIndex > 0 );

  //* Somente se for o ltimo passo libera o boto de concluir [FB]
  btnConcluir.Enabled := ( pagAssistente.ActivePageIndex = pagAssistente.PageCount-1 );

end;

procedure TfrmPaiAssistente.FormShow(Sender: TObject);
begin
  //* Setando os objetos de controle do assistente [FB]
	SetPassoConfiguracao;

  //* Setando o tab inicial [FB]
  SetPasso( 0 );

end;

procedure TfrmPaiAssistente.FormCreate(Sender: TObject);
begin
  //* Instanciando o controle de objetos tipo TShape [FB]
  stlShaObjeto := TStringList.Create;

  //* Instanciando o controle de objetos tipo TLabel [FB]
  stlLabObjeto := TStringList.Create;
end;


procedure TfrmPaiAssistente.btnAvancarClick(Sender: TObject);
begin
  //* Setando o prximo passo [FB]
  SetPasso( pagAssistente.ActivePageIndex+1 );
end;

procedure TfrmPaiAssistente.btnVoltarClick(Sender: TObject);
begin
  //* Setando o passo anterior [FB]
  SetPasso( pagAssistente.ActivePageIndex-1 );
end;

procedure TfrmPaiAssistente.ChkPasso( intPasso, intProPasso : Integer; var blnOk : Boolean );
begin
  blnOk := ( intProPasso >= 0 ) And ( intProPasso < pagAssistente.PageCount );
end;




end.
