unit untDM;

interface

uses
  SysUtils, Classes, DBXpress, FMTBcd, DB, SqlExpr, DBClient, Provider;

type
  TDM = class(TDataModule)
    scDados: TSQLConnection;
    qryClientes: TSQLQuery;
    qryProdutos: TSQLQuery;
    dspClientes: TDataSetProvider;
    dspProdutos: TDataSetProvider;
    cdsClientes: TClientDataSet;
    cdsProdutos: TClientDataSet;
    dsClientes: TDataSource;
    dsProdutos: TDataSource;
    cdsClientesCODCLI: TIntegerField;
    cdsClientesNOME: TStringField;
    cdsClientesLOGRADOURO: TStringField;
    cdsClientesNUMERO: TStringField;
    cdsClientesBAIRRO: TStringField;
    cdsClientesCIDADE: TStringField;
    cdsClientesESTADO: TStringField;
    cdsClientesPERMITIRPRAZO: TStringField;
    qryValorPadrao: TSQLQuery;
    dspValorPadrao: TDataSetProvider;
    cdsValorPadrao: TClientDataSet;
    dsValorPadrao: TDataSource;
    qryRestricoes: TSQLQuery;
    dspRestricoes: TDataSetProvider;
    cdsRestricoes: TClientDataSet;
    dsRestricoes: TDataSource;
    cdsProdutosCODPROD: TIntegerField;
    cdsProdutosDESCRICAO: TStringField;
    cdsProdutosUNIDADE: TStringField;
    cdsProdutosQTDE: TFMTBCDField;
    cdsProdutosCUSTO: TFMTBCDField;
    cdsProdutosVENDA: TFMTBCDField;
    cdsProdutosOBS: TMemoField;
    procedure cdsClientesBeforeOpen(DataSet: TDataSet);
    procedure cdsProdutosBeforeOpen(DataSet: TDataSet);
    procedure cdsValorPadraoAfterDelete(DataSet: TDataSet);
    procedure cdsRestricoesAfterDelete(DataSet: TDataSet);

  private
    { Private declarations }
  public
    { Public declarations }
    procedure DefinirValorPadrao(fTableName: string; var DataSet: TDataSet);
  end;

const
  NumericFieldTypes = [ftSmallint, ftInteger, ftWord, ftBoolean, ftFloat,
                       ftCurrency, ftBytes, ftLargeint, ftFMTBcd ];
var
  DM: TDM;

implementation

uses Variants;

{$R *.dfm}

procedure TDM.DefinirValorPadrao(fTableName: string;
  var DataSet: TDataSet);
var
  qry: TSQLQuery;
  F: TField;
begin
  qry := TSQLQuery.Create(Self);
  with qry do
  try
    SQLConnection := scDados;
    SQL.Text := 'SELECT * FROM '+
            'VALORPADRAO WHERE '+
            'TABLENAME = '+
            QuotedStr(fTableName);
    Open;
    while not Eof do
    begin
      F := DataSet.FieldByName(
             qry.FieldByName('FIELDNAME').AsString);
      if (F.DataType in NumericFieldTypes) then
        F.DefaultExpression :=
          qry.FieldByName('FIELDVALUE').AsString
      else
        F.DefaultExpression :=
          QuotedStr(qry.FieldByName('FIELDVALUE').AsString);
      Next;
    end;
    qry.Close;
  finally
    qry.Free;
  end;
end;

procedure TDM.cdsClientesBeforeOpen(DataSet: TDataSet);
begin
  DefinirValorPadrao('CLIENTES', DataSet);
end;

procedure TDM.cdsProdutosBeforeOpen(DataSet: TDataSet);
begin
  DefinirValorPadrao('PRODUTOS', DataSet);
end;

procedure TDM.cdsValorPadraoAfterDelete(DataSet: TDataSet);
begin
  with cdsValorPadrao do
    if ApplyUpdates(0)=0 then
      Refresh
    else
      raise Exception.Create('Erro ao Excluir');
end;

procedure TDM.cdsRestricoesAfterDelete(DataSet: TDataSet);
begin
  with cdsRestricoes do
    if ApplyUpdates(0)=0 then
      Refresh
    else
      raise Exception.Create('Erro ao Excluir');
end;

end.
