unit untFrmConfig;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Buttons, ExtCtrls, Grids, DBGrids, DBCtrls,
  SQLExpr;

type
  TfrmConfig = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Label1: TLabel;
    Edit1: TEdit;
    BitBtn1: TBitBtn;
    pnlRestricoes: TPanel;
    Label2: TLabel;
    cmbTabelaRestricao: TComboBox;
    Label3: TLabel;
    cmbCampoRestricao: TComboBox;
    BitBtn2: TBitBtn;
    DBGrid1: TDBGrid;
    Label4: TLabel;
    DBNavigator1: TDBNavigator;
    cmbTabelaVP: TComboBox;
    Label5: TLabel;
    Label6: TLabel;
    cmbCampoVP: TComboBox;
    labelVP: TLabel;
    edtVP: TEdit;
    BitBtn3: TBitBtn;
    DBGrid2: TDBGrid;
    DBNavigator2: TDBNavigator;
    Label7: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure cmbTabelaRestricaoChange(Sender: TObject);
    procedure cmbTabelaVPChange(Sender: TObject);
    procedure cmbCampoVPChange(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
  private
    { Private declarations }
    function RestricaoExiste(pTable, pField: String): Boolean;
  public
    { Public declarations }
  end;

var
  frmConfig: TfrmConfig;
  TableNames: TStringList;

implementation

uses untDM, DB, DBClient;

{$R *.dfm}

procedure TfrmConfig.BitBtn1Click(Sender: TObject);
begin
  if Edit1.Text = '123' then
    pnlRestricoes.Visible := True;
end;

procedure TfrmConfig.FormShow(Sender: TObject);
begin
  TableNames := TStringList.Create;
  dm.scDados.GetTableNames(TableNames,False);
  cmbTabelaRestricao.Items := TableNames;
  cmbTabelaVP.Items := TableNames;
end;

procedure TfrmConfig.BitBtn2Click(Sender: TObject);
begin
  if (Trim(cmbTabelaRestricao.Text)<>'') and
     (Trim(cmbCampoRestricao.Text)<>'') then
  begin
    with dm.cdsRestricoes do
    begin
      if not Active then Open;
      Append;
      FieldByName('TABLENAME').AsString :=
        cmbTabelaRestricao.Text;
      FieldByName('FIELDNAME').AsString :=
        cmbCampoRestricao.Text;
      Post;
      if ApplyUpdates(0)<>0 then
      begin
        ShowMessage('Erro ao cadastrar restrio');
        CancelUpdates;
      end
      else
      begin
        ShowMessage('Cadastrado com sucesso!');
        cmbTabelaRestricao.ClearSelection;
        cmbCampoRestricao.ClearSelection;
      end;
    end;
  end;
end;

procedure TfrmConfig.cmbTabelaRestricaoChange(Sender: TObject);
begin
  dm.scDados.GetFieldNames(cmbTabelaRestricao.Text,cmbCampoRestricao.Items);
  with dm.cdsRestricoes do
  begin
    Close;
    Params.ParamByName('TABLENAME').AsString :=
      cmbTabelaRestricao.Text;
    Open;
  end;
end;

function TfrmConfig.RestricaoExiste(pTable, pField: String): Boolean;
var qry: TSQLQuery;
    SQLwhere: string;
begin
  Result := False;

  SQLWhere := 'WHERE TABLENAME = '+
    QuotedStr(pTable);
  if pField<>'' then
    SQLWhere := SQLwhere +
      ' AND FIELDNAME = '+
      QuotedStr(pField)
  else
    SQLWhere := SQLwhere +
      ' AND FIELDNAME = '+
      QuotedStr('*');

  qry := TSQLQuery.Create(Self);
  with qry do
  try
    SQLConnection := dm.scDados;
    SQL.Text := 'SELECT * FROM'+
                ' RESTRICOES '+
                SQLwhere;
    Open;
    if not IsEmpty then
      Result := True;
    Close;
  finally
    Free;
  end;
end;

procedure TfrmConfig.cmbTabelaVPChange(Sender: TObject);
begin
  if cmbTabelaVP.Text = '' then exit;
  if RestricaoExiste(
          cmbTabelaVP.Text,
          '') then
  begin
    ShowMessage('Tabela Restrita!');
    cmbTabelaVP.ClearSelection;
    cmbCampoVP.Clear;
    exit;
  end;
  dm.scDados.GetFieldNames(
    cmbTabelaVP.Text,
    cmbCampoVP.Items);
  with dm.cdsValorPadrao do
  begin
    Close;
    Params.ParamByName('TABLENAME').AsString :=
      cmbTabelaVP.Text;
    Open;
  end;
end;

procedure TfrmConfig.cmbCampoVPChange(Sender: TObject);
begin
  if cmbCampoVP.Text = '' then exit;
  if RestricaoExiste(
       cmbTabelaVP.Text,
       cmbCampoVP.Text) then
  begin
    ShowMessage('Campo Restrito!');
    cmbCampoVP.ClearSelection;
    exit;
  end;
  edtVP.SetFocus;
end;

procedure TfrmConfig.BitBtn3Click(Sender: TObject);
begin
  if (Trim(cmbTabelaVP.Text)<>'') and
     (Trim(cmbCampoVP.Text)<>'') and
     (Trim(edtVP.Text)<>'') then
  begin
  with dm.cdsValorPadrao do
  begin
    Append;
    FieldByName('TABLENAME').AsString :=
      cmbTabelaVP.Text;
    FieldByName('FIELDNAME').AsString :=
      cmbCampoVP.Text;
    FieldByName('FIELDVALUE').AsString :=
      edtVP.Text;
    Post;
    if ApplyUpdates(0)<>0 then
    begin
      ShowMessage('Erro ao cadastrar valor padro');
      CancelUpdates;
    end
    else
    begin
      ShowMessage('Cadastrado com sucesso!');
      cmbTabelaVP.ClearSelection;
      cmbCampoVP.ClearSelection;
      edtVP.Clear;
    end;
  end;
  end
  else
    ShowMessage('Preencha todos os '+
          'campos antes de gravar!');
end;

end.
