unit untCdsOrdenacao;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, DBClient, Grids, DBGrids, ExtCtrls, DBCtrls,
  StrUtils, StdCtrls {Adicionar esta unit para utilizar funes com strings};

const
  //* Constantes do Sistema (CS) [FB]
  CS_IndMaxName = 31;

type
  TfrmCdsOrdenacao = class(TForm)
    ClientDataSet1: TClientDataSet;
    DataSource1: TDataSource;
    ClientDataSet1VENCIMENTO: TDateTimeField;
    ClientDataSet1VALOR: TCurrencyField;
    ClientDataSet1DESCRICAO: TStringField;
    ClientDataSet1FORNECEDOR: TStringField;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    pnlRodape: TPanel;
    Edit1: TEdit;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure DBGrid1TitleClick(Column: TColumn);
    procedure DBGrid1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure DBGrid1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
    //* Campos selecionados [FB]
    stlIndCamSelecionado : TStringList;

    //* Se o Shift est pressionado [FB]
    blnKeyShift : Boolean;

    //* Verifica se o valor est em branco [FB]
    function ChkValorVazio( varValor : Variant ) : Boolean;

    //* Retorna uma string contendo os valores de um StringList separado por um separador [FB]
    function GetStlLisSeparado( stlSepara : TStringList; strSeparador : String = ';') : String;

    //* Retorna um StringList a partir de uma string com separador [FB]
    function GetStrDeStringList( strOrigem : String; strSeparador : String = ';' ) : TStringList;

    //* Retorna um stringlist contendo os campos que compoe o indice [FB]
    function GetCamIndComposto( ClientDataSet : TClientDataSet ) : TStringList;

    //* Adiciona um indice ao ClientDataSet [FB]
    procedure SetIndice( stlNomColuna : TStringList; blnAdicionar : Boolean = False );

  public
    { Public declarations }
  end;

var
  frmCdsOrdenacao: TfrmCdsOrdenacao;

implementation

{$R *.dfm}

{ TForm1 }

function TfrmCdsOrdenacao.ChkValorVazio(varValor: Variant): Boolean;
  var
    strValor : String;
    dtaValor : TDateTime;
    intRetorno : Integer;
Begin
  Result := True;

  intRetorno := VarType( varValor );


  Try
    strValor := VarToStr( varValor );
    Result := ( (Length( Trim( strValor ) ) <= 0) );

  except
    On E: EConvertError Do
    Begin
      If ( VarType( varValor ) = varDate ) Then
      Begin
        dtaValor := VarToDateTime( varValor );

        Result := ( dtaValor = 0 );
      End;
    end;

  end;

End;



//* Retorna uma string contendo os valores de um StringList separado por um separador [FB]
function TfrmCdsOrdenacao.GetStlLisSeparado( stlSepara : TStringList; strSeparador : String = ';') : String;
  Var
    intIndice : Integer;
    strRetorno : String;
Begin

  strRetorno := '';
  For intIndice := 0 To stlSepara.Count-1 Do
  Begin
    If Not ChkValorVazio( strRetorno ) Then strRetorno := strRetorno + strSeparador;

    //* No haver corte [FB]
    strRetorno := strRetorno + stlSepara.Strings[ intIndice ];
  End;

  Result := strRetorno;

End;

procedure TfrmCdsOrdenacao.DBGrid1TitleClick(Column: TColumn);
begin
  //* Verificando se o Shift est pressionado [FB]
  If ( Not blnKeyShift ) Then
  Begin
    //* Limpando o objeto de controle dos campos a serem indexados [FB]
    stlIndCamSelecionado.Clear;
  End;

  //* Verificando se o campo a ser adicionado j est na lista daqueles que sero indexados [FB]
  If ( stlIndCamSelecionado.IndexOf( Column.FieldName ) >= 0 ) Then
  Begin
    //* Verificando se o ndice j  descendente [FB]
    If ( ixDescending In ClientDataSet1.IndexDefs.Find( ClientDataSet1.IndexName ).Options ) Then
    Begin
      //* Deletando o ndice pois ele j  descendente e deve ser criado novamente como ascendente [FB]
      stlIndCamSelecionado.Delete( stlIndCamSelecionado.IndexOf( Column.FieldName ) );
    end;
  End
  Else
  Begin
    //* Adicionando o campo que deve ser indexado [FB]
    stlIndCamSelecionado.Add( Column.FieldName );
  End;

  //* Aplicando os campos indexados [FB]
  SetIndice( stlIndCamSelecionado );

  //* Exibindo o ndice Atual [FB]
  Edit1.Text := GetStlLisSeparado( GetCamIndComposto( ClientDataSet1 ) );
  If ( ixDescending In ClientDataSet1.IndexDefs.Find( ClientDataSet1.IndexName ).Options ) Then
  Begin
    Edit1.Text := Edit1.Text + ' [Descendente]';
  end;

end;

procedure TfrmCdsOrdenacao.SetIndice(stlNomColuna: TStringList; blnAdicionar: Boolean);
  Var
    strIndAscendente, strIndDescendente : String;
    stlAdicionar : TStringList;
    intIndice : Integer;

  //* Procedimento encapsulado que cria o ndice ascendente [FB]
  procedure SetIndAscendente;
  Begin
    If ( ClientDataset1.IndexDefs.IndexOf( strIndAscendente ) < 0 ) Then
    Begin
      ClientDataset1.IndexDefs.Add( strIndAscendente, GetStlLisSeparado( stlNomColuna ), [] );
    End;

    ClientDataset1.IndexName := strIndAscendente;
  End;

  //* Procedimento encapsulado que cria o ndice descendente [FB]
  procedure SetIndDescendente;
  Begin
    If ( ClientDataset1.IndexDefs.IndexOf( strIndDescendente ) < 0 ) Then
    Begin
      ClientDataset1.IndexDefs.Add( strIndDescendente, GetStlLisSeparado( stlNomColuna ), [ ixDescending ] );
    End;

    ClientDataset1.IndexName := strIndDescendente;
  End;


begin
  If blnAdicionar Then
  Begin
    If Not ChkValorVazio( ClientDataset1.IndexName ) Then
    Begin
      Try
        stlAdicionar := TStringList.Create;
        stlAdicionar := GetStrDeStringList( ClientDataset1.IndexDefs.Find( ClientDataset1.IndexName ).Fields );

        For intIndice := 0 To stlAdicionar.Count-1 Do
        Begin
          stlNomColuna.Insert( 0, stlAdicionar.Strings[ intIndice ] );
        End;

      Finally
        FreeAndNil( stlAdicionar );
      End;
    End;
  End;

  If ( stlNomColuna.Count > 0 ) Then
  Begin

    strIndAscendente := 'IA' + GetStlLisSeparado( stlNomColuna, '' );
    strIndDescendente := 'ID' + GetStlLisSeparado( stlNomColuna, '' );

    //* Verificando tamanho do nome do arquivo Gerado[FB]
    If ( Length( strIndAscendente ) > CS_IndMaxName ) Then
    Begin
      ShowMessage( 'No  possvel adicionar mais colunas ao ndice.' );

      //* Setando o acumulo de ndice como falso [FB]
      blnKeyShift := False;
    End
    Else
    Begin
      //* Verificando se j existe um indice setado [FB]
      If ( ClientDataset1.IndexName = strIndAscendente ) Then
      Begin
        SetIndDescendente;
      End
      Else
      Begin
        SetIndAscendente;
      End;
    End;

  End;

end;


function TfrmCdsOrdenacao.GetStrDeStringList(strOrigem,
  strSeparador: String): TStringList;
  Var
    stlRetorno : TStringList;

Begin
  stlRetorno := TStringList.Create;

  While Pos( strSeparador, strOrigem ) > 0 Do
  Begin
    stlRetorno.Add( MidStr( strOrigem, 1, Pos( strSeparador, strOrigem )-1 ) );
    strOrigem := MidStr( strOrigem, Pos( strSeparador, strOrigem )+1, Length( strOrigem ) );
  End;

  stlRetorno.Add( strOrigem );

  Result := stlRetorno;

end;

procedure TfrmCdsOrdenacao.FormCreate(Sender: TObject);
begin
  //* Inicializando a varivel de controle dos campos acumulados para indexao [FB]
  stlIndCamSelecionado := TStringList.Create;

  //* Inicializando a varivel de controle da tecla Shift [FB]
  blnKeyShift := False;

end;

procedure TfrmCdsOrdenacao.DBGrid1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  blnKeyShift := ( ssShift In Shift );

  If blnKeyShift And ( stlIndCamSelecionado.Count <= 0 ) Then
  Begin
    stlIndCamSelecionado := GetCamIndComposto( ClientDataSet1 );
  End;


end;

function TfrmCdsOrdenacao.GetCamIndComposto( ClientDataSet : TClientDataSet ) : TStringList;
  Var
    stlIndice : TStringList;
begin

  stlIndice := TStringList.Create;
  Result := stlIndice;

  If Not ChkValorVazio( ClientDataSet.IndexName ) Then
  Begin
    stlIndice := GetStrDeStringList( ClientDataSet1.IndexDefs.Find( ClientDataSet.IndexName ).Fields );
    Result := stlIndice;
  End;

end;

procedure TfrmCdsOrdenacao.DBGrid1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  If ( blnKeyShift ) Then
  Begin
    blnKeyShift := False;
    stlIndCamSelecionado.Clear;
  End;

end;

end.
