/******************************************************************************/
/****         Generated by IBExpert                                        ****/
/******************************************************************************/

SET SQL DIALECT 3;
SET NAMES WIN1252;

/* Mude o caminho para a pasta onde voc deseja criar o banco de dados  */
CREATE DATABASE 'localhost:C:\SP_TRIGGER.FDB'
USER 'SYSDBA' PASSWORD 'masterkey'
PAGE_SIZE 16384
DEFAULT CHARACTER SET WIN1252;



/******************************************************************************/
/****                        User Defined Functions                        ****/
/* 
As intrues SQL para incluso das funes no banco de dados foram copiadas
do arquivo ib_udf.sql contido na pasta UDF dentro da pasta de instalao
do servidor Firebird. As funes esto contidas na UDF ib_udf.
*/
/******************************************************************************/

DECLARE EXTERNAL FUNCTION LPAD
    CSTRING(255),
    INTEGER,
    CSTRING(1)
    RETURNS CSTRING(255) FREE_IT
    ENTRY_POINT 'IB_UDF_lpad' MODULE_NAME 'ib_udf';


DECLARE EXTERNAL FUNCTION LTRIM
    CSTRING(255)
    RETURNS CSTRING(255) FREE_IT
    ENTRY_POINT 'IB_UDF_ltrim' MODULE_NAME 'ib_udf';


DECLARE EXTERNAL FUNCTION RPAD
    CSTRING(255),
    INTEGER,
    CSTRING(1)
    RETURNS CSTRING(255) FREE_IT
    ENTRY_POINT 'IB_UDF_rpad' MODULE_NAME 'ib_udf';


DECLARE EXTERNAL FUNCTION RTRIM
    CSTRING(255)
    RETURNS CSTRING(255) FREE_IT
    ENTRY_POINT 'IB_UDF_rtrim' MODULE_NAME 'ib_udf';


DECLARE EXTERNAL FUNCTION STRLEN
    CSTRING(32767)
    RETURNS INTEGER BY VALUE
    ENTRY_POINT 'IB_UDF_strlen' MODULE_NAME 'ib_udf';


DECLARE EXTERNAL FUNCTION SUBSTR
    CSTRING(255),
    SMALLINT,
    SMALLINT
    RETURNS CSTRING(255) FREE_IT
    ENTRY_POINT 'IB_UDF_substr' MODULE_NAME 'ib_udf';


DECLARE EXTERNAL FUNCTION SUBSTRLEN
    CSTRING(255),
    SMALLINT,
    SMALLINT
    RETURNS CSTRING(255) FREE_IT
    ENTRY_POINT 'IB_UDF_substrlen' MODULE_NAME 'ib_udf';




/******************************************************************************/
/****                              Generators                              ****/
/******************************************************************************/

CREATE GENERATOR GEN_EMPRESA_ID;
CREATE GENERATOR GEN_FUNCIONARIO_ID;
CREATE GENERATOR GEN_PRODUTO_ID;
CREATE GENERATOR GEN_ENTRADA_ID;
CREATE GENERATOR GEN_VENDA_ID;

/******************************************************************************/
/****                                Tables                                ****/
/******************************************************************************/

CREATE TABLE EMPRESA (
    COD_EMPRESA  INTEGER NOT NULL,
    CNPJ         VARCHAR(14) NOT NULL,
    ENDERECO     VARCHAR(50) NOT NULL,
    CIDADE       VARCHAR(50) NOT NULL,
    CONSTRAINT PK_EMPRESA PRIMARY KEY (COD_EMPRESA)
);


CREATE TABLE ENTRADA (
    COD_ENTRADA   INTEGER NOT NULL,
    NR_DOCUMENTO  INTEGER NOT NULL,
    DATA          DATE NOT NULL,
    COD_EMPRESA   INTEGER NOT NULL,
    CONSTRAINT PK_ENTRADA PRIMARY KEY (COD_ENTRADA)
);

CREATE TABLE CLIENTE (
    COD_CLIENTE  INTEGER NOT NULL,
    NOME         VARCHAR(50) NOT NULL,
    CPF          VARCHAR(101) CHARACTER SET NONE NOT NULL,
    CONSTRAINT PK_CLIENTE PRIMARY KEY (COD_CLIENTE)
);

CREATE TABLE FUNCIONARIO (
    COD_FUNCIONARIO  INTEGER NOT NULL,
    NOME             VARCHAR(50) NOT NULL,
    MATRICULA        VARCHAR(10) CHARACTER SET NONE NOT NULL,
    COD_EMPRESA      INTEGER NOT NULL,
    CONSTRAINT PK_FUNCIONARIO PRIMARY KEY (COD_FUNCIONARIO)
);


CREATE TABLE ITEM_ENTRADA (
    COD_ENTRADA  INTEGER NOT NULL,
    COD_PRODUTO  INTEGER NOT NULL,
    QUANTIDADE   DECIMAL(9,3) NOT NULL,
    VALOR        DECIMAL(9,2) NOT NULL,
    CONSTRAINT PK_ITEM_ENTRADA PRIMARY KEY (COD_ENTRADA, COD_PRODUTO)
);


CREATE TABLE ITEM_VENDA (
    COD_VENDA    INTEGER NOT NULL,
    NR_ITEM      INTEGER NOT NULL,
    COD_PRODUTO  VARCHAR(13) NOT NULL,
    VALOR        DECIMAL(9,2) NOT NULL,
    QUANTIDADE   DECIMAL(9,3) NOT NULL,
    CONSTRAINT PK_ITEM_VENDA PRIMARY KEY (COD_VENDA, NR_ITEM)
);


CREATE TABLE PRODUTO (
    COD_PRODUTO          INTEGER NOT NULL,
    COD_BARRAS           VARCHAR(13) NOT NULL,
    DESCRICAO            VARCHAR(50) NOT NULL,
    ESTOQUE_ATUAL        DECIMAL(9,3) NOT NULL,
    ULTIMO_PRECO_COMPRA  DECIMAL(9,2),
    PRECO_VENDA          DECIMAL(9,2) NOT NULL,
    MEDIA_PRECO_COMPRA   DECIMAL(9,2),
    COD_EMPRESA          INTEGER NOT NULL,
    CONSTRAINT PK_PRODUTO PRIMARY KEY (COD_PRODUTO)
);


CREATE TABLE VENDA (
    COD_VENDA        INTEGER NOT NULL,
    DATA             DATE DEFAULT CURRENT_TIMESTAMP NOT NULL,
    NUMERO_CAIXA     SMALLINT NOT NULL,
    COD_FUNCIONARIO  INTEGER NOT NULL,
    FORMA_PAGAMENTO  VARCHAR(2) CHARACTER SET NONE,
    COD_EMPRESA      INTEGER NOT NULL,
    COD_CLIENTE      INTEGER NOT NULL,
    CONSTRAINT PK_VENDA PRIMARY KEY (COD_VENDA)
);



/******************************************************************************/
/****                             Constraints                              ****/
/******************************************************************************/

ALTER TABLE ENTRADA ADD CONSTRAINT FK_ENTRADA_EMPRESA
    FOREIGN KEY (COD_EMPRESA) REFERENCES EMPRESA (COD_EMPRESA);
ALTER TABLE FUNCIONARIO ADD CONSTRAINT FK_FUNCIONARIO_EMPRESA
    FOREIGN KEY (COD_EMPRESA) REFERENCES EMPRESA (COD_EMPRESA);
ALTER TABLE ITEM_ENTRADA ADD CONSTRAINT FK_ITEM_ENTRADA_ENTRADA
    FOREIGN KEY (COD_ENTRADA) REFERENCES ENTRADA (COD_ENTRADA) ON DELETE CASCADE;
ALTER TABLE ITEM_ENTRADA ADD CONSTRAINT FK_ITEM_ENTRADA_PRODUTO
    FOREIGN KEY (COD_PRODUTO) REFERENCES PRODUTO (COD_PRODUTO);
ALTER TABLE ITEM_VENDA ADD CONSTRAINT FK_ITEM_VENDA_PRODUTO
    FOREIGN KEY (COD_PRODUTO) REFERENCES PRODUTO (COD_PRODUTO);
ALTER TABLE ITEM_VENDA ADD CONSTRAINT FK_ITEM_VENDA_VENDA
    FOREIGN KEY (COD_VENDA) REFERENCES VENDA (COD_VENDA) ON DELETE CASCADE;
ALTER TABLE PRODUTO ADD CONSTRAINT FK_PRODUTO_EMPRESA
    FOREIGN KEY (COD_EMPRESA) REFERENCES EMPRESA (COD_EMPRESA);
ALTER TABLE VENDA ADD CONSTRAINT FK_VENDA_EMPRESA
    FOREIGN KEY (COD_EMPRESA) REFERENCES EMPRESA (COD_EMPRESA);
ALTER TABLE VENDA ADD CONSTRAINT FK_VENDA_CLIENTE
    FOREIGN KEY (COD_CLIENTE) REFERENCES CLIENTE(COD_CLIENTE);
ALTER TABLE VENDA ADD CONSTRAINT FK_VENDA_FUNCIONARIO
    FOREIGN KEY (COD_FUNCIONARIO) REFERENCES FUNCIONARIO (COD_FUNCIONARIO);


ALTER TABLE PRODUTO ADD CONSTRAINT UC_PRODUTO UNIQUE (COD_EMPRESA, COD_BARRAS);
ALTER TABLE CLIENTE ADD CONSTRAINT UC_CLIENTE UNIQUE (CPF);

/******************************************************************************/
/****                         Triggers for tables                          ****/
/******************************************************************************/

SET TERM ^ ;


CREATE TRIGGER ATUALIZA_ESTOQUE_ENTRADA FOR ITEM_ENTRADA
ACTIVE BEFORE INSERT OR UPDATE OR DELETE POSITION 0
as

begin
  /* Se o usurio est alterando ou deletando
  um registro de ITEM_ENTRADA deve-se
  subtrair o valor antigo do campo quantidade
  do estoque do produto, retirando a quantidade includa
  anteriormente no estoque. */
  if (updating or deleting) then
  begin
     update PRODUTO set ESTOQUE_ATUAL = ESTOQUE_ATUAL - old.QUANTIDADE
     where COD_PRODUTO = OLD.COD_PRODUTO;
  end

  if (inserting or updating) then
  begin
     update PRODUTO set
     ESTOQUE_ATUAL = ESTOQUE_ATUAL + new.QUANTIDADE
     where COD_PRODUTO = new.COD_PRODUTO;

     /* Atualiza os preos na tabela PRODUTO se o valor do mesmo na
     tabela ITEM_ENTRADA for diferente do cadastrado no PRODUTO. */

     /*O valor 0.3 representa 30% de margem de lucro a ser acrescido
     no preo de venda do PRODUTO.*/
     update PRODUTO
     set ULTIMO_PRECO_COMPRA = new.VALOR,
     PRECO_VENDA = new.VALOR + (new.VALOR*0.3)
     where COD_PRODUTO = new.COD_PRODUTO and
     new.VALOR <> ULTIMO_PRECO_COMPRA;
  end
end
^


CREATE TRIGGER ATUALIZA_ESTOQUE_VENDA FOR ITEM_VENDA
ACTIVE BEFORE INSERT OR UPDATE OR DELETE POSITION 0
AS
begin
    IF (updating or deleting) THEN
       update PRODUTO set ESTOQUE_ATUAL = ESTOQUE_ATUAL + OLD.QUANTIDADE
       where COD_PRODUTO = OLD.COD_PRODUTO;

    IF (inserting or updating) THEN
       update PRODUTO set ESTOQUE_ATUAL = ESTOQUE_ATUAL - NEW.QUANTIDADE
       where COD_PRODUTO = NEW.COD_PRODUTO;
end
^

CREATE TRIGGER EMPRESA_BI FOR EMPRESA
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  IF ((NEW.COD_EMPRESA IS NULL) or (NEW.COD_EMPRESA <= 0)) THEN
    NEW.COD_EMPRESA = GEN_ID(GEN_EMPRESA_ID,1);
END
^

CREATE TRIGGER FUNCIONARIO_BI FOR FUNCIONARIO
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  IF ((NEW.COD_FUNCIONARIO IS NULL) or (NEW.COD_FUNCIONARIO <=0)) THEN
    NEW.COD_FUNCIONARIO = GEN_ID(GEN_FUNCIONARIO_ID,1);
END
^

CREATE TRIGGER GERA_MATRICULA_FUNC FOR FUNCIONARIO
ACTIVE BEFORE INSERT OR UPDATE POSITION 0
AS
declare variable MAIOR_MATRICULA VARCHAR(5);
begin
  SELECT MAX(MATRICULA)
  FROM FUNCIONARIO
  WHERE COD_EMPRESA = NEW.COD_EMPRESA
  INTO :MAIOR_MATRICULA;

  if (MAIOR_MATRICULA IS NULL) then
     MAIOR_MATRICULA = '1';
  ELSE
  BEGIN
     MAIOR_MATRICULA = SUBSTRLEN(MAIOR_MATRICULA, 3, 3);
     MAIOR_MATRICULA =
       CAST(
         CAST(MAIOR_MATRICULA AS INTEGER) + 1 AS VARCHAR(3)
       );
  END

  NEW.MATRICULA =
    LPAD(CAST(NEW.COD_EMPRESA AS VARCHAR(2)), 2, '0') ||
    LPAD(MAIOR_MATRICULA, 3, '0');
end
^

CREATE TRIGGER PRODUTO_BI FOR PRODUTO
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  IF ((NEW.COD_PRODUTO IS NULL) or (NEW.COD_PRODUTO <= 0)) THEN
    NEW.COD_PRODUTO = GEN_ID(GEN_PRODUTO_ID,1);
END
^

/******************************************************************************/
/****                          Stored Procedures                           ****/
/******************************************************************************/


CREATE PROCEDURE SP_ATUALIZA_PRECO_MEDIO_PRODUTO (
    DATA_INICIAL DATE,
    DATA_FINAL DATE,
    COD_EMPRESA INTEGER)
AS
begin
  UPDATE PRODUTO
  SET MEDIA_PRECO_COMPRA =
  (
      SELECT AVG(IE.VALOR)
      FROM ITEM_ENTRADA IE
      INNER JOIN ENTRADA E ON E.COD_ENTRADA = IE.COD_ENTRADA
      WHERE E.DATA BETWEEN :DATA_INICIAL AND :DATA_FINAL
      AND PRODUTO.COD_PRODUTO = IE.COD_PRODUTO
  )
  WHERE COD_EMPRESA = :COD_EMPRESA;
end
^

CREATE PROCEDURE SP_VENDAS_POR_FORMA_PGTO (
    ANO SMALLINT,
    COD_EMPRESA INTEGER)
RETURNS (
    MES_ANO_VENDA VARCHAR(7),
    DINHEIRO INTEGER,
    CHEQUE INTEGER,
    TOTAL_VENDAS INTEGER)
AS
DECLARE VARIABLE SOMA_DINHEIRO INTEGER;
DECLARE VARIABLE SOMA_CHEQUE INTEGER;
begin
  SOMA_DINHEIRO = 0;
  SOMA_CHEQUE = 0;
  TOTAL_VENDAS = 0;
  FOR SELECT
    CAST(EXTRACT(MONTH FROM DATA) AS VARCHAR(2)) || '/' || CAST(:ANO AS VARCHAR(4)),
    SUM(CASE WHEN FORMA_PAGAMENTO = 'D' THEN 1 ELSE 0 END) AS DINHEIRO,
    SUM(CASE WHEN FORMA_PAGAMENTO = 'CH' THEN 1 ELSE 0 END) AS CHEQUE
    FROM VENDA WHERE EXTRACT(YEAR FROM DATA) = :ANO
    AND VENDA.COD_EMPRESA = :COD_EMPRESA
    GROUP BY EXTRACT(MONTH FROM DATA)
    INTO :MES_ANO_VENDA, :DINHEIRO, :CHEQUE DO
   BEGIN
     SOMA_DINHEIRO = SOMA_DINHEIRO + DINHEIRO;
     SOMA_CHEQUE = SOMA_CHEQUE + CHEQUE;
     TOTAL_VENDAS = DINHEIRO + CHEQUE;
     SUSPEND;
   END

   MES_ANO_VENDA = 'Total';
   DINHEIRO = SOMA_DINHEIRO;
   CHEQUE = SOMA_CHEQUE;
   TOTAL_VENDAS = DINHEIRO + CHEQUE;
   suspend;
end
^


SET TERM ; ^
