
unit WebForm1;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  System.Drawing.Imaging;

type
  TWebForm1 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure Button23D_Click(sender: System.Object; e: System.EventArgs);
    procedure Button13D_Click(sender: System.Object; e: System.EventArgs);
    procedure Button33D_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    txb_Valor1: System.Web.UI.WebControls.TextBox;
    txb_Valor2: System.Web.UI.WebControls.TextBox;
    TextBox3: System.Web.UI.WebControls.TextBox;
    txb_Valor3: System.Web.UI.WebControls.TextBox;
    lbl_Valor1: System.Web.UI.WebControls.Label;
    lbl_Valor2: System.Web.UI.WebControls.Label;
    lbl_Valor3: System.Web.UI.WebControls.Label;
    Button13D: System.Web.UI.WebControls.Button;
    Button23D: System.Web.UI.WebControls.Button;
    Button33D: System.Web.UI.WebControls.Button;
    img_Grafico: System.Web.UI.WebControls.Image;
    procedure OnInit(e: EventArgs); override;
  private
    Procedure Barra3D(var x,y,z:Double);
    Procedure Pizza3D(var x,y,z:Double);
    Procedure Linha3D(var x,y,z:Double);
    Procedure DesenhaGrade;
  public
    Figura:Bitmap;
    Grafico:Graphics;
    Total,Maior,x,y,z : System.Double;
    Caneta : Pen;
    Branco, Azul, AzulEscuro, Vermelho, VermelhoEscuro, Verde,
    VerdeEscuro, Preto, Cinza, CinzaEscuro : Brush;
    Poligonos : array of PointF;
    Fonte: Font;
    NomeGrafico : String;
  end;

implementation

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>


procedure TWebForm1.InitializeComponent;
begin
  Include(Self.Button13D.Click, Self.Button13D_Click);
  Include(Self.Button23D.Click, Self.Button23D_Click);
  Include(Self.Button33D.Click, Self.Button33D_Click);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

procedure TWebForm1.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  // Instanciando as cores.
  Branco := Brushes.White;
  Azul := Brushes.Blue;
  AzulEscuro := Brushes.DarkBlue;
  Vermelho := Brushes.Red;
  VermelhoEscuro := Brushes.DarkRed;
  Verde := Brushes.Green;
  VerdeEscuro := Brushes.DarkGreen;
  Preto := Brushes.Black;
  Cinza := Brushes.LightBlue;
  CinzaEscuro := Brushes.Gray;

  // Instnciando a varivel do tipo Bitmap com 600px de Largura por 450px de Altura
  Figura:= Bitmap.Create(600,450);
  // Instnciando a varivel do tipo Graphic que vai receber a varivel Figura.
  Grafico:= Graphics.FromImage(Figura);
  // Preenchendo a rea criada no Bitmap com a cor branca.
  // Caso no seja feita a rea vem como default em preto.
  Grafico.FillRectangle(Branco,0,0,600,450);
  // Instnciando a varivel Caneta do tipo pen e atribuindo preto.
  Caneta:= Pen.Create(Color.Black);
  // Instnciando a varivel Fonte do tipo Font Tahoma, tamanho 10.
  Fonte:= Font.Create('Tahoma',10);
end;

procedure TWebForm1.Linha3D(var x, y, z: Double);
var Controle_Altura1,Controle_Altura2: Double;
begin
  DesenhaGrade;
  if (x>=y) and (x>=z) then
  begin
    // Calculando o ponto do valor Y.
    Controle_Altura1:= (300*y)/x;
    // Calculando o ponto do valor X.
    Controle_Altura2:= (300*z)/x;
    Poligonos[0].X := 150;
    Poligonos[0].y := 10;
    Poligonos[1].X := 120;
    Poligonos[1].y := 30;
    Poligonos[2].X := 200;
    Poligonos[2].y := 330 - Controle_Altura1;
    Poligonos[3].X := 230;
    Poligonos[3].y := 310 - Controle_Altura1;
    Grafico.FillPolygon(VermelhoEscuro,Poligonos);
    Grafico.DrawPolygon(Caneta,Poligonos);
    Poligonos[0].X := 230;
    Poligonos[0].y := 310 - Controle_Altura1;
    Poligonos[1].X := 200;
    Poligonos[1].y := 330 - Controle_Altura1;
    Poligonos[2].X := 280;
    Poligonos[2].y := 310 - Controle_Altura2 + 20;
    Poligonos[3].X := 310;
    Poligonos[3].y := 310 - Controle_Altura2;
    Grafico.FillPolygon(VermelhoEscuro,Poligonos);
    Grafico.DrawPolygon(Caneta,Poligonos);
  end;
  // 2
  if (y>x) and (y>z) then
  begin
    Controle_Altura1:= (300*x)/y;
    Controle_Altura2:= (300*z)/y;
    Poligonos[0].X := 150;
    Poligonos[0].y := 310 - Controle_Altura1;
    Poligonos[1].X := 120;
    Poligonos[1].y := 330 - Controle_Altura1;
    Poligonos[2].X := 200;
    Poligonos[2].y := 30;
    Poligonos[3].X := 230;
    Poligonos[3].y := 10;
    Grafico.FillPolygon(VermelhoEscuro,Poligonos);
    Grafico.DrawPolygon(Caneta,Poligonos);
    Poligonos[0].X := 230;
    Poligonos[0].y := 10;
    Poligonos[1].X := 200;
    Poligonos[1].y := 30;
    Poligonos[2].X := 280;
    Poligonos[2].y := 310 - Controle_Altura2 + 20;
    Poligonos[3].X := 310;
    Poligonos[3].y := 310 - Controle_Altura2;
    Grafico.FillPolygon(VermelhoEscuro,Poligonos);
    Grafico.DrawPolygon(Caneta,Poligonos);
  end;
  // 3
  if (z>x) and (z>y) then
  begin
    Controle_Altura1:= (300*x)/z;
    Controle_Altura2:= (300*y)/z;
    Poligonos[0].X := 150;
    Poligonos[0].y := 310 - Controle_Altura1;
    Poligonos[1].X := 120;
    Poligonos[1].y := 330 - Controle_Altura1;
    Poligonos[2].X := 200;
    Poligonos[2].y := 330 - Controle_Altura2 ;
    Poligonos[3].X := 230;
    Poligonos[3].y := 310 - Controle_Altura2;
    Grafico.FillPolygon(VermelhoEscuro,Poligonos);
    Grafico.DrawPolygon(Caneta,Poligonos);
    Poligonos[0].X := 280;
    Poligonos[0].y := 10;
    Poligonos[1].X := 250;
    Poligonos[1].y := 30;
    Poligonos[2].X := 200;
    Poligonos[2].y := 310 - Controle_Altura2 + 20;
    Poligonos[3].X := 230;
    Poligonos[3].y := 310 - Controle_Altura2;
    Grafico.FillPolygon(VermelhoEscuro,Poligonos);
    Grafico.DrawPolygon(Caneta,Poligonos);
  end;

  NomeGrafico:='Grafico3D_'+System.Datetime.Now.ToString('dd_MM_yyyy_hh_mm_ss') +'.bmp';
  Figura.Save (Server.MapPath('imagens\'+NomeGrafico),ImageFormat.Gif);
  img_Grafico.ImageUrl :='imagens\'+NomeGrafico;
  img_Grafico.Height := Figura.Height;
  img_Grafico.Width := Figura.Width;
end;

procedure TWebForm1.Button33D_Click(sender: System.Object; e: System.EventArgs);
begin
  x:= convert.ToDouble(Txb_Valor1.Text);
  y:= convert.ToDouble(Txb_Valor2.Text);
  z:= convert.ToDouble(Txb_Valor3.Text);
  Total:= convert.ToDouble(Txb_Valor1.Text) + convert.ToDouble(Txb_Valor2.Text) + convert.ToDouble(Txb_Valor3.Text);
  Linha3D(x,y,z);
end;

procedure TWebForm1.Barra3D(var x, y, z: Double);
var Controle_Altura,Inversao: Double;
begin
  DesenhaGrade;
  // Verificando o maior valor declarado nos TextBox para ser usado
  //como base de clculo no grfico.
  Maior:= x;
  if y > x then
    Maior:= y;
  if (z > y) and (z > x) then
    Maior:= z;
  // Caso o Valor do Txb_Valor1 seja maior, tomaremos o valor como 100%
  // e as demais barras sero calculadas em funo desse valor.
  SetLength(Poligonos,4);
  if (x>=y) and (x>=z) then
  begin
    Grafico.FillRectangle(Verde,120,30,45,300);
    Grafico.DrawRectangle(Caneta,120,30,45,300);
    // Inserindo os pontos (x,y) para desenhar a parte superior da barra.
    Poligonos[0].X := 150;
    Poligonos[0].y := 10;
    Poligonos[1].X := 120;
    Poligonos[1].y := 30;
    Poligonos[2].X := 165;
    Poligonos[2].y := 30;
    Poligonos[3].X := 195;
    Poligonos[3].y := 10;
    // Desenhando e contornando a parte superior da barra.
    Grafico.FillPolygon(VerdeEscuro,Poligonos);
    Grafico.DrawPolygon(Caneta,Poligonos);
    // Desenhando e contornando a lateral da barra.
    Poligonos[0].X := 195;
    Poligonos[0].y := 10;
    Poligonos[1].X := 165;
    Poligonos[1].y := 30;
    Poligonos[2].X := 165;
    Poligonos[2].y := 330;
    Poligonos[3].X := 195;
    Poligonos[3].y := 310;
    Grafico.FillPolygon(VerdeEscuro,Poligonos);
    Grafico.DrawPolygon(Caneta,Poligonos);
    // Controle_Altura guarda o valor de altura da barra.
    Controle_Altura:= (300*y)/x;
    // O eixo do plano cartesiano est no canto superior esquerdo
    // se utilizarmos valores reais para desenhar as barras
    // as mesmas ficariam de cabea para baixo.
    // Para corrigir esse problema fazemos uma lgica de inverso
    // onde tranferimos o eixo para o canto inferior esquerdo.
    // Para isso basta subtrair a altura da barra da altura do grfico.
    Inversao:= 330-Controle_Altura;
    Poligonos[0].X := 215;
    Poligonos[0].y := Inversao;
    Poligonos[1].X := 260;
    Poligonos[1].y := Inversao;
    Poligonos[2].X := 290;
    Poligonos[2].y := Inversao - 20;
    Poligonos[3].X := 245;
    Poligonos[3].y := Inversao - 20;
    Grafico.FillPolygon(VermelhoEscuro,Poligonos);
    Poligonos[0].X := 290;
    Poligonos[0].y := Inversao - 20;
    Poligonos[1].X := 260;
    Poligonos[1].y := Inversao;
    Poligonos[2].X := 260;
    Poligonos[2].y := 330;
    Poligonos[3].X := 290;
    Poligonos[3].y := 310;
    Grafico.FillPolygon(VermelhoEscuro,Poligonos);
    Grafico.DrawPolygon(Caneta,Poligonos);
    Grafico.FillRectangle(Vermelho,215,Inversao,45,Controle_Altura);
    Grafico.DrawRectangle(Caneta,215,Inversao,45,Controle_Altura);
    Controle_Altura:= (300*z)/x;
    Inversao:= 330-Controle_Altura;
    Poligonos[0].X := 310;
    Poligonos[0].y := Inversao;
    Poligonos[1].X := 355;
    Poligonos[1].y := Inversao;
    Poligonos[2].X := 385;
    Poligonos[2].y := Inversao - 20;
    Poligonos[3].X := 340;
    Poligonos[3].y := Inversao - 20;
    Grafico.FillPolygon(AzulEscuro,Poligonos);
    Poligonos[0].X := 385;
    Poligonos[0].y := Inversao - 20;
    Poligonos[1].X := 355;
    Poligonos[1].y := Inversao;
    Poligonos[2].X := 355;
    Poligonos[2].y := 330;
    Poligonos[3].X := 385;
    Poligonos[3].y := 310;
    Grafico.FillPolygon(AzulEscuro,Poligonos);
    Grafico.DrawPolygon(Caneta,Poligonos);
    Grafico.FillRectangle(Azul,310,Inversao,45,Controle_Altura);
    Grafico.DrawRectangle(Caneta,310,Inversao,45,Controle_Altura);
  end;
  // Caso o Valor do Txb_Valor2 seja maior, tomaremos o valor como 100%
  // e as demais barras sero calculadas em funo desse valor.
  if (y>=x) and (y>=z) then
  begin
    Poligonos[0].X := 215;
    Poligonos[0].y := 30;
    Poligonos[1].X := 260;
    Poligonos[1].y := 30;
    Poligonos[2].X := 290;
    Poligonos[2].y := 10;
    Poligonos[3].X := 245;
    Poligonos[3].y := 10;
    Grafico.FillPolygon(VermelhoEscuro,Poligonos);
    Poligonos[0].X := 290;
    Poligonos[0].y := 10;
    Poligonos[1].X := 260;
    Poligonos[1].y := 30;
    Poligonos[2].X := 260;
    Poligonos[2].y := 330;
    Poligonos[3].X := 290;
    Poligonos[3].y := 310;
    Grafico.FillPolygon(VermelhoEscuro,Poligonos);
    Grafico.DrawPolygon(Caneta,Poligonos);
    Grafico.FillRectangle(Vermelho,215,30,45,300);
    Grafico.DrawRectangle(Caneta,215,30,45,300);
    Controle_Altura:= (300*x)/y;
    Inversao:= 330-Controle_Altura;
    Poligonos[0].X := 120;
    Poligonos[0].y := Inversao;
    Poligonos[1].X := 165;
    Poligonos[1].y := Inversao;
    Poligonos[2].X := 195;
    Poligonos[2].y := Inversao - 20;
    Poligonos[3].X := 150;
    Poligonos[3].y := Inversao - 20;
    Grafico.FillPolygon(VerdeEscuro,Poligonos);
    Poligonos[0].X := 195;
    Poligonos[0].y := Inversao - 20;
    Poligonos[1].X := 165;
    Poligonos[1].y := Inversao;
    Poligonos[2].X := 165;
    Poligonos[2].y := 330;
    Poligonos[3].X := 195;
    Poligonos[3].y := 310;
    Grafico.FillPolygon(VerdeEscuro,Poligonos);
    Grafico.DrawPolygon(Caneta,Poligonos);
    Grafico.FillRectangle(Verde,120,Inversao,45,Controle_Altura);
    Grafico.DrawRectangle(Caneta,120,Inversao,45,Controle_Altura);
    Controle_Altura:= (300*z)/y;
    Inversao:= 330-Controle_Altura;
    Poligonos[0].X := 310;
    Poligonos[0].y := Inversao;
    Poligonos[1].X := 355;
    Poligonos[1].y := Inversao;
    Poligonos[2].X := 385;
    Poligonos[2].y := Inversao - 20;
    Poligonos[3].X := 340;
    Poligonos[3].y := Inversao - 20;
    Grafico.FillPolygon(AzulEscuro,Poligonos);
    Poligonos[0].X := 385;
    Poligonos[0].y := Inversao - 20;
    Poligonos[1].X := 355;
    Poligonos[1].y := Inversao;
    Poligonos[2].X := 355;
    Poligonos[2].y := 330;
    Poligonos[3].X := 385;
    Poligonos[3].y := 310;
    Grafico.FillPolygon(AzulEscuro,Poligonos);
    Grafico.DrawPolygon(Caneta,Poligonos);
    Grafico.FillRectangle(Azul,310,Inversao,45,Controle_Altura);
    Grafico.DrawRectangle(Caneta,310,Inversao,45,Controle_Altura);
  end;
  // Caso o Valor do Txb_Valor3 seja maior, tomaremos o valor como 100%
  // e as demais barras sero calculadas em funo desse valor.
  if (z>=y) and (z>=x) then
  begin
    Poligonos[0].X := 310;
    Poligonos[0].y := 30;
    Poligonos[1].X := 355;
    Poligonos[1].y := 30;
    Poligonos[2].X := 385;
    Poligonos[2].y := 10;
    Poligonos[3].X := 340;
    Poligonos[3].y := 10;
    Grafico.FillPolygon(AzulEscuro,Poligonos);
    Poligonos[0].X := 385;
    Poligonos[0].y := 10;
    Poligonos[1].X := 355;
    Poligonos[1].y := 30;
    Poligonos[2].X := 355;
    Poligonos[2].y := 330;
    Poligonos[3].X := 385;
    Poligonos[3].y := 310;
    Grafico.FillPolygon(AzulEscuro,Poligonos);
    Grafico.DrawPolygon(Caneta,Poligonos);
    Grafico.FillRectangle(Azul,310,30,45,300);
    Grafico.DrawRectangle(Caneta,310,30,45,300);
    Controle_Altura:= (300*y)/z;
    Inversao:= 330-Controle_Altura;
    Poligonos[0].X := 215;
    Poligonos[0].y := Inversao;
    Poligonos[1].X := 260;
    Poligonos[1].y := Inversao;
    Poligonos[2].X := 290;
    Poligonos[2].y := Inversao - 20;
    Poligonos[3].X := 245;
    Poligonos[3].y := Inversao - 20;
    Grafico.FillPolygon(VermelhoEscuro,Poligonos);
    Poligonos[0].X := 290;
    Poligonos[0].y := Inversao - 20;
    Poligonos[1].X := 260;
    Poligonos[1].y := Inversao;
    Poligonos[2].X := 260;
    Poligonos[2].y := 330;
    Poligonos[3].X := 290;
    Poligonos[3].y := 310;
    Grafico.FillPolygon(VermelhoEscuro,Poligonos);
    Grafico.DrawPolygon(Caneta,Poligonos);
    Grafico.FillRectangle(Vermelho,215,Inversao,45,Controle_Altura);
    Grafico.DrawRectangle(Caneta,215,Inversao,45,Controle_Altura);
    Controle_Altura:= (300*x)/z;
    Inversao:= 330-Controle_Altura;
    Poligonos[0].X := 120;
    Poligonos[0].y := Inversao;
    Poligonos[1].X := 165;
    Poligonos[1].y := Inversao;
    Poligonos[2].X := 195;
    Poligonos[2].y := Inversao - 20;
    Poligonos[3].X := 150;
    Poligonos[3].y := Inversao - 20;
    Grafico.FillPolygon(VerdeEscuro,Poligonos);
    Poligonos[0].X := 195;
    Poligonos[0].y := Inversao - 20;
    Poligonos[1].X := 165;
    Poligonos[1].y := Inversao;
    Poligonos[2].X := 165;
    Poligonos[2].y := 330;
    Poligonos[3].X := 195;
    Poligonos[3].y := 310;
    Grafico.FillPolygon(VerdeEscuro,Poligonos);
    Grafico.DrawPolygon(Caneta,Poligonos);
    Grafico.FillRectangle(Verde,120,Inversao,45,Controle_Altura);
    Grafico.DrawRectangle(Caneta,120,Inversao,45,Controle_Altura);
  end;
  // Escrevendo os valores digitados abaixo das respectivas barras.
  Grafico.DrawString(x.ToString,Fonte,Preto,140,330);
  Grafico.DrawString(y.ToString,Fonte,Preto,235,330);
  Grafico.DrawString(z.ToString,Fonte,Preto,330,330);
  //
  NomeGrafico:='Grafico3D_'+System.Datetime.Now.ToString('dd_MM_yyyy_hh_mm_ss') +'.bmp';
  Figura.Save(Server.MapPath('imagens\'+NomeGrafico),ImageFormat.Gif);
  img_Grafico.ImageUrl :='imagens\'+NomeGrafico;
  img_Grafico.Height := Figura.Height;
  img_Grafico.Width := Figura.Width;
end;

procedure TWebForm1.Button13D_Click(sender: System.Object; e: System.EventArgs);
begin
  x:= convert.ToDouble(Txb_Valor1.Text);
  y:= convert.ToDouble(Txb_Valor2.Text);
  z:= convert.ToDouble(Txb_Valor3.Text);
  Total:= x + y + z;
  Barra3D(x,y,z);
end;

procedure TWebForm1.Button23D_Click(sender: System.Object; e: System.EventArgs);
begin
  x:= convert.ToDouble(Txb_Valor1.Text);
  y:= convert.ToDouble(Txb_Valor2.Text);
  z:= convert.ToDouble(Txb_Valor3.Text);
  Total:= x + y + z;
  Pizza3D(x,y,z);
end;

procedure TWebForm1.DesenhaGrade;
begin
  // Fundo Caixa
  Grafico.FillRectangle(Cinza,100,10,350,300);
  Grafico.DrawRectangle(Caneta,100,10,350,300);
  SetLength(Poligonos,4);
  // Graduao Lateral
  Poligonos[0].X := 100;
  Poligonos[0].y := 10;
  Poligonos[1].X := 70;
  Poligonos[1].y := 30;
  Poligonos[2].X := 70;
  Poligonos[2].y := 330;
  Poligonos[3].X := 100;
  Poligonos[3].y := 310;
  Grafico.FillPolygon(Cinza,Poligonos);
  Grafico.DrawPolygon(Caneta,Poligonos);
  // P Caixa
  Poligonos[0].X := 100;
  Poligonos[0].y := 310;
  Poligonos[1].X := 70;
  Poligonos[1].y := 330;
  Poligonos[2].X := 420;
  Poligonos[2].y := 330;
  Poligonos[3].X := 450;
  Poligonos[3].y := 310;
  Grafico.FillPolygon(CinzaEscuro,Poligonos);
  Grafico.DrawPolygon(Caneta,Poligonos);
  // Montando a grade de percentuais.
  Grafico.DrawString('100%',Fonte,Preto,30,20);
  Grafico.DrawLine(Caneta,100,40,450,40);
  Grafico.DrawLine(Caneta,100,40,70,60);
  Grafico.DrawString('90%',Fonte,Preto,30,50);
  Grafico.DrawLine(Caneta,100,70,450,70);
  Grafico.DrawLine(Caneta,100,70,70,90);
  Grafico.DrawString('80%',Fonte,Preto,30,80);
  Grafico.DrawLine(Caneta,100,100,450,100);
  Grafico.DrawLine(Caneta,100,100,70,120);
  Grafico.DrawString('70%',Fonte,Preto,30,110);
  Grafico.DrawLine(Caneta,100,130,450,130);
  Grafico.DrawLine(Caneta,100,130,70,150);
  Grafico.DrawString('60%',Fonte,Preto,30,140);
  Grafico.DrawLine(Caneta,100,160,450,160);
  Grafico.DrawLine(Caneta,100,160,70,180);
  Grafico.DrawString('50%',Fonte,Preto,30,170);
  Grafico.DrawLine(Caneta,100,190,450,190);
  Grafico.DrawLine(Caneta,100,190,70,210);
  Grafico.DrawString('40%',Fonte,Preto,30,200);
  Grafico.DrawLine(Caneta,100,220,450,220);
  Grafico.DrawLine(Caneta,100,220,70,240);
  Grafico.DrawString('30%',Fonte,Preto,30,230);
  Grafico.DrawLine(Caneta,100,250,450,250);
  Grafico.DrawLine(Caneta,100,250,70,270);
  Grafico.DrawString('20%',Fonte,Preto,30,260);
  Grafico.DrawLine(Caneta,100,280,450,280);
  Grafico.DrawLine(Caneta,100,280,70,300);
  Grafico.DrawString('10%',Fonte,Preto,30,290);

end;

procedure TWebForm1.Pizza3D(var x, y, z: Double);
Var Percentual1, Percentual2, Percentual3: Double;
    Controle : Integer;
begin
  // Varivel para controlar a altura da pizza
  Controle := 30;
  while Controle > 10 do
  begin
    // Pintando a respectiva porcentagem do valor 1 na pizza
    Percentual1:= (360*(convert.ToDouble(x.ToString)))/Total;
    Grafico.FillPie(VerdeEscuro,10,Controle,201,100,0,Percentual1);
    // Pintando a respectiva porcentagem do valor 2 na pizza
    Percentual2:= (360*(convert.ToDouble(y.ToString)))/Total;
    Grafico.FillPie(VermelhoEscuro,10,Controle,201,100,Percentual1,Percentual2);
    // Pintando a respectiva porcentagem do valor 3 na pizza
    Percentual3:=(360*(convert.ToDouble(z.ToString)))/Total;
    Grafico.FillPie(AzulEscuro,10,Controle,201,100,Percentual1+Percentual2,Percentual3);
    Dec(Controle,1);
  end;
  // Pintando a respectiva porcentagem do valor 1 na pizza
  Percentual1:= (360*(convert.ToDouble(x.ToString)))/Total;
  Grafico.FillPie(Verde,10,10,200,100,0,Percentual1);
  Grafico.DrawPie(Caneta,10,10,200,100,0,Percentual1);
  // Pintando a respectiva porcentagem do valor 2 na pizza
  Percentual2:= (360*(convert.ToDouble(y.ToString)))/Total;
  Grafico.FillPie(Vermelho,10,10,200,100,Percentual1,Percentual2);
  Grafico.DrawPie(Caneta,10,10,200,100,Percentual1,Percentual2);
  // Pintando a respectiva porcentagem do valor 3 na pizza
  Percentual3:=(360*(convert.ToDouble(z.ToString)))/Total;
  Grafico.FillPie(Azul,10,10,200,100,Percentual1+Percentual2,Percentual3);
  Grafico.DrawPie(Caneta,10,10,200,100,Percentual1+Percentual2,Percentual3);

  NomeGrafico:='Grafico3D_'+System.Datetime.Now.ToString('dd_MM_yyyy_hh_mm_ss') +'.bmp';
  Figura.Save (Server.MapPath('imagens\'+NomeGrafico),ImageFormat.Gif);
  img_Grafico.ImageUrl :='imagens\'+NomeGrafico;
  img_Grafico.Height := Figura.Height;
  img_Grafico.Width := Figura.Width;
end;

procedure TWebForm1.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

end.

