unit CMD_Providers;

interface

uses
  SysUtils, Classes, DBXpress, DB, SqlExpr, FMTBcd, DBClient, Provider, Variants;

type
  TdtmProviders = class(TDataModule)
    conFirebird: TSQLConnection;
    qryContatos: TSQLQuery;
    dspContatos: TDataSetProvider;
    cdsContatos: TClientDataSet;
    qryContatosIDT_CONTATO: TIntegerField;
    qryContatosNOM_CONTATO: TStringField;
    qryContatosIDT_CLASSIFICACAO: TIntegerField;
    qryContatosIDT_TIPO_LOGRADOURO: TIntegerField;
    qryContatosEND_CONTATO: TStringField;
    qryContatosNUM_END_CONTATO: TStringField;
    qryContatosCPL_END_CONTATO: TStringField;
    qryContatosBAI_CONTATO: TStringField;
    qryContatosCID_CONTATO: TStringField;
    qryAtualizaCPF: TSQLQuery;
    dspItensNotaFiscal: TDataSetProvider;
    qryValorNotaFiscal: TSQLQuery;
    procedure dspContatosBeforeUpdateRecord(Sender: TObject;
      SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
      UpdateKind: TUpdateKind; var Applied: Boolean);
    procedure dspContatosUpdateData(Sender: TObject;
      DataSet: TCustomClientDataSet);
    procedure dspItensNotaFiscalUpdateError(Sender: TObject;
      DataSet: TCustomClientDataSet; E: EUpdateError;
      UpdateKind: TUpdateKind; var Response: TResolverResponse);
    procedure dspContatosUpdateError(Sender: TObject;
      DataSet: TCustomClientDataSet; E: EUpdateError;
      UpdateKind: TUpdateKind; var Response: TResolverResponse);
  private
    { Private declarations }

  public
    { Public declarations }
  end;

var
  dtmProviders: TdtmProviders;

implementation

{$R *.dfm}

procedure TdtmProviders.dspContatosBeforeUpdateRecord(Sender: TObject;
  SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
  UpdateKind: TUpdateKind; var Applied: Boolean);
begin
  if not VarIsEmpty(DeltaDS.FieldByName('IDT_CLASSIFICACAO').NewValue) then
    if (DeltaDS.FieldByName('IDT_CLASSIFICACAO').NewValue <> 'C') and
       (DeltaDS.FieldByName('IDT_CLASSIFICACAO').NewValue <> 'E') and
       (DeltaDS.FieldByName('IDT_CLASSIFICACAO').NewValue <> 'P') then
    begin
      raise Exception.Create('O valor de classificao do contato deve ser C, E ou P');
    end;

  case UpdateKind of
  ukInsert: DeltaDS.FieldByName('DATA_INCLUSAO').NewValue := Date;
  ukModify:
    begin
      DeltaDS.FieldByName('DATA_ALTERACAO').NewValue := Date;
      if not VarIsNull(DeltaDS.FieldByName('CPF').NewValue) then
      begin
        with qryAtualizaCPF do
        begin
          ParamByName('idt_contato').AsInteger := DeltaDS.FieldByName('CPF').NewValue;
          Prepared := True;
          ExecSQL;
          Applied := True;
        end;
      end;
    end;
  end;
end;

procedure TdtmProviders.dspContatosUpdateData(Sender: TObject;
  DataSet: TCustomClientDataSet);
var
  DataInclusao: TDateTime;
begin
  with DataSet do
  begin
    while not EOF do
    begin
      case UpdateStatus of
      usUnmodified:
        begin
          DataInclusao := FieldByName('DATA_INCLUSAO').AsDateTime;
          Next;
          if (FieldByName('DATA_ALTERACAO').AsDateTime < DataInclusao) then
          begin
            raise Exception.Create('Data de alterao menor que a data de incluso!');
          end;
        end;
      end;
      Next;
    end;
  end;
end;

procedure TdtmProviders.dspItensNotaFiscalUpdateError(Sender: TObject;
  DataSet: TCustomClientDataSet; E: EUpdateError; UpdateKind: TUpdateKind;
  var Response: TResolverResponse);
var
  ValorOriginal, ValorModificado, ValorItem: Currency;
begin
  ValorModificado := 0; ValorItem := 0;
  if qryValorNotaFiscal.State in [dsBrowse] then
    qryValorNotaFiscal.Close;
  qryValorNotaFiscal.ParamByName('NUM_NOTA_FISCAL').asInteger :=
    qryValorNotaFiscal.FieldByName('NUM_NOTA_FISCAL').asInteger;
  qryValorNotaFiscal.Open;
  ValorOriginal := qryValorNotaFiscal.FieldByName('VALOR_TOTAL').AsCurrency;
  with DataSet do
  begin
    while not EOF do
    begin
      case UpdateStatus of
      usUnmodified:
        begin
          ValorItem := FieldByName('VALOR_TOTAL_ITEM').asCurrency;
          Next;
          if not VarIsEmpty(FieldByName('VALOR_TOTAL_ITEM').AsCurrency) then
          begin
            ValorItem := FieldByName('VALOR_TOTAL_ITEM').asCurrency;
          end;
        end;
      usInserted:
        ValorItem := FieldByName('VALOR_TOTAL_ITEM').asCurrency;
      end;
      ValorModificado := ValorModificado + ValorItem;
      Next;
    end;

    if (ValorOriginal <> ValorModificado) then
      raise Exception.Create('Valor total da nota difere do valor total dos itens.');
  end;
end;

procedure TdtmProviders.dspContatosUpdateError(Sender: TObject;
  DataSet: TCustomClientDataSet; E: EUpdateError; UpdateKind: TUpdateKind;
  var Response: TResolverResponse);
begin
  if E.OriginalException is EDatabaseError then
  begin
    if Pos('INTEG_65', E.OriginalException.Message) <> 0 then
    begin
      E.Message := ('O valor do logradouro deve ser informado.' + #13 +
        'Atualizao ser abandonada.');
      Response := rrSkip;
    end;
  end;
end;

end.
