unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TDynStringArray = array of string;

  TForm1 = class(TForm)
    btImplode: TButton;
    btExplode: TButton;
    Label1: TLabel;
    Label2: TLabel;
    edtString: TEdit;
    edtSeparador: TEdit;
    btMostrarVetor: TButton;
    Label3: TLabel;
    procedure btExplodeClick(Sender: TObject);
    procedure btImplodeClick(Sender: TObject);
    procedure btMostrarVetorClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function Implode(const glue: string; const pieces: array of string): string;
    function Explode(const Separator, S: String; Limit: Integer = 0): TDynStringArray;
  end;

var
  Form1: TForm1;
  Items: TDynStringArray;

implementation

{$R *.dfm}

{ TForm1 }

function TForm1.Explode(const Separator, S: String;
  Limit: Integer): TDynStringArray;
var
  SepLen: Integer;
  F, P: PChar;
begin
  SetLength(Result, 0);
  if (S = '') or (Limit < 0) then Exit;
  if Separator = '' then
    begin
      SetLength(Result, 1);
      Result[0] := S;
      Exit;
    end;
  SepLen := Length(Separator);

  P := PChar(S);
  while P^ <> #0 do
    begin
      F := P;
      P := AnsiStrPos(P, PChar(Separator));
      if (P = nil) or ((Limit > 0) and
         (Length(Result) = Limit - 1)) then
        P := StrEnd(F);
      SetLength(Result, Length(Result) + 1);
      SetString(Result[High(Result)], F, P - F);
      F := P;
      if P = Separator then
        SetLength(Result, Length(Result) + 1);
      while (P^ <> #0) and (P - F < SepLen) do Inc(P);
    end;
end;

function TForm1.Implode(const glue: string;
  const pieces: array of string): string;
var
  I: Integer;
begin
  Result := '';
  for I := 0 to High(Pieces) do
    Result := Result + Glue + Pieces[I];
  Delete(Result, 1, Length(Glue));
end;

procedure TForm1.btExplodeClick(Sender: TObject);
begin
  Items := Explode(edtSeparador.Text, edtString.Text);
  btMostrarVetor.Click;
end;

procedure TForm1.btImplodeClick(Sender: TObject);
var
  str: string;
begin
  str := Implode(edtSeparador.Text, Items);
  ShowMessage(str);
end;

procedure TForm1.btMostrarVetorClick(Sender: TObject);
var
  i: integer;
begin
  for i:=Low(Items) to High(Items) do
    ShowMessage(Items[i]);
end;

end.
