unit UCadUsuarios;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.Resources, Borland.Data.Common, 
  System.Data.Common, Borland.Data.Provider, System.Globalization;

type
  TState = (dsBrowser, dsEdit, dsInsert);

  TfrmCadUsuarios = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    cm: CurrencyManager;
    components: System.ComponentModel.IContainer;
    pnlSuperior: System.Windows.Forms.Panel;
    PictureBox: System.Windows.Forms.PictureBox;
    lblUser: System.Windows.Forms.Label;
    ImageList: System.Windows.Forms.ImageList;
    ToolBarBot: System.Windows.Forms.ToolBar;
    tbAdd: System.Windows.Forms.ToolBarButton;
    tbEdit: System.Windows.Forms.ToolBarButton;
    tbDelete: System.Windows.Forms.ToolBarButton;
    tbSeparator1: System.Windows.Forms.ToolBarButton;
    tbPost: System.Windows.Forms.ToolBarButton;
    tbCancel: System.Windows.Forms.ToolBarButton;
    tbSeparator2: System.Windows.Forms.ToolBarButton;
    tbRefresh: System.Windows.Forms.ToolBarButton;
    tbSeparator3: System.Windows.Forms.ToolBarButton;
    tbFirst: System.Windows.Forms.ToolBarButton;
    tbPrior: System.Windows.Forms.ToolBarButton;
    tbNext: System.Windows.Forms.ToolBarButton;
    tbLast: System.Windows.Forms.ToolBarButton;
    tbSeparator4: System.Windows.Forms.ToolBarButton;
    tbClose: System.Windows.Forms.ToolBarButton;
    DataGrid1: System.Windows.Forms.DataGrid;
    txtNome: System.Windows.Forms.TextBox;
    txtLogin: System.Windows.Forms.TextBox;
    txtSenha: System.Windows.Forms.TextBox;
    txtDataCad: System.Windows.Forms.TextBox;
    lblLogin: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    lblNome: System.Windows.Forms.Label;
    lblDataCad: System.Windows.Forms.Label;
    BdpConn: Borland.Data.Provider.BdpConnection;
    daUsuarios: Borland.Data.Provider.BdpDataAdapter;
    bdpSelectCommand1: Borland.Data.Provider.BdpCommand;
    bdpInsertCommand1: Borland.Data.Provider.BdpCommand;
    bdpUpdateCommand1: Borland.Data.Provider.BdpCommand;
    bdpDeleteCommand1: Borland.Data.Provider.BdpCommand;
    dsUsuarios: System.Data.DataSet;
    DataTable1: System.Data.DataTable;
    datNome: System.Data.DataColumn;
    DataColumn2: System.Data.DataColumn;
    DataColumn3: System.Data.DataColumn;
    DataColumn4: System.Data.DataColumn;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure ToolBarBot_ButtonClick(sender: System.Object; e: System.Windows.Forms.ToolBarButtonClickEventArgs);
    procedure TfrmCadUsuarios_Load(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict
  private
    FState: TState;
  protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
    procedure HabilitaBotoes;
    procedure Atualizarbanco;
    procedure set_State(const Value: TState);
    property State: TState read FState write set_State;
  private
  published
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TfrmCadUsuarios))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TfrmCadUsuarios.InitializeComponent;
type
  TArrayOfSystem_Windows_Forms_ToolBarButton = array of System.Windows.Forms.ToolBarButton;
  TArrayOfSystem_Data_DataTable = array of System.Data.DataTable;
  TArrayOfSystem_Data_DataColumn = array of System.Data.DataColumn;
  TArrayOfSystem_Data_Constraint = array of System.Data.Constraint;
  TArrayOfString = array of string;
  TArrayOfSystem_Data_Common_DataTableMapping = array of System.Data.Common.DataTableMapping;
  TArrayOfSystem_Data_Common_DataColumnMapping = array of System.Data.Common.DataColumnMapping;
begin
  Self.components := System.ComponentModel.Container.Create;
  Self.pnlSuperior := System.Windows.Forms.Panel.Create;
  Self.lblUser := System.Windows.Forms.Label.Create;
  Self.PictureBox := System.Windows.Forms.PictureBox.Create;
  Self.ImageList := System.Windows.Forms.ImageList.Create(Self.components);
  Self.ToolBarBot := System.Windows.Forms.ToolBar.Create;
  Self.tbAdd := System.Windows.Forms.ToolBarButton.Create;
  Self.tbEdit := System.Windows.Forms.ToolBarButton.Create;
  Self.tbDelete := System.Windows.Forms.ToolBarButton.Create;
  Self.tbSeparator1 := System.Windows.Forms.ToolBarButton.Create;
  Self.tbPost := System.Windows.Forms.ToolBarButton.Create;
  Self.tbCancel := System.Windows.Forms.ToolBarButton.Create;
  Self.tbSeparator2 := System.Windows.Forms.ToolBarButton.Create;
  Self.tbRefresh := System.Windows.Forms.ToolBarButton.Create;
  Self.tbSeparator3 := System.Windows.Forms.ToolBarButton.Create;
  Self.tbFirst := System.Windows.Forms.ToolBarButton.Create;
  Self.tbPrior := System.Windows.Forms.ToolBarButton.Create;
  Self.tbNext := System.Windows.Forms.ToolBarButton.Create;
  Self.tbLast := System.Windows.Forms.ToolBarButton.Create;
  Self.tbSeparator4 := System.Windows.Forms.ToolBarButton.Create;
  Self.tbClose := System.Windows.Forms.ToolBarButton.Create;
  Self.dsUsuarios := System.Data.DataSet.Create;
  Self.DataTable1 := System.Data.DataTable.Create;
  Self.datNome := System.Data.DataColumn.Create;
  Self.DataColumn2 := System.Data.DataColumn.Create;
  Self.DataColumn3 := System.Data.DataColumn.Create;
  Self.DataColumn4 := System.Data.DataColumn.Create;
  Self.txtNome := System.Windows.Forms.TextBox.Create;
  Self.txtLogin := System.Windows.Forms.TextBox.Create;
  Self.txtSenha := System.Windows.Forms.TextBox.Create;
  Self.txtDataCad := System.Windows.Forms.TextBox.Create;
  Self.lblLogin := System.Windows.Forms.Label.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.lblNome := System.Windows.Forms.Label.Create;
  Self.lblDataCad := System.Windows.Forms.Label.Create;
  Self.BdpConn := Borland.Data.Provider.BdpConnection.Create;
  Self.daUsuarios := Borland.Data.Provider.BdpDataAdapter.Create;
  Self.bdpDeleteCommand1 := Borland.Data.Provider.BdpCommand.Create;
  Self.bdpInsertCommand1 := Borland.Data.Provider.BdpCommand.Create;
  Self.bdpSelectCommand1 := Borland.Data.Provider.BdpCommand.Create;
  Self.bdpUpdateCommand1 := Borland.Data.Provider.BdpCommand.Create;
  Self.DataGrid1 := System.Windows.Forms.DataGrid.Create;
  Self.pnlSuperior.SuspendLayout;
  (System.ComponentModel.ISupportInitialize(Self.dsUsuarios)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.DataTable1)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.daUsuarios)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.DataGrid1)).BeginInit;
  Self.SuspendLayout;
  // 
  // pnlSuperior
  // 
  Self.pnlSuperior.BackColor := System.Drawing.SystemColors.InactiveCaptionText;
  Self.pnlSuperior.Controls.Add(Self.lblUser);
  Self.pnlSuperior.Controls.Add(Self.PictureBox);
  Self.pnlSuperior.Dock := System.Windows.Forms.DockStyle.Top;
  Self.pnlSuperior.Location := System.Drawing.Point.Create(0, 0);
  Self.pnlSuperior.Name := 'pnlSuperior';
  Self.pnlSuperior.Size := System.Drawing.Size.Create(688, 56);
  Self.pnlSuperior.TabIndex := 0;
  // 
  // lblUser
  // 
  Self.lblUser.Font := System.Drawing.Font.Create('Microsoft Sans Serif', 14, 
      System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, (Byte(0)));
  Self.lblUser.ForeColor := System.Drawing.SystemColors.HotTrack;
  Self.lblUser.Location := System.Drawing.Point.Create(80, 16);
  Self.lblUser.Name := 'lblUser';
  Self.lblUser.Size := System.Drawing.Size.Create(264, 32);
  Self.lblUser.TabIndex := 1;
  Self.lblUser.Text := 'Usurios do Sistema';
  // 
  // PictureBox
  // 
  Self.PictureBox.Location := System.Drawing.Point.Create(18, 10);
  Self.PictureBox.Name := 'PictureBox';
  Self.PictureBox.Size := System.Drawing.Size.Create(40, 36);
  Self.PictureBox.SizeMode := System.Windows.Forms.PictureBoxSizeMode.StretchImage;
  Self.PictureBox.TabIndex := 0;
  Self.PictureBox.TabStop := False;
  // 
  // ImageList
  // 
  Self.ImageList.ImageSize := System.Drawing.Size.Create(16, 16);
  Self.ImageList.TransparentColor := System.Drawing.Color.Transparent;
  // 
  // ToolBarBot
  // 
  Self.ToolBarBot.Appearance := System.Windows.Forms.ToolBarAppearance.Flat;
  Self.ToolBarBot.Buttons.AddRange(TArrayOfSystem_Windows_Forms_ToolBarButton.Create(Self.tbAdd, 
          Self.tbEdit, Self.tbDelete, Self.tbSeparator1, Self.tbPost, Self.tbCancel, 
          Self.tbSeparator2, Self.tbRefresh, Self.tbSeparator3, Self.tbFirst, 
          Self.tbPrior, Self.tbNext, Self.tbLast, Self.tbSeparator4, Self.tbClose));
  Self.ToolBarBot.Divider := False;
  Self.ToolBarBot.Dock := System.Windows.Forms.DockStyle.Bottom;
  Self.ToolBarBot.DropDownArrows := True;
  Self.ToolBarBot.ImageList := Self.ImageList;
  Self.ToolBarBot.Location := System.Drawing.Point.Create(0, 382);
  Self.ToolBarBot.Name := 'ToolBarBot';
  Self.ToolBarBot.ShowToolTips := True;
  Self.ToolBarBot.Size := System.Drawing.Size.Create(688, 40);
  Self.ToolBarBot.TabIndex := 1;
  Include(Self.ToolBarBot.ButtonClick, Self.ToolBarBot_ButtonClick);
  // 
  // tbAdd
  // 
  Self.tbAdd.ImageIndex := 0;
  Self.tbAdd.Text := 'Insert';
  // 
  // tbEdit
  // 
  Self.tbEdit.ImageIndex := 1;
  Self.tbEdit.Text := 'Edit';
  // 
  // tbDelete
  // 
  Self.tbDelete.ImageIndex := 2;
  Self.tbDelete.Text := 'Delete';
  // 
  // tbSeparator1
  // 
  Self.tbSeparator1.Style := System.Windows.Forms.ToolBarButtonStyle.Separator;
  // 
  // tbPost
  // 
  Self.tbPost.ImageIndex := 3;
  Self.tbPost.Text := 'Post';
  // 
  // tbCancel
  // 
  Self.tbCancel.ImageIndex := 4;
  Self.tbCancel.Text := 'Cancel';
  // 
  // tbSeparator2
  // 
  Self.tbSeparator2.Style := System.Windows.Forms.ToolBarButtonStyle.Separator;
  // 
  // tbRefresh
  // 
  Self.tbRefresh.ImageIndex := 5;
  Self.tbRefresh.Text := 'Refresh';
  // 
  // tbSeparator3
  // 
  Self.tbSeparator3.Style := System.Windows.Forms.ToolBarButtonStyle.Separator;
  // 
  // tbFirst
  // 
  Self.tbFirst.ImageIndex := 7;
  Self.tbFirst.Text := 'First';
  // 
  // tbPrior
  // 
  Self.tbPrior.ImageIndex := 6;
  Self.tbPrior.Text := 'Prior';
  // 
  // tbNext
  // 
  Self.tbNext.ImageIndex := 9;
  Self.tbNext.Text := 'Next';
  // 
  // tbLast
  // 
  Self.tbLast.ImageIndex := 8;
  Self.tbLast.Text := 'Last';
  // 
  // tbSeparator4
  // 
  Self.tbSeparator4.Style := System.Windows.Forms.ToolBarButtonStyle.Separator;
  // 
  // tbClose
  // 
  Self.tbClose.ImageIndex := 10;
  Self.tbClose.Text := 'Close';
  // 
  // dsUsuarios
  // 
  Self.dsUsuarios.DataSetName := 'NewDataSet';
  Self.dsUsuarios.Locale := System.Globalization.CultureInfo.Create('pt-BR');
  Self.dsUsuarios.Tables.AddRange(TArrayOfSystem_Data_DataTable.Create(Self.DataTable1));
  // 
  // DataTable1
  // 
  Self.DataTable1.Columns.AddRange(TArrayOfSystem_Data_DataColumn.Create(Self.datNome, 
          Self.DataColumn2, Self.DataColumn3, Self.DataColumn4));
  Self.DataTable1.Constraints.AddRange(TArrayOfSystem_Data_Constraint.Create(System.Data.UniqueConstraint.Create('C' +
          'onstraint1', TArrayOfString.Create('LOGIN_USUARIO'), True)));
  Self.DataTable1.PrimaryKey := TArrayOfSystem_Data_DataColumn.Create(Self.DataColumn2);
  Self.DataTable1.TableName := 'USUARIOS';
  // 
  // datNome
  // 
  Self.datNome.Caption := 'Usurio';
  Self.datNome.ColumnName := 'NOME_USUARIO';
  Self.datNome.MaxLength := 31;
  // 
  // DataColumn2
  // 
  Self.DataColumn2.AllowDBNull := False;
  Self.DataColumn2.Caption := 'Login';
  Self.DataColumn2.ColumnName := 'LOGIN_USUARIO';
  Self.DataColumn2.MaxLength := 16;
  // 
  // DataColumn3
  // 
  Self.DataColumn3.AllowDBNull := False;
  Self.DataColumn3.Caption := 'Senha';
  Self.DataColumn3.ColumnName := 'SENHA_USUARIO';
  Self.DataColumn3.MaxLength := 9;
  // 
  // DataColumn4
  // 
  Self.DataColumn4.Caption := 'Data Cadastro';
  Self.DataColumn4.ColumnName := 'DATA_CADASTRO_USUARIO';
  Self.DataColumn4.DataType := TypeOf(System.DateTime);
  // 
  // txtNome
  // 
  Self.txtNome.DataBindings.Add(System.Windows.Forms.Binding.Create('Text', Self.dsUsuarios, 
        'USUARIOS.NOME_USUARIO'));
  Self.txtNome.Location := System.Drawing.Point.Create(24, 87);
  Self.txtNome.Name := 'txtNome';
  Self.txtNome.Size := System.Drawing.Size.Create(432, 20);
  Self.txtNome.TabIndex := 3;
  Self.txtNome.Text := 'TextBox1';
  // 
  // txtLogin
  // 
  Self.txtLogin.CharacterCasing := System.Windows.Forms.CharacterCasing.Upper;
  Self.txtLogin.DataBindings.Add(System.Windows.Forms.Binding.Create('Text', 
        Self.dsUsuarios, 'USUARIOS.LOGIN_USUARIO'));
  Self.txtLogin.Location := System.Drawing.Point.Create(24, 136);
  Self.txtLogin.Name := 'txtLogin';
  Self.txtLogin.Size := System.Drawing.Size.Create(128, 20);
  Self.txtLogin.TabIndex := 4;
  Self.txtLogin.Text := 'TEXTBOX2';
  // 
  // txtSenha
  // 
  Self.txtSenha.CharacterCasing := System.Windows.Forms.CharacterCasing.Lower;
  Self.txtSenha.DataBindings.Add(System.Windows.Forms.Binding.Create('Text', 
        Self.dsUsuarios, 'USUARIOS.SENHA_USUARIO'));
  Self.txtSenha.Location := System.Drawing.Point.Create(160, 136);
  Self.txtSenha.Name := 'txtSenha';
  Self.txtSenha.Size := System.Drawing.Size.Create(112, 20);
  Self.txtSenha.TabIndex := 5;
  Self.txtSenha.Text := 'textbox3';
  // 
  // txtDataCad
  // 
  Self.txtDataCad.DataBindings.Add(System.Windows.Forms.Binding.Create('Text', 
        Self.dsUsuarios, 'USUARIOS.DATA_CADASTRO_USUARIO'));
  Self.txtDataCad.Location := System.Drawing.Point.Create(472, 87);
  Self.txtDataCad.Name := 'txtDataCad';
  Self.txtDataCad.Size := System.Drawing.Size.Create(112, 20);
  Self.txtDataCad.TabIndex := 6;
  Self.txtDataCad.Text := 'TextBox4';
  // 
  // lblLogin
  // 
  Self.lblLogin.Location := System.Drawing.Point.Create(24, 120);
  Self.lblLogin.Name := 'lblLogin';
  Self.lblLogin.Size := System.Drawing.Size.Create(100, 16);
  Self.lblLogin.TabIndex := 7;
  Self.lblLogin.Text := 'Login';
  // 
  // Label2
  // 
  Self.Label2.Location := System.Drawing.Point.Create(160, 120);
  Self.Label2.Name := 'Label2';
  Self.Label2.Size := System.Drawing.Size.Create(100, 16);
  Self.Label2.TabIndex := 8;
  Self.Label2.Text := 'Senha';
  // 
  // lblNome
  // 
  Self.lblNome.Location := System.Drawing.Point.Create(24, 71);
  Self.lblNome.Name := 'lblNome';
  Self.lblNome.Size := System.Drawing.Size.Create(112, 16);
  Self.lblNome.TabIndex := 9;
  Self.lblNome.Text := 'Nome Completo';
  // 
  // lblDataCad
  // 
  Self.lblDataCad.Location := System.Drawing.Point.Create(472, 71);
  Self.lblDataCad.Name := 'lblDataCad';
  Self.lblDataCad.Size := System.Drawing.Size.Create(100, 16);
  Self.lblDataCad.TabIndex := 10;
  Self.lblDataCad.Text := 'Data Cadastro';
  // 
  // BdpConn
  // 
  Self.BdpConn.ConnectionOptions := 'waitonlocks=False;commitretain=False;sq' +
  'ldialect=3;transaction isolation=ReadCommitted;servercharset=;rolename=';
  Self.BdpConn.ConnectionString := 'assembly=Borland.Data.Interbase, Version' +
  '=2.5.0.0, Culture=neutral, PublicKeyToken=91d62ebb5b0d1b1b;vendorclient=g' +
  'ds32.dll;pooling=True;grow on demand=True;database=C:\Cursos\Artigos_Borl' +
  'and\ArtigoBDP\ARTIGO.GDB;username=sysdba;max pool size=100;password=maste' +
  'rkey;provider=Interbase;min pool size=0';
  // 
  // daUsuarios
  // 
  Self.daUsuarios.Active := True;
  Self.daUsuarios.DataSet := Self.dsUsuarios;
  Self.daUsuarios.DataTable := Self.DataTable1;
  Self.daUsuarios.DeleteCommand := Self.bdpDeleteCommand1;
  Self.daUsuarios.InsertCommand := Self.bdpInsertCommand1;
  Self.daUsuarios.SelectCommand := Self.bdpSelectCommand1;
  Self.daUsuarios.StartRecord := 0;
  Self.daUsuarios.TableMappings.AddRange(TArrayOfSystem_Data_Common_DataTableMapping.Create(System.Data.Common.DataTableMapping.Create('T' +
          'able', 'USUARIOS', TArrayOfSystem_Data_Common_DataColumnMapping.Create(System.Data.Common.DataColumnMapping.Create('N' +
                'OME_USUARIO', 'NOME_USUARIO'), System.Data.Common.DataColumnMapping.Create('L' +
                'OGIN_USUARIO', 'LOGIN_USUARIO'), System.Data.Common.DataColumnMapping.Create('S' +
                'ENHA_USUARIO', 'SENHA_USUARIO'), System.Data.Common.DataColumnMapping.Create('D' +
                'ATA_CADASTRO_USUARIO', 'DATA_CADASTRO_USUARIO')))));
  Self.daUsuarios.UpdateCommand := Self.bdpUpdateCommand1;
  // 
  // bdpDeleteCommand1
  // 
  Self.bdpDeleteCommand1.CommandOptions := nil;
  Self.bdpDeleteCommand1.CommandText := 'DELETE FROM USUARIOS WHERE NOME_USU' +
  'ARIO = ? AND LOGIN_USUARIO = ? AND SENHA_USUARIO = ? AND DATA_CADASTRO_US' +
  'UARIO = ?';
  Self.bdpDeleteCommand1.CommandType := System.Data.CommandType.Text;
  Self.bdpDeleteCommand1.Connection := Self.BdpConn;
  Self.bdpDeleteCommand1.ParameterCount := (SmallInt(4));
  Self.bdpDeleteCommand1.Parameters.Add(Borland.Data.Common.BdpParameter.Create('N' +
      'OME_USUARIOOriginal', Borland.Data.Common.BdpType.&String, Borland.Data.Common.BdpType.Unknown, 
        31, System.Data.ParameterDirection.Input, False, (Byte(30)), (Byte(0)), 
        30, 'NOME_USUARIO', System.Data.DataRowVersion.Original, nil));
  Self.bdpDeleteCommand1.Parameters.Add(Borland.Data.Common.BdpParameter.Create('L' +
      'OGIN_USUARIOOriginal', Borland.Data.Common.BdpType.&String, Borland.Data.Common.BdpType.Unknown, 
        16, System.Data.ParameterDirection.Input, False, (Byte(15)), (Byte(0)), 
        15, 'LOGIN_USUARIO', System.Data.DataRowVersion.Original, nil));
  Self.bdpDeleteCommand1.Parameters.Add(Borland.Data.Common.BdpParameter.Create('S' +
      'ENHA_USUARIOOriginal', Borland.Data.Common.BdpType.&String, Borland.Data.Common.BdpType.Unknown, 
        9, System.Data.ParameterDirection.Input, False, (Byte(8)), (Byte(0)), 
        8, 'SENHA_USUARIO', System.Data.DataRowVersion.Original, nil));
  Self.bdpDeleteCommand1.Parameters.Add(Borland.Data.Common.BdpParameter.Create('D' +
      'ATA_CADASTRO_USUARIOOriginal', Borland.Data.Common.BdpType.Date, Borland.Data.Common.BdpType.Unknown, 
        8, System.Data.ParameterDirection.Input, False, (Byte(8)), (Byte(0)), 
        8, 'DATA_CADASTRO_USUARIO', System.Data.DataRowVersion.Original, nil));
  Self.bdpDeleteCommand1.SchemaName := nil;
  Self.bdpDeleteCommand1.Transaction := nil;
  Self.bdpDeleteCommand1.UpdatedRowSource := System.Data.UpdateRowSource.None;
  // 
  // bdpInsertCommand1
  // 
  Self.bdpInsertCommand1.CommandOptions := nil;
  Self.bdpInsertCommand1.CommandText := 'INSERT INTO USUARIOS (NOME_USUARIO,' +
  ' LOGIN_USUARIO, SENHA_USUARIO, DATA_CADASTRO_USUARIO ) VALUES ( ?, ?, ?, ' +
  '?)';
  Self.bdpInsertCommand1.CommandType := System.Data.CommandType.Text;
  Self.bdpInsertCommand1.Connection := Self.BdpConn;
  Self.bdpInsertCommand1.ParameterCount := (SmallInt(4));
  Self.bdpInsertCommand1.Parameters.Add(Borland.Data.Common.BdpParameter.Create('N' +
      'OME_USUARIO', Borland.Data.Common.BdpType.&String, Borland.Data.Common.BdpType.Unknown, 
        31, System.Data.ParameterDirection.Input, False, (Byte(30)), (Byte(0)), 
        30, 'NOME_USUARIO', System.Data.DataRowVersion.Current, nil));
  Self.bdpInsertCommand1.Parameters.Add(Borland.Data.Common.BdpParameter.Create('L' +
      'OGIN_USUARIO', Borland.Data.Common.BdpType.&String, Borland.Data.Common.BdpType.Unknown, 
        16, System.Data.ParameterDirection.Input, False, (Byte(15)), (Byte(0)), 
        15, 'LOGIN_USUARIO', System.Data.DataRowVersion.Current, nil));
  Self.bdpInsertCommand1.Parameters.Add(Borland.Data.Common.BdpParameter.Create('S' +
      'ENHA_USUARIO', Borland.Data.Common.BdpType.&String, Borland.Data.Common.BdpType.Unknown, 
        9, System.Data.ParameterDirection.Input, False, (Byte(8)), (Byte(0)), 
        8, 'SENHA_USUARIO', System.Data.DataRowVersion.Current, nil));
  Self.bdpInsertCommand1.Parameters.Add(Borland.Data.Common.BdpParameter.Create('D' +
      'ATA_CADASTRO_USUARIO', Borland.Data.Common.BdpType.Date, Borland.Data.Common.BdpType.Unknown, 
        8, System.Data.ParameterDirection.Input, False, (Byte(8)), (Byte(0)), 
        8, 'DATA_CADASTRO_USUARIO', System.Data.DataRowVersion.Current, nil));
  Self.bdpInsertCommand1.SchemaName := nil;
  Self.bdpInsertCommand1.Transaction := nil;
  Self.bdpInsertCommand1.UpdatedRowSource := System.Data.UpdateRowSource.None;
  // 
  // bdpSelectCommand1
  // 
  Self.bdpSelectCommand1.CommandOptions := nil;
  Self.bdpSelectCommand1.CommandText := 'SELECT NOME_USUARIO, LOGIN_USUARIO,' +
  ' SENHA_USUARIO, DATA_CADASTRO_USUARIO FROM USUARIOS';
  Self.bdpSelectCommand1.CommandType := System.Data.CommandType.Text;
  Self.bdpSelectCommand1.Connection := Self.BdpConn;
  Self.bdpSelectCommand1.ParameterCount := (SmallInt(0));
  Self.bdpSelectCommand1.SchemaName := nil;
  Self.bdpSelectCommand1.Transaction := nil;
  Self.bdpSelectCommand1.UpdatedRowSource := System.Data.UpdateRowSource.None;
  // 
  // bdpUpdateCommand1
  // 
  Self.bdpUpdateCommand1.CommandOptions := nil;
  Self.bdpUpdateCommand1.CommandText := 'UPDATE USUARIOS SET NOME_USUARIO = ' +
  '?, LOGIN_USUARIO = ?, SENHA_USUARIO = ?, DATA_CADASTRO_USUARIO = ? WHERE ' +
  'NOME_USUARIO = ? AND LOGIN_USUARIO = ? AND SENHA_USUARIO = ? AND DATA_CAD' +
  'ASTRO_USUARIO = ?';
  Self.bdpUpdateCommand1.CommandType := System.Data.CommandType.Text;
  Self.bdpUpdateCommand1.Connection := Self.BdpConn;
  Self.bdpUpdateCommand1.ParameterCount := (SmallInt(8));
  Self.bdpUpdateCommand1.Parameters.Add(Borland.Data.Common.BdpParameter.Create('N' +
      'OME_USUARIO', Borland.Data.Common.BdpType.&String, Borland.Data.Common.BdpType.Unknown, 
        31, System.Data.ParameterDirection.Input, False, (Byte(30)), (Byte(0)), 
        30, 'NOME_USUARIO', System.Data.DataRowVersion.Current, nil));
  Self.bdpUpdateCommand1.Parameters.Add(Borland.Data.Common.BdpParameter.Create('L' +
      'OGIN_USUARIO', Borland.Data.Common.BdpType.&String, Borland.Data.Common.BdpType.Unknown, 
        16, System.Data.ParameterDirection.Input, False, (Byte(15)), (Byte(0)), 
        15, 'LOGIN_USUARIO', System.Data.DataRowVersion.Current, nil));
  Self.bdpUpdateCommand1.Parameters.Add(Borland.Data.Common.BdpParameter.Create('S' +
      'ENHA_USUARIO', Borland.Data.Common.BdpType.&String, Borland.Data.Common.BdpType.Unknown, 
        9, System.Data.ParameterDirection.Input, False, (Byte(8)), (Byte(0)), 
        8, 'SENHA_USUARIO', System.Data.DataRowVersion.Current, nil));
  Self.bdpUpdateCommand1.Parameters.Add(Borland.Data.Common.BdpParameter.Create('D' +
      'ATA_CADASTRO_USUARIO', Borland.Data.Common.BdpType.Date, Borland.Data.Common.BdpType.Unknown, 
        8, System.Data.ParameterDirection.Input, False, (Byte(8)), (Byte(0)), 
        8, 'DATA_CADASTRO_USUARIO', System.Data.DataRowVersion.Current, nil));
  Self.bdpUpdateCommand1.Parameters.Add(Borland.Data.Common.BdpParameter.Create('N' +
      'OME_USUARIOOriginal', Borland.Data.Common.BdpType.&String, Borland.Data.Common.BdpType.Unknown, 
        31, System.Data.ParameterDirection.Input, False, (Byte(30)), (Byte(0)), 
        30, 'NOME_USUARIO', System.Data.DataRowVersion.Original, nil));
  Self.bdpUpdateCommand1.Parameters.Add(Borland.Data.Common.BdpParameter.Create('L' +
      'OGIN_USUARIOOriginal', Borland.Data.Common.BdpType.&String, Borland.Data.Common.BdpType.Unknown, 
        16, System.Data.ParameterDirection.Input, False, (Byte(15)), (Byte(0)), 
        15, 'LOGIN_USUARIO', System.Data.DataRowVersion.Original, nil));
  Self.bdpUpdateCommand1.Parameters.Add(Borland.Data.Common.BdpParameter.Create('S' +
      'ENHA_USUARIOOriginal', Borland.Data.Common.BdpType.&String, Borland.Data.Common.BdpType.Unknown, 
        9, System.Data.ParameterDirection.Input, False, (Byte(8)), (Byte(0)), 
        8, 'SENHA_USUARIO', System.Data.DataRowVersion.Original, nil));
  Self.bdpUpdateCommand1.Parameters.Add(Borland.Data.Common.BdpParameter.Create('D' +
      'ATA_CADASTRO_USUARIOOriginal', Borland.Data.Common.BdpType.Date, Borland.Data.Common.BdpType.Unknown, 
        8, System.Data.ParameterDirection.Input, False, (Byte(8)), (Byte(0)), 
        8, 'DATA_CADASTRO_USUARIO', System.Data.DataRowVersion.Original, nil));
  Self.bdpUpdateCommand1.SchemaName := nil;
  Self.bdpUpdateCommand1.Transaction := nil;
  Self.bdpUpdateCommand1.UpdatedRowSource := System.Data.UpdateRowSource.None;
  // 
  // DataGrid1
  // 
  Self.DataGrid1.AlternatingBackColor := System.Drawing.Color.White;
  Self.DataGrid1.BackColor := System.Drawing.Color.White;
  Self.DataGrid1.BackgroundColor := System.Drawing.Color.Ivory;
  Self.DataGrid1.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.DataGrid1.CaptionBackColor := System.Drawing.Color.DarkSlateBlue;
  Self.DataGrid1.CaptionFont := System.Drawing.Font.Create('Microsoft Sans S' +
    'erif', 8);
  Self.DataGrid1.CaptionForeColor := System.Drawing.Color.Lavender;
  Self.DataGrid1.DataMember := 'USUARIOS';
  Self.DataGrid1.DataSource := Self.dsUsuarios;
  Self.DataGrid1.Dock := System.Windows.Forms.DockStyle.Bottom;
  Self.DataGrid1.Enabled := False;
  Self.DataGrid1.FlatMode := True;
  Self.DataGrid1.Font := System.Drawing.Font.Create('Microsoft Sans Serif', 8);
  Self.DataGrid1.ForeColor := System.Drawing.Color.Black;
  Self.DataGrid1.GridLineColor := System.Drawing.Color.Wheat;
  Self.DataGrid1.HeaderBackColor := System.Drawing.Color.CadetBlue;
  Self.DataGrid1.HeaderFont := System.Drawing.Font.Create('Microsoft Sans Se' +
    'rif', 8);
  Self.DataGrid1.HeaderForeColor := System.Drawing.Color.Black;
  Self.DataGrid1.LinkColor := System.Drawing.Color.DarkSlateBlue;
  Self.DataGrid1.Location := System.Drawing.Point.Create(0, 182);
  Self.DataGrid1.Name := 'DataGrid1';
  Self.DataGrid1.ParentRowsBackColor := System.Drawing.Color.Ivory;
  Self.DataGrid1.ParentRowsForeColor := System.Drawing.Color.Black;
  Self.DataGrid1.SelectionBackColor := System.Drawing.Color.Wheat;
  Self.DataGrid1.SelectionForeColor := System.Drawing.Color.DarkSlateBlue;
  Self.DataGrid1.Size := System.Drawing.Size.Create(688, 200);
  Self.DataGrid1.TabIndex := 12;
  // 
  // TfrmCadUsuarios
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(688, 422);
  Self.Controls.Add(Self.DataGrid1);
  Self.Controls.Add(Self.lblDataCad);
  Self.Controls.Add(Self.lblNome);
  Self.Controls.Add(Self.Label2);
  Self.Controls.Add(Self.lblLogin);
  Self.Controls.Add(Self.txtDataCad);
  Self.Controls.Add(Self.txtSenha);
  Self.Controls.Add(Self.txtLogin);
  Self.Controls.Add(Self.txtNome);
  Self.Controls.Add(Self.ToolBarBot);
  Self.Controls.Add(Self.pnlSuperior);
  Self.Name := 'TfrmCadUsuarios';
  Self.Text := '::. Usurios';
  Include(Self.Load, Self.TfrmCadUsuarios_Load);
  Self.pnlSuperior.ResumeLayout(False);
  (System.ComponentModel.ISupportInitialize(Self.dsUsuarios)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.DataTable1)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.daUsuarios)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.DataGrid1)).EndInit;
  Self.ResumeLayout(False);
end;
procedure TfrmCadUsuarios.set_State(const Value: TState);
begin
  FState := Value;
end;

{$ENDREGION}

procedure TfrmCadUsuarios.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

procedure TfrmCadUsuarios.HabilitaBotoes;
begin
  Self.tbFirst.Enabled := (cm.Position > 0);
  Self.tbLast.Enabled := (cm.Position < cm.Count-1);
  Self.tbPrior.Enabled := (cm.Position > 0);
  Self.tbNext.Enabled := (cm.Position < cm.Count-1);

  Self.tbAdd.Enabled := not (State in [dsEdit, dsInsert]);
  Self.tbEdit.Enabled := not (State in [dsEdit, dsInsert]);
  Self.tbPost.Enabled := State in [dsEdit, dsInsert];
  Self.tbCancel.Enabled := State in [dsEdit, dsInsert];
  Self.tbDelete.Enabled := not State in [dsEdit, dsInsert];
  Self.tbRefresh.Enabled := not(State in [dsEdit, dsInsert]);
end;

procedure TfrmCadUsuarios.Atualizarbanco;
begin
  daUsuarios.AutoUpdate;
  HabilitaBotoes;
end;

constructor TfrmCadUsuarios.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TfrmCadUsuarios.TfrmCadUsuarios_Load(sender: System.Object; e: System.EventArgs);
begin
  if not daUsuarios.Active then
    daUsuarios.Active := True;

  cm := BindingContext[dsUsuarios, 'USUARIOS'] as CurrencyManager;
  State  := dsBrowser;
  HabilitaBotoes;
end;

procedure TfrmCadUsuarios.ToolBarBot_ButtonClick
(sender: System.Object;
e: System.Windows.Forms.ToolBarButtonClickEventArgs);
begin
  if e.Button = tbAdd then
   begin
     cm.AddNew;
     State := dsInsert;
     txtDataCad.Text := System.DateTime.Now.ToShortDateString;
     HabilitaBotoes;
   end
  else
  if e.Button = tbEdit then
   begin
     State := dsEdit;
     HabilitaBotoes;
   end
  else
  if e.Button = tbDelete then
   begin
     cm.RemoveAt(cm.Position);
     State := dsBrowser;
     Atualizarbanco;
   end
  else
  if e.Button = tbPost then
   begin
     cm.EndCurrentEdit;
     State := dsBrowser;
     Atualizarbanco;
   end
  else
  if e.Button = tbCancel then
   begin
    cm.CancelCurrentEdit;
    State := dsBrowser;
    HabilitaBotoes;
   end
  else
  if e.Button = tbRefresh then
   begin
    daUsuarios.Active := False;
    daUsuarios.Active := True;
    State := dsBrowser;
    HabilitaBotoes;
   end
  else
  if e.Button = tbClose then
     Close
  else
  if e.Button = tbFirst then
   begin
    cm.Position := 0;
    HabilitaBotoes;
   end
  else
  if e.Button = tbPrior then
   begin
    cm.Position := cm.Position - 1;
    HabilitaBotoes;
   end
  else
  if e.Button = tbNext then
   begin
    cm.Position := cm.Position + 1;
    HabilitaBotoes;
   end
  else
  if e.Button = tbLast then
   begin
    cm.Position := cm.Count-1;
    HabilitaBotoes;
   end;
end;

end.
