unit FonteComboBox;

interface

uses
  SysUtils, Classes, Controls, StdCtrls, Forms;

type
  TFonteComboBox = class(TComboBox)
  private
    FChangeFormFont: Boolean;
    procedure SetChangeFormFont(const Value: Boolean);
  protected
  public
    constructor Create(AOwner: TComponent); override;
    procedure CreateWnd; override;
    procedure Change; override;
  published
    property Style default csDropDownList;
    property Items stored False;
    property ChangeFormFont: Boolean read FChangeFormFont write SetChangeFormFont default True;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Standard', [TFonteComboBox]);
end;

{ TFonteComboBox }

procedure TFonteComboBox.Change;
begin
  // Atribuio da nova Fonte ao Formulrio.
  if FChangeFormFont and Assigned(Owner) and (Owner is TForm) then
    TForm(Owner).Font.Name := Text;

  inherited;
end;

constructor TFonteComboBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Style := csDropDownList;
  FChangeFormFont := True;
end;

procedure TFonteComboBox.CreateWnd;
begin
  inherited CreateWnd;

  Items.Assign(Screen.Fonts);

  // Pega a fonte-padro do formulrio proprietrio.
  if FChangeFormFont and Assigned(Owner) and (Owner is TForm) then
    ItemIndex := Items.IndexOf((Owner as TForm).Font.Name);
end;

procedure TFonteComboBox.SetChangeFormFont(const Value: Boolean);
begin
  FChangeFormFont := Value;

  // Atualiza Fonte do Formulrio.
  if FChangeFormFont then
    Change;
end;

end.
