unit LabelClock;

interface

uses
  SysUtils, Classes, Controls, StdCtrls, ExtCtrls;

type
  TLabelClock = class(TCustomLabel)
  private
    FTimer: TTimer;
  protected
    procedure UpdateClock(Sender: TObject);
  public
    constructor Create(AOwner: TComponent); override;
  published
    property Align;
    property Alignment;
    property Color;
    property Font;
    property ParentFont;
    property ParentColor;
    property ParentShowHint;
    property PopupMenu;
    property Transparent;
    property ShowHint;
    property Visible;
    property Timer: TTimer read FTimer;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Standard', [TLabelClock]);
end;

{ TLabelClock }

constructor TLabelClock.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  // Criar uma instncia da classe temporizadora
  FTimer := TTimer.Create(Self);

  FTimer.Name := 'ClockTimer';
  FTimer.OnTimer := UpdateClock;
  FTimer.Enabled := True;
  FTimer.SetSubComponent(True);
end;

procedure TLabelClock.UpdateClock(Sender: TObject);
begin
  Caption := TimeToStr(Time);
end;

end.
