unit MD_CMD_SERVIDOR;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, Servidor_TLB, StdVcl, FMTBcd, DB, SqlExpr, Provider;

type
  TCMD_Servidor = class(TRemoteDataModule, ICMD_Servidor)
    sqlClientes: TSQLQuery;
    dspClientes: TDataSetProvider;
    sqlClientesCUST_NO: TIntegerField;
    sqlClientesCUSTOMER: TStringField;
    sqlClientesCONTACT_FIRST: TStringField;
    sqlClientesCONTACT_LAST: TStringField;
    sqlClientesPHONE_NO: TStringField;
    sqlClientesADDRESS_LINE1: TStringField;
    sqlClientesADDRESS_LINE2: TStringField;
    sqlClientesCITY: TStringField;
    sqlClientesSTATE_PROVINCE: TStringField;
    sqlClientesCOUNTRY: TStringField;
    sqlClientesPOSTAL_CODE: TStringField;
    sqlClientesON_HOLD: TStringField;
    sqlClientesCITYSTATE: TStringField;
    stpCancelaCliente: TSQLStoredProc;
    procedure dspClientesUpdateData(Sender: TObject;
      DataSet: TCustomClientDataSet);
    procedure dspClientesBeforeUpdateRecord(Sender: TObject;
      SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
      UpdateKind: TUpdateKind; var Applied: Boolean);
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
  public
    { Public declarations }
  end;

implementation

uses MD_CMD_DADOS;

{$R *.DFM}

class procedure TCMD_Servidor.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

procedure TCMD_Servidor.dspClientesUpdateData(Sender: TObject;
  DataSet: TCustomClientDataSet);
begin
  DataSet.FieldByName('Cust_No').ProviderFlags := [pfInUpdate, pfInKey];
  DataSet.FieldByName('CityState').ProviderFlags := [];
end;

procedure TCMD_Servidor.dspClientesBeforeUpdateRecord(Sender: TObject;
  SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
  UpdateKind: TUpdateKind; var Applied: Boolean);
begin
  with Sender as TDataSetProvider do
  begin
    if UpdateKind = ukDelete then
    begin
      with stpCancelaCliente do
      begin
        ParamByName('cust_no').asInteger := DeltaDS.FieldByName('cust_no').OldValue;
        ExecProc;
        Applied := True;
      end;
    end
    else
      UpdateMode := upWhereChanged;
  end;
end;

initialization
  TComponentFactory.Create(ComServer, TCMD_Servidor,
    Class_CMD_Servidor, ciMultiInstance, tmApartment);
end.
