unit urdmMultiCamadas;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, MultiCamadas_Server_TLB, StdVcl;

type
  TTrdmMultiCamadas = class(TRemoteDataModule, ITrdmMultiCamadas)
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
    procedure Login(const Nome, Senha: WideString); safecall;
  public
    { Public declarations }
  end;

implementation

uses ufrmPrincipal;

{$R *.DFM}

class procedure TTrdmMultiCamadas.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

procedure TTrdmMultiCamadas.Login(const Nome, Senha: WideString);
begin
  frmPrincipal.ListBox1.Items.Add(Nome);
end;

initialization
  TComponentFactory.Create(ComServer, TTrdmMultiCamadas,
    Class_TrdmMultiCamadas, ciMultiInstance, tmApartment);
end.
