unit FEditor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ImgList, Menus, Tx4oleLib_TLB, ComCtrls, ToolWin, OleCtrls,
  DBOleCtl,TXglobal,Buttons, ExtCtrls, DB, DBClient, StdCtrls;

type
  TFEditorTexto = class(TForm)
    TXStatusBar1: TTXStatusBar;
    TXButtonBar1: TTXButtonBar;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Window1: TMenuItem;
    Cascade1: TMenuItem;
    TileHorizontal1: TMenuItem;
    TileVertical1: TMenuItem;
    Arrange1: TMenuItem;
    N2: TMenuItem;
    Aboutthisdemo1: TMenuItem;
    OpenFileDialog: TOpenDialog;
    ColorDialog1: TColorDialog;
    ImageList1: TImageList;
    TXRuler1: TTXRuler;
    TX: TTXTextControl;
    SaveFileDialog: TSaveDialog;
    PopupMenu1: TPopupMenu;
    Undo2: TMenuItem;
    N11: TMenuItem;
    Cut2: TMenuItem;
    Copy2: TMenuItem;
    Paste2: TMenuItem;
    Delete2: TMenuItem;
    N12: TMenuItem;
    SelectAll2: TMenuItem;
    FontDialog1: TFontDialog;
    PrinterSetupDialog1: TPrinterSetupDialog;
    PrintDialog1: TPrintDialog;
    PopupMenu2: TPopupMenu;
    CuttCtrlX1: TMenuItem;
    Copy3: TMenuItem;
    Paste3: TMenuItem;
    N18: TMenuItem;
    FormatImage1: TMenuItem;
    FormatTextFrame1: TMenuItem;
    FormatObject1: TMenuItem;
    MainMenu2: TMainMenu;
    MenuItem1: TMenuItem;
    Save1: TMenuItem;
    Saveas1: TMenuItem;
    Export1: TMenuItem;
    Close1: TMenuItem;
    N4: TMenuItem;
    PageSetup1: TMenuItem;
    Print1: TMenuItem;
    Preview1: TMenuItem;
    MenuItem3: TMenuItem;
    MenuItem4: TMenuItem;
    Edit1: TMenuItem;
    Undo1: TMenuItem;
    Redo1: TMenuItem;
    MenuItem5: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    Delete1: TMenuItem;
    N3: TMenuItem;
    Search1: TMenuItem;
    Replace1: TMenuItem;
    N5: TMenuItem;
    Selectall1: TMenuItem;
    View1: TMenuItem;
    NormalLayout1: TMenuItem;
    PageLayout1: TMenuItem;
    CenteredPageLayout1: TMenuItem;
    N14: TMenuItem;
    HeadersandFooters1: TMenuItem;
    N15: TMenuItem;
    Toolbar2: TMenuItem;
    ParagraphBar1: TMenuItem;
    Ruler1: TMenuItem;
    StatusBar1: TMenuItem;
    N6: TMenuItem;
    ControlCharacters1: TMenuItem;
    N7: TMenuItem;
    Zoom1: TMenuItem;
    N301: TMenuItem;
    N501: TMenuItem;
    N751: TMenuItem;
    N1001: TMenuItem;
    N2001: TMenuItem;
    Insert1: TMenuItem;
    InsertText: TMenuItem;
    Image1: TMenuItem;
    OLEObject1: TMenuItem;
    extframe1: TMenuItem;
    N16: TMenuItem;
    PageBreak1: TMenuItem;
    Format1: TMenuItem;
    Character1: TMenuItem;
    N8: TMenuItem;
    BulletsandNumbering1: TMenuItem;
    Attributes1: TMenuItem;
    IncreaseLevel1: TMenuItem;
    DecreaseLevel1: TMenuItem;
    N13: TMenuItem;
    N1231: TMenuItem;
    ABC1: TMenuItem;
    abc2: TMenuItem;
    IIIIIIIV1: TMenuItem;
    iiiiiiiv2: TMenuItem;
    Bullets1: TMenuItem;
    Tabs1: TMenuItem;
    Style1: TMenuItem;
    Image2: TMenuItem;
    OLEObject2: TMenuItem;
    extFrame2: TMenuItem;
    extFrameMarkerLines1: TMenuItem;
    N9: TMenuItem;
    Frames1: TMenuItem;
    Textcolor1: TMenuItem;
    Backgroundcolor1: TMenuItem;
    Options1: TMenuItem;
    PDF1: TMenuItem;
    Tables1: TMenuItem;
    Insert2: TMenuItem;
    Table1: TMenuItem;
    N10: TMenuItem;
    ColumntotheLeft1: TMenuItem;
    ColumntotheRight1: TMenuItem;
    N17: TMenuItem;
    Rowabove1: TMenuItem;
    Rowbelow1: TMenuItem;
    Delete3: TMenuItem;
    Table2: TMenuItem;
    Column1: TMenuItem;
    Rows1: TMenuItem;
    Split1: TMenuItem;
    Above1: TMenuItem;
    Below1: TMenuItem;
    Select1: TMenuItem;
    Table4: TMenuItem;
    Row1: TMenuItem;
    Cell1: TMenuItem;
    GridLines1: TMenuItem;
    Properties1: TMenuItem;
    Ajuda1: TMenuItem;
    Sobre1: TMenuItem;
    ToolBar1: TToolBar;
    ToolButton15: TToolButton;
    btnSave: TToolButton;
    ToolButton4: TToolButton;
    btnPrint: TToolButton;
    btnPreview: TToolButton;
    ToolButton7: TToolButton;
    btnCut: TToolButton;
    btnCopy: TToolButton;
    btnPaste: TToolButton;
    ToolButton10: TToolButton;
    btnUndo: TToolButton;
    btnRedo: TToolButton;
    ToolButton13: TToolButton;
    btnFind: TToolButton;
    ToolButton17: TToolButton;
    btnHFProp: TToolButton;
    btnHFSwitch: TToolButton;
    btnHFFirstpage: TToolButton;
    btnHFDefault: TToolButton;
    CdsAutoTexto: TClientDataSet;
    CdsAutoTextoMUNICIPIO: TBCDField;
    CdsAutoTextoJUNTA: TBCDField;
    CdsAutoTextoTITULO: TStringField;
    CdsAutoTextoTEXTO: TStringField;
    CdsAutoTextoTIPO: TStringField;
    procedure FormShow(Sender: TObject);
    procedure UpdateToolButtons(bEnable: boolean);
    procedure TXChange(Sender: TObject);
    procedure TXHeaderFooterActivated(Sender: TObject;
      HeaderFooter: Smallint);
    procedure TXHeaderFooterDeactivated(Sender: TObject;
      HeaderFooter: Smallint);
    procedure TXKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure TXMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TXObjectRightClicked(Sender: TObject; ObjectId: Smallint);
    procedure TXPosChange(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure Export1Click(Sender: TObject);
    procedure PageSetup1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure Preview1Click(Sender: TObject);
    procedure MenuItem4Click(Sender: TObject);
    procedure Undo1Click(Sender: TObject);
    procedure Redo1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure Search1Click(Sender: TObject);
    procedure Replace1Click(Sender: TObject);
    procedure Selectall1Click(Sender: TObject);
    procedure NormalLayout1Click(Sender: TObject);
    procedure UncheckAll();
    procedure PageLayout1Click(Sender: TObject);
    procedure CenteredPageLayout1Click(Sender: TObject);
    procedure HeadersandFooters1Click(Sender: TObject);
    procedure Toolbar2Click(Sender: TObject);
    procedure ParagraphBar1Click(Sender: TObject);
    procedure Ruler1Click(Sender: TObject);
    procedure StatusBar1Click(Sender: TObject);
    procedure ControlCharacters1Click(Sender: TObject);
    procedure N301Click(Sender: TObject);
    procedure N501Click(Sender: TObject);
    procedure N751Click(Sender: TObject);
    procedure N1001Click(Sender: TObject);
    procedure N2001Click(Sender: TObject);
    procedure InsertTextClick(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure OLEObject1Click(Sender: TObject);
    procedure extframe1Click(Sender: TObject);
    procedure PageBreak1Click(Sender: TObject);
    procedure Character1Click(Sender: TObject);
    procedure N8Click(Sender: TObject);
    procedure Attributes1Click(Sender: TObject);
    procedure IncreaseLevel1Click(Sender: TObject);
    procedure DecreaseLevel1Click(Sender: TObject);
    procedure N1231Click(Sender: TObject);
    procedure ABC1Click(Sender: TObject);
    procedure abc2Click(Sender: TObject);
    procedure IIIIIIIV1Click(Sender: TObject);
    procedure iiiiiiiv2Click(Sender: TObject);
    procedure Bullets1Click(Sender: TObject);
    procedure Tabs1Click(Sender: TObject);
    procedure Style1Click(Sender: TObject);
    procedure Image2Click(Sender: TObject);
    procedure OLEObject2Click(Sender: TObject);
    procedure extFrame2Click(Sender: TObject);
    procedure extFrameMarkerLines1Click(Sender: TObject);
    procedure Frames1Click(Sender: TObject);
    procedure Textcolor1Click(Sender: TObject);
    procedure Backgroundcolor1Click(Sender: TObject);
    procedure PDF1Click(Sender: TObject);
    procedure Table1Click(Sender: TObject);
    procedure ColumntotheLeft1Click(Sender: TObject);
    procedure ColumntotheRight1Click(Sender: TObject);
    procedure Rowabove1Click(Sender: TObject);
    procedure Rowbelow1Click(Sender: TObject);
    procedure Table2Click(Sender: TObject);
    procedure SelectTable();
    procedure SelectTableRow();
    procedure SelectTableCell();
    procedure Column1Click(Sender: TObject);
    procedure Rows1Click(Sender: TObject);
    procedure Above1Click(Sender: TObject);
    procedure Below1Click(Sender: TObject);
    procedure Table4Click(Sender: TObject);
    procedure Row1Click(Sender: TObject);
    procedure Cell1Click(Sender: TObject);
    procedure GridLines1Click(Sender: TObject);
    procedure Properties1Click(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
    procedure btnCutClick(Sender: TObject);
    procedure btnCopyClick(Sender: TObject);
    procedure btnPasteClick(Sender: TObject);
    procedure btnUndoClick(Sender: TObject);
    procedure btnRedoClick(Sender: TObject);
    procedure btnFindClick(Sender: TObject);
    procedure btnHFPropClick(Sender: TObject);
    procedure btnHFFirstpageClick(Sender: TObject);
    procedure btnHFSwitchClick(Sender: TObject);
    procedure btnHFDefaultClick(Sender: TObject);
    procedure btnPreviewClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    Linha: TStringList;  //1> negrito , 2> alinhamento
    Doc: DOC_DATA;
    dirty: boolean;
    TamFonte: word;
    MarEsq, MarDir,
    MarSup, MarInf,
    ParDir,
    ParEsq,
    ParEsqPri: string; //margem do paragrafo

    HeaderFooterActive: Integer;
    Caminho,Nome: String;
  end;

var
  FEditorTexto: TFEditorTexto;

const
  DefaultFileName = 'Editor de Textos';

implementation

uses FileIO, PageDlg,Printers, preview, framedlg, pdfexport, frmInsertT,
     HeaderProp;

{$R *.dfm}

procedure TFEditorTexto.FormShow(Sender: TObject);
begin
  dirty := false;
  {connecting the controls}
  TX.ButtonBarHandle := TXButtonBar1.Handle;
  TX.RulerHandle := TXRuler1.Handle;
  TX.StatusBarHandle := TXStatusBar1.Handle;

  { Delphi specific: Required for selecting a word with
    double click and for using the OnDblClick event }
  TX.ControlStyle := TX.ControlStyle + [csDoubleClicks];

  TX.FormatSelection := true;

  if (TX.Language = 49) then begin
    glnMeasurement := M_CM;
    TX.PageWidth := DINA4_X;
    TX.PageHeight := DINA4_Y;
  end
  else
  begin
    glnMeasurement := M_INCH;
    TX.PageWidth := USLET_X;
    TX.PageHeight := USLET_Y;
  end;

end;

procedure TFEditorTexto.UpdateToolButtons(bEnable: boolean);
begin
  btnSave.Enabled := bEnable;
  btnPrint.Enabled := bEnable;
  btnPreview.Enabled := bEnable;
  btnCut.Enabled := bEnable;
  btnCopy.Enabled := bEnable;
  btnPaste.Enabled := bEnable;

  if FEditorTexto <> nil then begin
    btnUndo.Enabled := boolean(TX.CanUndo);
    btnRedo.Enabled := boolean(TX.CanRedo);
  end
  else begin
    btnUndo.Enabled := false;
    btnRedo.Enabled := false;
  end;

  btnFind.Enabled := bEnable;
end;

procedure TFEditorTexto.TXChange(Sender: TObject);
begin
  if dirty = False then dirty := true;
end;

procedure TFEditorTexto.TXHeaderFooterActivated(Sender: TObject;
  HeaderFooter: Smallint);
begin
    btnHFProp.Enabled := True;
    btnHFSwitch.Enabled := True;
    btnHFFirstPage.Enabled := False;
    btnHFFirstPage.Enabled := (boolean(TX.HeaderFooter and txFirstHeader) or boolean(TX.HeaderFooter and txFirstFooter))
      and ((HeaderFooter = txHeader) or (HeaderFooter = txFooter));
    btnHFDefault.Enabled := (TX.CurrentPages > 1) and ((HeaderFooter = txFirstHeader) or (HeaderFooter = txFirstFooter));
    HeaderFooterActive := HeaderFooter;
end;

procedure TFEditorTexto.TXHeaderFooterDeactivated(Sender: TObject;
  HeaderFooter: Smallint);
begin
   btnHFProp.Enabled := False;
   btnHFSwitch.Enabled := False;
   btnHFFirstPage.Enabled := False;
   btnHFDefault.Enabled := False;
   HeaderFooterActive := 0;
end;

procedure TFEditorTexto.TXKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = 45 then TX.InsertionMode := not TX.InsertionMode
end;

procedure TFEditorTexto.TXMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  BringToFront;
end;

procedure TFEditorTexto.TXObjectRightClicked(Sender: TObject;
  ObjectId: Smallint);
var
   pt: TPoint;

begin
   PopupMenu2.Items[4].Visible := (TX.ObjectGetSelected(4) > 0);
   PopupMenu2.Items[5].Visible := (TX.ObjectGetSelected(32) > 0);
   PopupMenu2.Items[6].Visible := (TX.ObjectGetSelected(16) > 0);

   if ( PopupMenu2.Items[4].Visible
      Or PopupMenu2.Items[5].Visible
      Or PopupMenu2.Items[6].Visible) Then begin
      GetCursorPos(pt);
      PopupMenu2.Popup(pt.X, pt.Y);
   end;
end;

procedure TFEditorTexto.TXPosChange(Sender: TObject);
begin
  btnCut.Enabled := boolean(TX.CanCopy);
  btnCopy.Enabled := boolean(TX.CanCopy);
  btnUndo.Enabled := boolean(TX.CanUndo);
  btnRedo.Enabled := boolean(TX.CanRedo);
end;

procedure TFEditorTexto.FormResize(Sender: TObject);
begin
//  TXStatusbar1.Top := ClientHeight;
  TX.Height := ClientHeight - TXRuler1.Height - TXStatusBar1.Height - TXButtonBar1.Height - ToolBar1.Height;
end;

procedure TFEditorTexto.Save1Click(Sender: TObject);
begin
  FileSaveProc;
end;

procedure TFEditorTexto.btnSaveClick(Sender: TObject);
begin
  FileSaveProc;
end;

procedure TFEditorTexto.Saveas1Click(Sender: TObject);
begin
  FileSaveAsProc;
end;

procedure TFEditorTexto.Export1Click(Sender: TObject);
begin
  SaveFileDialog.Title := 'Exportar Arquivo';
  SaveFileDialog.Filter := 'Formato do Documento (*.pdf)|*.pdf|Cascading Style Sheet (*.css)|*.css';
  SaveFileDialog.DefaultExt := 'pdf';
  SaveFileDialog.Filename := Caption;

  if SaveFileDialog.Execute then begin
    SaveFile(SaveFileDialog.Filename);
  end;
end;

procedure TFEditorTexto.PageSetup1Click(Sender: TObject);
begin
  frmPageDlg := TfrmPageDlg.Create(Self);
  frmPageDlg.ShowModal;
  frmPageDlg.Free;
end;

procedure TFEditorTexto.Print1Click(Sender: TObject);
var Copy,
  CurPage,
    StartPage,
    EndPage: Integer;
begin
  try
    StartPage := 1;
    EndPage := TX.CurrentPages;

  // Initialize and call the common print dialog
    PrintDialog1.Copies := 1;
    PrintDialog1.FromPage := 1;
    PrintDialog1.ToPage := EndPage;
    PrintDialog1.MinPage := 1;
    PrintDialog1.MaxPage := EndPage;
    PrintDialog1.Options := [poPrintToFile, poPageNums];

    if PrintDialog1.Execute then begin
     // Get first and last page
      if poPageNums in PrintDialog1.Options then begin
        StartPage := PrintDialog1.FromPage;
        EndPage := PrintDialog1.ToPage;
      end;

     // Print selected pages
      Printer.BeginDoc;
      for Copy := 1 to PrintDialog1.Copies do begin
        for CurPage := StartPage to EndPage do begin
          TX.PrintDevice := Printer.CanVas.Handle;
          TX.PrintPage(CurPage);
          if (CurPage <> EndPage) then Printer.NewPage;
        end;
      end;
      Printer.EndDoc;
    end;
  except
    on EPrinter do MessageDlg('ERROR imprimindo ' + FEditorTexto.Caption, mtError, [mbOK], 0);
  end;
end;

procedure TFEditorTexto.Preview1Click(Sender: TObject);
begin
  frmPrintPreview := TfrmPrintPreview.Create(Self);
  frmPrintPreview.ShowPreview(TX);
  frmPrintPreview.Free;
end;

procedure TFEditorTexto.MenuItem4Click(Sender: TObject);
begin
  close;
end;

procedure TFEditorTexto.Undo1Click(Sender: TObject);
begin
  TX.Undo;
end;

procedure TFEditorTexto.Redo1Click(Sender: TObject);
begin
  TX.Redo;
end;

procedure TFEditorTexto.Cut1Click(Sender: TObject);
begin
  TX.Clip(CLIP_CUT);
end;

procedure TFEditorTexto.Copy1Click(Sender: TObject);
begin
  TX.Clip(CLIP_COPY);
end;

procedure TFEditorTexto.Paste1Click(Sender: TObject);
begin
  TX.Clip(CLIP_PASTE);
end;

procedure TFEditorTexto.Delete1Click(Sender: TObject);
begin
  TX.Clip(CLIP_CLEAR);
end;

procedure TFEditorTexto.Search1Click(Sender: TObject);
begin
  TX.FindReplace(1);
end;

procedure TFEditorTexto.Replace1Click(Sender: TObject);
begin
  TX.FindReplace(2);
end;

procedure TFEditorTexto.Selectall1Click(Sender: TObject);
var nPointer: Integer; // MousePointer proterty value
begin
  nPointer := TX.MousePointer;
  TX.MousePointer := 11;
  TX.SelStart := 0;
  TX.SelLength := -1;
  TX.MousePointer := nPointer;
end;

procedure TFEditorTexto.NormalLayout1Click(Sender: TObject);
begin
  UncheckAll();
  TX.ViewMode := 0;
  NormalLayout1.Checked := True;
end;

procedure TFEditorTexto.UncheckAll;
begin
  NormalLayout1.Checked := False;
  PageLayout1.Checked := False;
  CenteredPageLayout1.Checked := False;
end;

procedure TFEditorTexto.PageLayout1Click(Sender: TObject);
begin
  UncheckAll();
  TX.ViewMode := 1;
  PageLayout1.Checked := True;
end;

procedure TFEditorTexto.CenteredPageLayout1Click(Sender: TObject);
begin
  UncheckAll();
  TX.ViewMode := 2;
  CenteredPageLayout1.Checked := True;
end;

procedure TFEditorTexto.HeadersandFooters1Click(Sender: TObject);
begin
  if not HeadersandFooters1.Checked then begin
        // Create a header and footer if the document does not have them
    if TX.HeaderFooter = 0 then TX.HeaderFooter := txHeader + txFooter;

        // Let user activate headers with a single mouse click
    TX.HeaderFooterStyle := txMouseClick;

        // Activate header on page 1
    if (TX.HeaderFooter and txFirstHeader) = 1 then begin
      TX.HeaderFooterActivate(txFirstHeader);
      HeaderFooterActive := txFirstHeader;
    end else begin
      TX.HeaderFooterActivate(txHeader);
      HeaderFooterActive := txHeader;
    end;
    HeadersandFooters1.Checked := True;
  end else begin
    TX.HeaderFooterActivate(txMainText);
    HeaderFooterActive := 0;
  end;
end;

procedure TFEditorTexto.Toolbar2Click(Sender: TObject);
begin
  FEditorTexto.ToolBar1.Visible := not FEditorTexto.ToolBar1.Visible;
  Toolbar2.Checked := FEditorTexto.ToolBar1.Visible;
end;

procedure TFEditorTexto.ParagraphBar1Click(Sender: TObject);
begin
  FEditorTexto.TXButtonBar1.Visible := not FEditorTexto.TXButtonBar1.Visible;
  ParagraphBar1.Checked := FEditorTexto.TXButtonBar1.Visible;
end;

procedure TFEditorTexto.Ruler1Click(Sender: TObject);
begin
  TXRuler1.Visible := not TXRuler1.Visible;
  Ruler1.Checked := TXRuler1.Visible;
  OnResize(Sender);
end;

procedure TFEditorTexto.StatusBar1Click(Sender: TObject);
begin
  TXStatusBar1.Visible := not TXStatusBar1.Visible;
  StatusBar1.Checked := TXStatusBar1.Visible;
end;

procedure TFEditorTexto.ControlCharacters1Click(Sender: TObject);
begin
  TX.ControlChars := not TX.ControlChars;
end;

procedure TFEditorTexto.N301Click(Sender: TObject);
begin
  TX.ZoomFactor := 30;
  TXRuler1.Repaint;
end;

procedure TFEditorTexto.N501Click(Sender: TObject);
begin
  TX.ZoomFactor := 50;
  TXRuler1.Repaint;
end;

procedure TFEditorTexto.N751Click(Sender: TObject);
begin
  TX.ZoomFactor := 75;
  TXRuler1.Repaint;
end;

procedure TFEditorTexto.N1001Click(Sender: TObject);
begin
  TX.ZoomFactor := 100;
  TXRuler1.Repaint;
end;

procedure TFEditorTexto.N2001Click(Sender: TObject);
begin
  TX.ZoomFactor := 200;
  TXRuler1.Repaint;
end;

procedure TFEditorTexto.InsertTextClick(Sender: TObject);
 {Get text file name and import text (ANSI, HTML or RTF)}
var sFileName, Check: string;
begin

  try
    with FEditorTexto do begin
      OpenFileDialog.Title := 'Inserir Texto';
      OpenFileDialog.Filter := 'Texto (*.txt)|*.txt|RTF Format (*.rtf)|*.rtf|HTML Format(*.htm), (*.html)|*.htm;*.html';
      OpenFileDialog.Options := [ofPathMustExist, ofOverwritePrompt, ofHideReadOnly];

      if OpenFileDialog.Execute then begin
        sFileName := OpenfileDialog.Filename;
        FEditorTexto.Cursor := crHourGlass; // Hourglass

        Check := UpperCase(copy(sFilename, length(sFilename) - 2, 3));
        if Check = 'RTF' then OpenFile(sFilename, RTF_FILE, True);
        if Check = 'HTM' then OpenFile(sFilename, HTM_FILE, True); //Check for .htm or .html
        if Check = 'TML' then OpenFile(sFilename, HTM_FILE, True) //extension.
        else OpenFile(sFilename, TXT_FILE, True)
      end;
    end;
  except
    MessageDlg('Arquivo no encontrado: ' + sFileName, mtError, [mbOK], 0);
    FEditorTexto.Cursor := 0; // default
  end;

  FEditorTexto.Cursor := 0; // default
end;

procedure TFEditorTexto.Image1Click(Sender: TObject);
begin
   InsertImage(TX, OpenFileDialog);
end;

procedure TFEditorTexto.OLEObject1Click(Sender: TObject);
begin
   InsertObject(TX);
end;

procedure TFEditorTexto.extframe1Click(Sender: TObject);
begin
   InsertTextFrame(TX);
end;

procedure TFEditorTexto.PageBreak1Click(Sender: TObject);
begin
  TX.SelText := Chr(12);
end;

procedure TFEditorTexto.Character1Click(Sender: TObject);
begin
  TX.FontDialog;
end;

procedure TFEditorTexto.N8Click(Sender: TObject);
begin
  TX.ParagraphDialog;
end;

procedure TFEditorTexto.Attributes1Click(Sender: TObject);
begin
  TX.ListAttrDialog;
end;

procedure TFEditorTexto.IncreaseLevel1Click(Sender: TObject);
var
  Indent: LongInt;
begin
  with TX do begin
    if ListType = txListBulleted then begin
      Indent := BulletAttribute[txBulletTextPos] - BulletAttribute[txBulletPos];
      BulletAttribute[txBulletLevel] := BulletAttribute[txBulletLevel] + 1;
      BulletAttribute[txBulletPos] := BulletAttribute[txBulletPos] + Indent;
      BulletAttribute[txBulletTextPos] := BulletAttribute[txBulletTextPos] + Indent;
    end else if ListType = txListNumbered then begin
      Indent := NumberingAttribute[txNumberingTextPos] + NumberingAttribute[txNumberingPos];
      NumberingAttribute[txNumberingLevel] := NumberingAttribute[txNumberingLevel] + 1;
      NumberingAttribute[txNumberingPos] := NumberingAttribute[txNumberingPos] + Indent;
      NumberingAttribute[txNumberingTextPos] := NumberingAttribute[txNumberingTextPos] + Indent;
    end;
    ListType := ListType;
  end;
end;

procedure TFEditorTexto.DecreaseLevel1Click(Sender: TObject);
var
  Indent: LongInt;
begin
  with TX do begin
    if ListType = txListBulleted then begin
      Indent := BulletAttribute[txBulletTextPos] - BulletAttribute[txBulletPos];
      BulletAttribute[txBulletLevel] := BulletAttribute[txBulletLevel] - 1;
      BulletAttribute[txBulletPos] := BulletAttribute[txBulletPos] - Indent;
      BulletAttribute[txBulletTextPos] := BulletAttribute[txBulletTextPos] - Indent;
    end else if ListType = txListNumbered then begin
      Indent := NumberingAttribute[txNumberingTextPos] - NumberingAttribute[txNumberingPos];
      NumberingAttribute[txNumberingLevel] := NumberingAttribute[txNumberingLevel] - 1;
      NumberingAttribute[txNumberingPos] := NumberingAttribute[txNumberingPos] - Indent;
      NumberingAttribute[txNumberingTextPos] := NumberingAttribute[txNumberingTextPos] - Indent;
    end;
    ListType := ListType;
  end;
end;

procedure TFEditorTexto.N1231Click(Sender: TObject);
begin
  TX.NumberingAttribute[txNumberingFormat] := 3;
  TX.ListType := txListNumbered;
end;

procedure TFEditorTexto.ABC1Click(Sender: TObject);
begin
  TX.NumberingAttribute[txNumberingFormat] := 5;
  TX.ListType := txListNumbered;
end;

procedure TFEditorTexto.abc2Click(Sender: TObject);
begin
  TX.NumberingAttribute[txNumberingFormat] := 4;
  TX.ListType := txListNumbered;
end;

procedure TFEditorTexto.IIIIIIIV1Click(Sender: TObject);
begin
  TX.NumberingAttribute[txNumberingFormat] := 6;
  TX.ListType := txListNumbered;
end;

procedure TFEditorTexto.iiiiiiiv2Click(Sender: TObject);
begin
  TX.NumberingAttribute[txNumberingFormat] := 7;
  TX.ListType := txListNumbered;
end;

procedure TFEditorTexto.Bullets1Click(Sender: TObject);
begin
  TX.ListType := txListBulleted;
end;

procedure TFEditorTexto.Tabs1Click(Sender: TObject);
begin
  TX.TabDialog;
end;

procedure TFEditorTexto.Style1Click(Sender: TObject);
begin
  TX.StyleDialog;
end;

procedure TFEditorTexto.Image2Click(Sender: TObject);
begin
   TX.ObjectAttrDialog;
end;

procedure TFEditorTexto.OLEObject2Click(Sender: TObject);
begin
   TX.ObjectAttrDialog;
end;

procedure TFEditorTexto.extFrame2Click(Sender: TObject);
begin
  TX.ObjectAttrDialog;
end;

procedure TFEditorTexto.extFrameMarkerLines1Click(Sender: TObject);
begin
  TX.TextFrameMarkerLines := Not extFrameMarkerLines1.Checked;
  extFrameMarkerLines1.Checked := TX.TextFrameMarkerLines;
end;

procedure TFEditorTexto.Frames1Click(Sender: TObject);
begin
  FramesDlg := TFramesDlg.Create(Self);
  FramesDlg.ShowModal;
  FramesDlg.Free;
end;

procedure TFEditorTexto.Textcolor1Click(Sender: TObject);
var lOldColor: LongInt;
begin
  lOldColor := TX.ForeColor;

  if lOldColor = -1 then begin
    ColorDialog1.Color := 0; // use black if different colors
  end else begin
    ColorDialog1.Color := lOldColor;
  end;

  if ColorDialog1.Execute then begin
     // set new color
    if (lOldColor = -1) or (ColorDialog1.Color <> lOldColor) then begin
      TX.ForeColor := ColorDialog1.Color;
    end;
  end;
end;

procedure TFEditorTexto.Backgroundcolor1Click(Sender: TObject);
var lOldColor: LongInt;
begin
  lOldColor := TX.TextBKColor;

  if lOldColor = -1 then begin
    ColorDialog1.Color := 0; // use black if different colors
  end else begin
    ColorDialog1.Color := lOldColor;
  end;

  if ColorDialog1.Execute then begin
     // set new color
    if (lOldColor = -1) or (ColorDialog1.Color <> lOldColor) then begin
      TX.TextBKColor := ColorDialog1.Color;
    end;
  end;
end;

procedure TFEditorTexto.PDF1Click(Sender: TObject);
begin
  frmPDFOptionsDlg := TfrmPDFOptions.Create(Self);
  frmPDFOptionsDlg.ShowModal;
  frmPDFOptionsDlg.Free;
end;

procedure TFEditorTexto.Table1Click(Sender: TObject);
begin
  frmInsertTab:= TfrmInsertTab.Create(Self);
  frmInsertTab.Show;
end;

procedure TFEditorTexto.ColumntotheLeft1Click(Sender: TObject);
begin
  TX.TableInsertColumn(txTableInsertInFront);
end;

procedure TFEditorTexto.ColumntotheRight1Click(Sender: TObject);
begin
  TX.TableInsertColumn(txTableInsertAfter);
end;

procedure TFEditorTexto.Rowabove1Click(Sender: TObject);
begin
  TX.TableInsertLines(txTableInsertInFront, 1);
end;

procedure TFEditorTexto.Rowbelow1Click(Sender: TObject);
begin
  TX.TableInsertLines(txTableInsertAfter, 1);
end;

procedure TFEditorTexto.Table2Click(Sender: TObject);
begin
  SelectTable;
  TX.TableDeleteLines;
end;

procedure TFEditorTexto.SelectTable;
begin
  with TX do begin
    SelStart := TableCellStart[TableAtInputPos, 1, 1] - 1;
    SelLength := TableCellStart[TableAtInputPos, TableRows[TableAtInputPos], TableColumns[TableAtInputPos]] +
      TableCellLength[TableAtInputPos, TableRows[TableAtInputPos], TableColumns[TableAtInputPos]] +
      -SelStart;
  end;
end;

procedure TFEditorTexto.SelectTableCell;
begin
  with TX do begin
    SelStart := TableCellStart[TableAtInputPos, TableRowAtInputPos, TableColAtInputPos] - 1;
    SelLength := TableCellLength[TableAtInputPos, TableRowAtInputPos, TableColAtInputPos] + 1;
  end;
end;

procedure TFEditorTexto.SelectTableRow;
begin
  with TX do begin
    SelStart := TableCellStart[TableAtInputPos, TableRowAtInputPos, 1] - 1;
    SelLength := TableCellStart[TableAtInputPos, TableRowAtInputPos, TableColumns[TableAtInputPos]] +
      TableCellLength[TableAtInputPos, TableRowAtInputPos, TableColumns[TableAtInputPos]] +
      -SelStart;
  end;
end;

procedure TFEditorTexto.Column1Click(Sender: TObject);
begin
  TX.TableDeleteColumn;
end;

procedure TFEditorTexto.Rows1Click(Sender: TObject);
begin
  TX.TableDeleteLines;
end;

procedure TFEditorTexto.Above1Click(Sender: TObject);
begin
  TX.TableSplit(TBL_ABOVE);
end;

procedure TFEditorTexto.Below1Click(Sender: TObject);
begin
  TX.TableSplit(TBL_BELOW);
end;

procedure TFEditorTexto.Table4Click(Sender: TObject);
begin
  SelectTable;
end;

procedure TFEditorTexto.Row1Click(Sender: TObject);
begin
  SelectTableRow;
end;

procedure TFEditorTexto.Cell1Click(Sender: TObject);
begin
  SelectTableCell;
end;

procedure TFEditorTexto.GridLines1Click(Sender: TObject);
begin
  TX.TableGridLines := not TX.TableGridLines;
end;

procedure TFEditorTexto.Properties1Click(Sender: TObject);
begin
  TX.TableAttrDialog;
end;

procedure TFEditorTexto.btnPrintClick(Sender: TObject);
var wPages, No : Integer;
begin
  wPages := TX.CurrentPages;
  Printer.BeginDoc;
  for No := 1 To wPages do
  begin
    TX.PrintDevice := Printer.Canvas.Handle;
    TX.PrintPage(No);
    if No <> wPages then
      Printer.NewPage;
  end;
  Printer.EndDoc;
end;

procedure TFEditorTexto.btnCutClick(Sender: TObject);
begin
  TX.Clip(CLIP_CUT);
end;

procedure TFEditorTexto.btnCopyClick(Sender: TObject);
begin
  TX.Clip(CLIP_COPY);
end;

procedure TFEditorTexto.btnPasteClick(Sender: TObject);
begin
  TX.Clip(CLIP_PASTE);
end;

procedure TFEditorTexto.btnUndoClick(Sender: TObject);
begin
  TX.Undo;
end;

procedure TFEditorTexto.btnRedoClick(Sender: TObject);
begin
  TX.Redo;
end;

procedure TFEditorTexto.btnFindClick(Sender: TObject);
begin
  TX.FindReplace(1);
end;

procedure TFEditorTexto.btnHFPropClick(Sender: TObject);
begin
  frmHeaderProp := TfrmHeaderProp.Create(Self);
  frmHeaderProp.ShowDlg(TX);
end;

procedure TFEditorTexto.btnHFFirstpageClick(Sender: TObject);
var
  active: TFEditorTexto;
begin
  active := TFEditorTexto(ActiveMDIChild);
  if active.HeaderFooterActive = txFooter then
    active.TX.HeaderFooterActivate(txFirstFooter)
  else if (active.HeaderFooterActive = txHeader) then
    active.TX.HeaderFooterActivate(txFirstHeader);
end;

procedure TFEditorTexto.btnHFSwitchClick(Sender: TObject);
var
  active: TFEditorTexto;
begin
  active := TFEditorTexto(ActiveMDIChild);
  if (active.HeaderFooterActive = txHeader) then
    active.HeaderFooterActive := txFooter
  else if (active.HeaderFooterActive = txFooter) then
    active.HeaderFooterActive := txHeader
  else if (active.HeaderFooterActive = txFirstHeader) then
    active.HeaderFooterActive := txFirstFooter
  else if (active.HeaderFooterActive = txFirstFooter) then
    active.HeaderFooterActive := txFirstHeader;
  active.TX.HeaderFooterActivate(active.HeaderFooterActive);
end;

procedure TFEditorTexto.btnHFDefaultClick(Sender: TObject);
var
  active: TFEditorTexto;
begin
  active := TFEditorTexto(ActiveMDIChild);
  if active.HeaderFooterActive = txFirstFooter then
    active.TX.HeaderFooterActivate(txFooter)
  else if (active.HeaderFooterActive = txFirstHeader) then
    active.TX.HeaderFooterActivate(txHeader);
end;

procedure TFEditorTexto.btnPreviewClick(Sender: TObject);
begin
  frmPrintPreview := TfrmPrintPreview.Create(Self);
  frmPrintPreview.ShowPreview(TX);
  frmPrintPreview.Free;
end;

procedure TFEditorTexto.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var i, inicio, fim: integer;
    str: string;
begin
  if (key = 114) and (TX.Focused) then
  begin
    inicio:= TX.SelStart;
    str:= TX.Text[inicio];
     while (str <> ' ') and (str <> #$A) and (inicio > 0)  do
     begin
       dec(inicio);  // acha inicio
       str:= TX.Text[inicio];
     end;

    inc(inicio);
    fim:= inicio;
    str:= TX.Text[fim];
    while (str <> ' ') and (str <> #$A) and (fim <= length(TX.Text)) do
    begin
      inc(fim);  // acha fim
      str:= TX.Text[fim];
    end;

    dec(fim);
    str:= '';

    for i:= inicio to fim do
      str:= str + TX.Text[i];    //    showmessage(str);
      
    if CdsAutoTexto.Active then
      if CdsAutoTexto.Locate('Titulo', str, [loCaseInsensitive]) then
      begin
        TX.SelStart:= inicio - 1;
        TX.SelLength:= fim - inicio + 1;
        TX.SelText:= CdsAutoTextoTEXTO.AsString;
      end;
  end
end;

end.
