unit HeaderProp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Tx4oleLib_TLB;

type
  TfrmHeaderProp = class(TForm)
    GroupBox1: TGroupBox;
    Edit1: TEdit;
    Edit2: TEdit;
    UpDown2: TUpDown;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Button1: TButton;
    Button2: TButton;
    CheckBox1: TCheckBox;
    UpDown1: TUpDown;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ShowDlg(tx: TTXTextControl);
  private
    { Private-Deklarationen }
  public

  end;

var
  frmHeaderProp: TfrmHeaderProp;
  m_TX: TTXTextControl;
const TWIPS2MM = 56.7;

implementation

{$R *.DFM}

procedure TfrmHeaderProp.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TfrmHeaderProp.Button1Click(Sender: TObject);
begin
  m_TX.HeaderFooterPosition[txHeader] := Round(StrToInt(Edit1.Text) * TWIPS2MM);
  m_TX.HeaderFooterPosition[txFooter] := Round(StrToInt(Edit2.Text) * TWIPS2MM);

  if CheckBox1.Checked then
    m_TX.HeaderFooter := txHeader or txFooter or txFirstHeader or txFirstFooter
  else
    m_TX.HeaderFooter := txHeader or txFooter;

  Close;
end;

procedure TfrmHeaderProp.ShowDlg(tx: TTXTextControl);
begin
  m_TX := tx;

  UpDown1.Position := Round(m_TX.HeaderFooterPosition[txHeader] / TWIPS2MM);
  UpDown2.Position := Round(m_TX.HeaderFooterPosition[txFooter] / TWIPS2MM);

  CheckBox1.Checked := (m_TX.HeaderFooter and (txFirstHeader or txFirstFooter)) <> 0;

  ShowModal;
end;

end.
