unit PageDlg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TfrmPageDlg = class(TForm)
    GroupBox1: TGroupBox;
    cboPaperSize: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    txtPaperWidth: TEdit;
    txtPaperHeight: TEdit;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    txtTopMargin: TEdit;
    txtLeftMargin: TEdit;
    txtRightMargin: TEdit;
    txtBottomMargin: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    cmdOK: TButton;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure cboPaperSizeClick(Sender: TObject);
    procedure txtPaperWidthChange(Sender: TObject);
    procedure txtPaperHeightChange(Sender: TObject);
    procedure txtTopMarginChange(Sender: TObject);
    procedure txtLeftMarginChange(Sender: TObject);
    procedure txtRightMarginChange(Sender: TObject);
    procedure txtBottomMarginChange(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    function PageSettingsValid: boolean;
  public

  end;

var
  frmPageDlg: TfrmPageDlg;

implementation

uses TXglobal, FEditor;

{$R *.DFM}

procedure TfrmPageDlg.FormCreate(Sender: TObject);
begin
   // Fill Page Size combo box
  cboPaperSize.Items.Add(A4);
  cboPaperSize.Items.Add(A5);
  cboPaperSize.Items.Add(B5);
  cboPaperSize.Items.Add(LETTER);
  cboPaperSize.Items.Add(LEGAL);
  cboPaperSize.Items.Add(USER_DEFINED);
end;

procedure TfrmPageDlg.FormShow(Sender: TObject);
begin
  with FEditorTexto do
  begin
    with FEditorTexto.TX do
    begin
        // Copy document size and margins to dialog controls
      txtLeftMargin.Text := Twips2DlgString(PageMarginL);
      txtTopMargin.Text := Twips2DlgString(PageMarginT);
      txtRightMargin.Text := Twips2DlgString(PageMarginR);
      txtBottomMargin.Text := Twips2DlgString(PageMarginB);
      txtPaperWidth.Text := Twips2DlgString(PageWidth);
      txtPaperHeight.Text := Twips2DlgString(PageHeight);
    end;
     // Select size in combo box
    cboPaperSize.ItemIndex := FEditorTexto.Doc.nPaperSize;
  end;

end;

function TfrmPageDlg.PageSettingsValid: boolean;
{ Check if page size and margin settings are valid. Restrict
  page size to avoid overflow in scrollbar range.}
var l: LongInt;
  bValid: boolean;
begin
  bValid := True;

  l := DlgString2Twips(txtLeftMargin.Text);
  if (l > DlgString2Twips(txtPaperWidth.Text)) or (l <= 0) then bValid := False;

  l := DlgString2Twips(txtRightMargin.Text);
  if (l > DlgString2Twips(txtPaperWidth.Text)) or (l <= 0) then bValid := False;

  l := DlgString2Twips(txtTopMargin.Text);
  if (l > DlgString2Twips(txtPaperHeight.Text)) or (l <= 0) then bValid := False;

  l := DlgString2Twips(txtBottomMargin.Text);
  if (l > DlgString2Twips(txtPaperHeight.Text)) or (l <= 0) then bValid := False;

  l := DlgString2Twips(txtPaperWidth.Text);
  if (2 * l > MAXINT) or (l <= 0) then bValid := False;

  l := DlgString2Twips(txtPaperHeight.Text);
  if (l > MAXINT) or (l <= 0) then bValid := False;

  PageSettingsValid := bValid;
end;


procedure TfrmPageDlg.cboPaperSizeClick(Sender: TObject);
begin
  case cboPaperSize.ItemIndex of
    0: begin // A4
        txtPaperWidth.Text := Twips2DlgString(DINA4_X);
        txtPaperHeight.Text := Twips2DlgString(DINA4_Y);
      end;
    1: begin // A5
        txtPaperWidth.Text := Twips2DlgString(DINA5_X);
        txtPaperHeight.Text := Twips2DlgString(DINA5_Y);
      end;
    2: begin // B5
        txtPaperWidth.Text := Twips2DlgString(B5_X);
        txtPaperHeight.Text := Twips2DlgString(B5_Y);
      end;
    3: begin // LETTER
        txtPaperWidth.Text := Twips2DlgString(USLET_X);
        txtPaperHeight.Text := Twips2DlgString(USLET_Y);
      end;
    4: begin // LEGAL
        txtPaperWidth.Text := Twips2DlgString(USLEGAL_X);
        txtPaperHeight.Text := Twips2DlgString(USLEGAL_Y);
      end;
  end; // case
end;

procedure TfrmPageDlg.txtPaperWidthChange(Sender: TObject);
begin
  cmdOk.Enabled := PageSettingsValid;
end;

procedure TfrmPageDlg.txtPaperHeightChange(Sender: TObject);
begin
  cmdOk.Enabled := PageSettingsValid;
end;

procedure TfrmPageDlg.txtTopMarginChange(Sender: TObject);
begin
  cmdOk.Enabled := PageSettingsValid;
end;

procedure TfrmPageDlg.txtLeftMarginChange(Sender: TObject);
begin
  cmdOk.Enabled := PageSettingsValid;
end;

procedure TfrmPageDlg.txtRightMarginChange(Sender: TObject);
begin
  cmdOk.Enabled := PageSettingsValid;
end;

procedure TfrmPageDlg.txtBottomMarginChange(Sender: TObject);
begin
  cmdOk.Enabled := PageSettingsValid;
end;

procedure TfrmPageDlg.cmdOKClick(Sender: TObject);
begin
  with FEditorTexto do
  begin
    with TX do
    begin
      PageMarginL := DlgString2Twips(txtLeftMargin.Text);
      PageMarginT := DlgString2Twips(txtTopMargin.Text);
      PageMarginR := DlgString2Twips(txtRightMargin.Text);
      PageMarginB := DlgString2Twips(txtBottomMargin.Text);
      PageWidth := DlgString2Twips(txtPaperWidth.Text);
      PageHeight := DlgString2Twips(txtPaperHeight.Text);
    end;
    Doc.nPaperSize := cboPaperSize.ItemIndex;
  end;
  close;
end;

procedure TfrmPageDlg.Button2Click(Sender: TObject);
begin
  Close;
end;

end.
