unit framedlg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Tx4oleLib_TLB, TXGLOBAL;

type
  TFramesDlg = class(TForm)
    GroupBox1: TGroupBox;
    chkLeft: TCheckBox;
    chkRight: TCheckBox;
    chkTop: TCheckBox;
    chkBottom: TCheckBox;
    chkTabLines: TCheckBox;
    GroupBox2: TGroupBox;
    chkConnected: TCheckBox;
    chkDoubleLines: TCheckBox;
    cmdOK: TButton;
    cmdCancel: TButton;
    Label1: TLabel;
    Label2: TLabel;
    cboLineWidth: TComboBox;
    cboTextDistance: TComboBox;
    procedure FormShow(Sender: TObject);
    procedure chkLeftClick(Sender: TObject);
    procedure chkRightClick(Sender: TObject);
    procedure chkTopClick(Sender: TObject);
    procedure chkBottomClick(Sender: TObject);
    procedure chkTabLinesClick(Sender: TObject);
    procedure chkConnectedClick(Sender: TObject);
    procedure chkDoubleLinesClick(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
  private
    glwCheckboxStateChanged: integer;
  public

  end;

var
  FramesDlg: TFramesDlg;

implementation

uses FEditor;

{$R *.DFM}

procedure TFramesDlg.FormShow(Sender: TObject);
var wFrameLineWidth, wFrameDistance, wFrameStyle,
  n: Integer;
begin
   // Get active MDI form data
  with FEditorTexto.TX do begin
        // Copy property values to local variables
    wFrameLineWidth := FrameLineWidth;
    wFrameDistance := FrameDistance;
    wFrameStyle := FrameStyle;
  end;

   // Set state of checkboxes
  chkLeft.Checked := (BF_LEFTLINE = (wFrameStyle and BF_LEFTLINE));
  chkRight.Checked := (BF_RIGHTLINE = (wFrameStyle and BF_RIGHTLINE));
  chkTop.Checked := (BF_TOPLINE = (wFrameStyle and BF_TOPLINE));
  chkBottom.Checked := (BF_BOTTOMLINE = (wFrameStyle and BF_BOTTOMLINE));
  chkTablines.Checked := (BF_TABLINES = (wFrameStyle and BF_TABLINES));
  chkConnected.Checked := (BF_BOXCONNECT = (wFrameStyle and BF_BOXCONNECT));
  chkDoubleLines.Checked := (BF_DOUBLE = (wFrameStyle and BF_DOUBLE));
  glwCheckboxStateChanged := 0;

   // Initialize combo boxes.
  for n := 1 to 12 do cboLineWidth.Items.Add(IntToStr(n) + ' pt');
  if wFrameLineWidth <> -1 then cboLineWidth.Text := IntToStr(trunc(wFrameLineWidth / 20)) + ' pt';

  for n := 0 to 12 do cboTextDistance.Items.Add(IntToStr(n) + ' pt');
  if wFrameDistance <> -1 then cboTextDistance.Text := IntToStr(trunc(wFrameDistance / 20)) + ' pt';

end;

procedure TFramesDlg.chkLeftClick(Sender: TObject);
begin
  glwCheckboxStateChanged := glwCheckboxStateChanged or BF_LEFTLINE;
end;

procedure TFramesDlg.chkRightClick(Sender: TObject);
begin
  glwCheckboxStateChanged := glwCheckboxStateChanged or BF_RIGHTLINE;
end;

procedure TFramesDlg.chkTopClick(Sender: TObject);
begin
  glwCheckboxStateChanged := glwCheckboxStateChanged or BF_TOPLINE;
end;

procedure TFramesDlg.chkBottomClick(Sender: TObject);
begin
  glwCheckboxStateChanged := glwCheckboxStateChanged or BF_BOTTOMLINE;
end;

procedure TFramesDlg.chkTabLinesClick(Sender: TObject);
begin
  glwCheckboxStateChanged := glwCheckboxStateChanged or BF_TABLINES;
end;

procedure TFramesDlg.chkConnectedClick(Sender: TObject);
begin
  glwCheckboxStateChanged := glwCheckboxStateChanged or BF_BOXCONNECT;
end;

procedure TFramesDlg.chkDoubleLinesClick(Sender: TObject);
begin
  glwCheckboxStateChanged := glwCheckboxStateChanged or BF_DOUBLE;
end;

procedure TFramesDlg.cmdOKClick(Sender: TObject);
var wNewFrameStyle,
  n,
    code: Integer;
begin
  { Get checkbox settings.
    The state of a checkbox is taken into account only if it
    has been changed by the user. This way, multiple selected
    paragraphs with different settings can be processed.}
  wNewFrameStyle := 0;
  if (BF_LEFTLINE = (glwCheckboxStateChanged and BF_LEFTLINE)) then begin
    if chkLeft.checked then
      wNewFrameStyle := wNewFrameStyle or BF_LEFTLINE
    else wNewFrameStyle := wNewFrameStyle or BF_NOLEFTLINE;
  end;

  if (BF_RIGHTLINE = (glwCheckboxStateChanged and BF_RIGHTLINE)) then begin
    if chkRight.checked then
      wNewFrameStyle := wNewFrameStyle or BF_RIGHTLINE
    else wNewFrameStyle := wNewFrameStyle or BF_NORIGHTLINE;
  end;

  if (BF_TOPLINE = (glwCheckboxStateChanged and BF_TOPLINE)) then begin
    if chkTop.checked then
      wNewFrameStyle := wNewFrameStyle or BF_TOPLINE
    else wNewFrameStyle := wNewFrameStyle or BF_NOTOPLINE;
  end;

  if (BF_BOTTOMLINE = (glwCheckboxStateChanged and BF_BOTTOMLINE)) then begin
    if chkBottom.checked then
      wNewFrameStyle := wNewFrameStyle or BF_BOTTOMLINE
    else wNewFrameStyle := wNewFrameStyle or BF_NOBOTTOMLINE;
  end;

  if (BF_TABLINES = (glwCheckboxStateChanged and BF_TABLINES)) then begin
    if chkTablines.checked then
      wNewFrameStyle := wNewFrameStyle or BF_TABLINES
    else wNewFrameStyle := wNewFrameStyle or BF_NOTABLINES;
  end;

  if (BF_BOXCONNECT = (glwCheckboxStateChanged and BF_BOXCONNECT)) then begin
    if chkConnected.checked then
      wNewFrameStyle := wNewFrameStyle or BF_BOXCONNECT;
  end;

  if (BF_DOUBLE = (glwCheckboxStateChanged and BF_DOUBLE)) then begin
    if chkDoubleLines.checked then
      wNewFrameStyle := wNewFrameStyle or BF_DOUBLE
    else wNewFrameStyle := wNewFrameStyle or BF_SINGLE;
  end;

  FEditorTexto.TX.FrameStyle := wNewFrameStyle;

  // Copy combobox settings, convert values to point
  if cboLineWidth.Text <> '' then begin
    Val(cboLineWidth.Text, n, Code);
    if (n < 1) then n := 1;
    if (n > 12) then n := 12;
    FEditorTexto.TX.FrameLineWidth := n * 20;
  end;

  if cboTextDistance.Text <> '' then begin
    Val(cboTextDistance.Text, n, Code);
    if (n < 0) then n := 0;
    if (n > 12) then n := 12;
    FEditorTexto.TX.FrameDistance := n * 20;
  end;

  // Quit dialog box
  Close;

end;

procedure TFramesDlg.cmdCancelClick(Sender: TObject);
begin
  close;
end;

end.
