unit pdfexport;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TfrmPDFOptions = class(TForm)
    chkUserPassword: TCheckBox;
    Label1: TLabel;
    txtUserPassword: TEdit;
    GroupBox1: TGroupBox;
    chkMasterPassword: TCheckBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    txtMasterPassword: TEdit;
    cboPrinting: TComboBox;
    cboChangesAllowed: TComboBox;
    chkAllowExtractContents: TCheckBox;
    chkAllowExtraAccessibility: TCheckBox;
    btnOK: TButton;
    btnCancel: TButton;
    procedure FormShow(Sender: TObject);
    procedure chkUserPasswordClick(Sender: TObject);
    procedure chkMasterPasswordClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmPDFOptionsDlg: TfrmPDFOptions;

implementation

uses TXGlobal, tx4olelib_TLB, FEditor;

{$R *.dfm}

procedure TfrmPDFOptions.FormShow(Sender: TObject);
var
  Flags: Integer;
  Pwd: string;
begin
  with FEditorTexto.TX do
  begin
    Flags := 0;
    Pwd := LoadSaveAttribute[txUserPassword];
    chkUserPassword.Checked := (Length(Pwd) > 0);

    txtUserPassword.text := Pwd;
    txtUserPassword.Enabled := chkUserPassword.Enabled;

    Pwd := LoadSaveAttribute[txMasterPassword];
    chkMasterPassword.Checked := (Length(Pwd) > 0);

    txtMasterPassword.text := Pwd;
    txtMasterPassword.Enabled := chkMasterPassword.Checked;

      // Printing combo box
    cboPrinting.Clear();
    cboPrinting.AddItem('None', nil);
    cboPrinting.AddItem('Low Resolution', nil);
    cboPrinting.AddItem('High Resolution', nil);

    Flags := LoadSaveAttribute[txDocAccessPermissions];

    if (Flags and PDF_Allow_HighLevelPrinting = PDF_Allow_HighLevelPrinting) then
      cboPrinting.ItemIndex := 2
    else if (Flags and PDF_Allow_LowLevelPrinting = PDF_Allow_LowLevelPrinting) then
      cboPrinting.ItemIndex := 1
    else
      cboPrinting.ItemIndex := 0;

    cboPrinting.Enabled := chkMasterPassword.Checked;

      // Changes Allowed combo box
    cboChangesAllowed.Clear();
    cboChangesAllowed.AddItem('None', nil);
    cboChangesAllowed.AddItem('Inserting, deleting and rotating pages', nil);
    cboChangesAllowed.AddItem('Filling in form fields and signing', nil);
    cboChangesAllowed.AddItem('Commenting, filling in form fields and signing', nil);
    cboChangesAllowed.AddItem('Any except extracting pages', nil);

    if ((Flags and (PDF_Allow_Authoring + PDF_Allow_DocumentAssembly + PDF_Allow_GeneralEditing)) =
      PDF_Allow_Authoring + PDF_Allow_DocumentAssembly + PDF_Allow_GeneralEditing) then
      cboChangesAllowed.ItemIndex := 4
    else if (Flags and PDF_Allow_Authoring) = PDF_Allow_Authoring then
      cboChangesAllowed.ItemIndex := 3
    else if (Flags and PDF_Allow_AuthoringFields) = PDF_Allow_AuthoringFields then
      cboChangesAllowed.ItemIndex := 2
    else if (Flags and PDF_Allow_DocumentAssembly) = PDF_Allow_DocumentAssembly then
      cboChangesAllowed.ItemIndex := 1
    else
      cboChangesAllowed.ItemIndex := 0;

    cboChangesAllowed.Enabled := chkMasterPassword.Checked;

      // Remaining 2 checkboxes
    chkAllowExtraAccessibility.Checked := (Flags and PDF_Allow_ContentAccessibility
      = PDF_Allow_ContentAccessibility);

    chkAllowExtractContents.Checked := (Flags and PDF_Allow_ExtractContents
      = PDF_Allow_ExtractContents);

    chkAllowExtraAccessibility.Enabled := chkMasterPassword.Checked;
    chkAllowExtractContents.Enabled := chkMasterPassword.Checked;
  end;
end;

procedure TfrmPDFOptions.chkUserPasswordClick(Sender: TObject);
begin
  if not chkUserPassword.Checked then
    txtUserPassword.Text := '';

  txtUserPassword.Enabled := chkUserPassword.Checked;
end;

procedure TfrmPDFOptions.chkMasterPasswordClick(Sender: TObject);
begin
  if not chkMasterPassword.Checked then
    txtMasterPassword.Text := '';

  txtMasterPassword.Enabled := chkMasterPassword.Checked;
  cboPrinting.Enabled := chkMasterPassword.Checked;
  cboChangesAllowed.Enabled := chkMasterPassword.Checked;
  chkAllowExtraAccessibility.Enabled := chkMasterPassword.Checked;
  chkAllowExtractContents.Enabled := chkMasterPassword.Checked;
end;


procedure TfrmPDFOptions.btnOKClick(Sender: TObject);
var
  Flags: Integer;

begin

  if (chkMasterPassword.Checked) and (Length(txtMasterPassword.Text) = 0) then

    Application.MessageBox('The ' + chr(32) + 'Use a password to restrict printing and editing of the ' +
      'document and its security settings option' + chr(32) + ' is selected, but the Permissions ' +
      'Password field is empty. Please enter a password or deselect the security option.',
      'TX Text Control Words', MB_OK + MB_ICONEXCLAMATION)

  else if (chkUserPassword.Checked) and (Length(txtUserPassword.Text) = 0) then
    Application.MessageBox('The "Require a password to open the document" option is selected, ' +
      'but the Document Open Password field is empty. Please enter a password or deselect ' +
      'the security option.', 'TX Text Control Words', MB_OK + MB_ICONEXCLAMATION)

  else if chkMasterPassword.Checked and chkUserPassword.Checked and
    (txtMasterPassword.Text = txtUserPassword.Text) then
    Application.MessageBox('The Document Open and Permissions passwords cannot be the same. ' +
      'Please enter a different password in either the Document Open Password field or ' +
      'the Permission Password field.', 'TX Text Control Words', MB_OK + MB_ICONEXCLAMATION)
  else begin
    with FEditorTexto.TX do begin
      LoadSaveAttribute[txUserPassword] := txtUserPassword.Text;
      LoadSaveAttribute[txMasterPassword] := txtMasterPassword.Text;

          // Printing combo box
      if cboPrinting.ItemIndex = 2 then
        Flags := Flags + PDF_Allow_HighLevelPrinting
      else if cboPrinting.ItemIndex = 1 then
        Flags := Flags + PDF_Allow_LowLevelPrinting;

          // Changes Allowed combo box
      if cboChangesAllowed.ItemIndex = 4 then
        Flags := Flags + PDF_Allow_Authoring + PDF_Allow_DocumentAssembly
          + PDF_Allow_GeneralEditing
      else if cboChangesAllowed.ItemIndex = 3 then
        Flags := Flags + PDF_Allow_Authoring
      else if cboChangesAllowed.ItemIndex = 2 then
        Flags := Flags + PDF_Allow_AuthoringFields
      else if cboChangesAllowed.ItemIndex = 1 then
        Flags := Flags + PDF_Allow_DocumentAssembly;

          // Remaining 2 checkboxes
      if chkAllowExtraAccessibility.Checked then
        Flags := Flags + PDF_Allow_ContentAccessibility;

      if chkAllowExtractContents.Checked then
        Flags := Flags + PDF_Allow_ExtractContents;

      LoadSaveAttribute[txDocAccessPermissions] := Flags;
    end;
  end;
end;

end.
